/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.City;
import gov.noaa.tsunami.websift.ee.ColorLUT;
import gov.noaa.tsunami.websift.ee.GSHHSReader;
import gov.noaa.tsunami.websift.ee.LandMass;
import gov.noaa.tsunami.websift.ee.MOSTGrid;
import gov.noaa.tsunami.websift.ee.MOSTGridHA;
import gov.noaa.tsunami.websift.ee.RunupDataFrame;
import gov.noaa.tsunami.websift.ee.SourceInfoFrame;
import gov.noaa.tsunami.websift.ee.StarShape;
import gov.noaa.tsunami.websift.ee.TileDownloader;
import gov.noaa.tsunami.websift.ee.TopoShape;
import gov.noaa.tsunami.websift.events.Runup;
import gov.noaa.tsunami.websift.propdb.Range2D;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class TopoCanvas
extends JComponent {
    public static Logger log = Logger.getLogger(TopoCanvas.class.getName());
    private BufferedImage biZoomIn;
    private BufferedImage biZoomOut;
    private BufferedImage biPanRight;
    private BufferedImage biPanLeft;
    private BufferedImage biPanUp;
    private BufferedImage biPanDown;
    private BufferedImage biHome;
    private Rectangle2D.Double panUpRec;
    private Rectangle2D.Double panLeftRec;
    private Rectangle2D.Double panRightRec;
    private Rectangle2D.Double panDownRec;
    private Rectangle2D.Double zoomInRec;
    private Rectangle2D.Double zoomOutRec;
    private Rectangle2D.Double homeRec;
    private static Color backColor = new Color(128, 128, 128);
    private static final BasicStroke thickStroke = new BasicStroke(5.0f, 2, 1);
    private static final BasicStroke starStroke = new BasicStroke(3.2f, 2, 0);
    private static final BasicStroke stroke = new BasicStroke(1.3f, 2, 1);
    private static final BasicStroke thinStroke = new BasicStroke(0.75f);
    private static final BasicStroke dashedStroke = new BasicStroke(1.3f, 1, 0, 1.5f, new float[]{5.0f, 5.0f}, 0.0f);
    private Timer panTimer;
    public static final int PAN_RIGHT = 1;
    public static final int PAN_LEFT = 2;
    public static final int PAN_UP = 3;
    public static final int PAN_DOWN = 4;
    private int lastPan = 1;
    private boolean isPanning = false;
    private boolean goingHome = false;
    private static double aspectRatio = 1.2121212121212122;
    private Point2D pointerLocation = new Point2D.Double();
    private boolean rubberBanding = false;
    private Rectangle2D.Double rubberRect = new Rectangle2D.Double();
    private static final Color rubberColor = new Color(200, 200, 200);
    private int lastX;
    private int lastY;
    private double currentX;
    private double currentY;
    private double scale = 1.0;
    private double zoomScaleDelta = 1.15;
    private int zoomLevel;
    private int tileLevel = 3;
    private int maxZoomLevel = 28;
    private int minZoomLevel = -2;
    private boolean smoothZoom = false;
    private boolean navLock = false;
    private Rectangle2D.Double homeLatLonRec = new Rectangle2D.Double(123.5, -59.5, 167.0, 119.0);
    private AffineTransform worldToPixel = new AffineTransform();
    private AffineTransform pixelToWorld = new AffineTransform();
    Rectangle2D.Double windowExtents = new Rectangle2D.Double();
    private ArrayList<TopoShape> gobs = new ArrayList();
    private HashMap<Image, Rectangle2D.Double> imageExtents = new HashMap();
    private LinkedHashMap<Image, AffineTransform> imageTransforms = new LinkedHashMap();
    private boolean plotImages = false;
    private double imageAlpha = 1.0;
    private HashMap<Image, Rectangle2D.Double> tileExtents = new HashMap();
    private HashMap<Image, AffineTransform> tileTransforms = new HashMap();
    private boolean plotTiles = false;
    private Thread tileThread = null;
    private final TileDownloader tileDownloader;
    private boolean paintingTiles = false;
    private String copyText = "Tiles \u00a9OpenStreetMap - NOAA";
    private MOSTGrid maxGrid = null;
    private ColorLUT maxColors = null;
    private boolean plotMaxAmp = false;
    private MOSTGridHA haGrid = null;
    private ColorLUT haColors = null;
    private boolean plotHA = false;
    private BufferedImage colorbarImage = null;
    private BufferedImage chgColorbarImage = null;
    private boolean plotColorbar = false;
    private boolean plotCHGColorbar = false;
    private HashMap<Double, GeneralPath> travelTimes = new HashMap();
    private ArrayList<TopoShape> travelTimeLabels = new ArrayList();
    private Color travelTimeColor = new Color(255, 255, 255);
    private boolean plotTravelTimes = false;
    private boolean travelTimesDashed = false;
    private StarShape epicenter = new StarShape(20.0, 20.0, 5.0, 5.0, 13, 1.0, aspectRatio);
    private boolean plotEpicenter = false;
    private boolean movingEpicenter = false;
    private ArrayList<TopoShape> quakes;
    private ArrayList<TopoShape> clickedQuakes = new ArrayList();
    private boolean plotQuakes = false;
    private ArrayList<Runup> runups;
    private String runupEventID = "none";
    private boolean plotRunups = false;
    private ArrayList<TopoShape> plateShapes;
    private boolean plotPlateShapes = false;
    private ArrayList<UnitSource> unitSources = new ArrayList();
    private Color unitSourceEdgeColor = Color.red;
    private boolean plotSources = false;
    private boolean selectDB = false;
    private ArrayList<UnitSource> activeSources = new ArrayList();
    private ArrayList<TopoShape> sourceCenters = new ArrayList();
    private boolean plotSourceCenters = false;
    private boolean plotSites = false;
    private Rectangle2D aGridPoly = new Rectangle2D.Double();
    private Rectangle2D bGridPoly = new Rectangle2D.Double();
    private Rectangle2D cGridPoly = new Rectangle2D.Double();
    private Shape propGridPoly = new Path2D.Double();
    private static final Color aGridColor = new Color(109, 254, 65);
    private static final Color bGridColor = new Color(239, 254, 70);
    private static final Color cGridColor = new Color(254, 62, 51);
    private static final Color propGridColor = new Color(245, 202, 81);
    private Image backgroundImage = null;
    private AffineTransform backgroundTransform = null;
    private boolean plotBackground = false;
    private boolean plotGreensLaw = false;
    private ArrayList<TopoShape> greensLine = null;
    private boolean plotCoastalGauges = false;
    private ArrayList<TopoShape> coastalGauges = null;
    private boolean plotDartBuoys = false;
    private ArrayList<TopoShape> dartBuoys = null;
    private boolean plotWarningPolys = false;
    private ArrayList<TopoShape> warningPolys = null;
    private ArrayList<TopoShape> clickedPolys = new ArrayList();
    private boolean plotEvacMaps = false;
    private HashMap<String, ArrayList<TopoShape>> evacShapeMap = null;
    private ArrayList<Area> landMasses = new ArrayList();
    private LinkedHashMap<ArrayList<Area>, Integer> landMassesLOD = new LinkedHashMap();
    private ArrayList<LandMass> borderMasses = new ArrayList();
    private ArrayList<Area> borderAreas = new ArrayList();
    private Color landColor = new Color(85, 85, 85);
    private Color borderColor = new Color(155, 155, 155);
    private static final BasicStroke borderStroke = new BasicStroke(1.5f, 2, 1);
    private boolean plotLand = false;
    private boolean plotBorders = false;
    private HashMap<String, Point2D.Float> countryNames = new HashMap();
    private Font countryFontBig = new Font("Dialog", 1, 15);
    private Font countryFontSmall = new Font("Dialog", 1, 12);
    private Font countryFont = this.countryFontBig;
    private boolean plotCountryNames = false;
    private LinkedHashMap<City, Ellipse2D.Float> cityNames = new LinkedHashMap();
    private Font cityFontBig = new Font("Dialog", 0, 12);
    private Font cityFontSmall = new Font("Dialog", 0, 10);
    private Font cityFont = this.cityFontBig;
    private boolean plotCityNames = false;
    private GeneralPath grats = null;
    private boolean plotGraticules = false;
    private Color gratColor = new Color(255, 0, 0);
    private boolean gratsDashed = false;
    private boolean plotOverlayText = false;
    private Font overlayFont = new Font("Dialog", 2, 15);
    private ArrayList<OverlayText> overlayList = new ArrayList();
    private Cursor starCursor = new Cursor(13);
    private boolean pickPoints = false;

    public TopoCanvas() {
        this.initializeButtons();
        MouseHandler mh = new MouseHandler();
        this.addMouseListener(mh);
        this.addMouseMotionListener(mh);
        this.addMouseWheelListener(mh);
        this.tileDownloader = new TileDownloader(this);
        this.zoomLevel = this.scaleToZoomLevel(1.0);
        this.scale = this.zoomLevelToScale(this.zoomLevel);
        BufferedImage im = null;
        try {
            URL url = this.getClass().getResource("images/star.gif");
            if (url != null) {
                im = ImageIO.read(url);
                this.starCursor = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(7, 7), "img");
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        this.updateWorldTransform();
    }

    public void setLog(Logger l) {
        log = l;
        this.tileDownloader.setLogger(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void paintComponent(Graphics g) {
        Object colors;
        Iterator<TopoShape> composite;
        AffineTransform itx;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        AffineTransform tx = this.getPanAndZoomTransform();
        AffineTransform stx = new AffineTransform(tx);
        stx.concatenate(this.worldToPixel);
        this.windowExtents = this.getWindowExtents();
        g2.setColor(backColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.plotBackground) {
            itx = new AffineTransform(tx);
            itx.concatenate(this.backgroundTransform);
            g2.drawImage(this.backgroundImage, itx, this);
        }
        if (this.plotTiles) {
            try {
                for (Map.Entry<Image, AffineTransform> entry : this.tileTransforms.entrySet()) {
                    itx = new AffineTransform(tx);
                    itx.concatenate(entry.getValue());
                    g2.drawImage(entry.getKey(), itx, this);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.paintingTiles = false;
        }
        if (this.plotImages) {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            composite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, (float)this.imageAlpha));
            for (Map.Entry<Image, AffineTransform> entry : this.imageTransforms.entrySet()) {
                itx = new AffineTransform(tx);
                itx.concatenate(entry.getValue());
                g2.drawImage(entry.getKey(), itx, this);
            }
            g2.setComposite((Composite)((Object)composite));
        }
        if (this.plotMaxAmp) {
            void var7_20;
            colors = this.maxColors.getColors();
            boolean bl = false;
            while (var7_20 < this.maxGrid.getNumLons()) {
                for (int i = 0; i < this.maxGrid.getNumLats(); ++i) {
                    if (((Color)colors[i][var7_20]).getAlpha() <= 0) continue;
                    g2.setColor((Color)colors[i][var7_20]);
                    g2.fill(stx.createTransformedShape(this.maxGrid.getRect((int)var7_20, i)));
                }
                ++var7_20;
            }
        }
        if (this.plotLand) {
            for (Map.Entry entry : this.landMassesLOD.entrySet()) {
                if ((Integer)entry.getValue() < this.zoomLevel) continue;
                this.landMasses = (ArrayList)entry.getKey();
                break;
            }
            g2.setColor(this.landColor);
            for (Area area : this.landMasses) {
                if (!area.intersects(this.windowExtents)) continue;
                g2.fill(stx.createTransformedShape(area));
            }
        }
        if (this.plotHA) {
            void var7_24;
            colors = this.haColors.getColors();
            boolean bl = false;
            while (var7_24 < this.haGrid.nLons) {
                for (int i = 0; i < this.haGrid.nLats; ++i) {
                    if (((Color)colors[i][var7_24]).getAlpha() <= 0) continue;
                    g2.setColor((Color)colors[i][var7_24]);
                    g2.fill(stx.createTransformedShape(this.haGrid.getRect((int)var7_24, i)));
                }
                ++var7_24;
            }
        }
        if (this.plotBorders) {
            g2.setStroke(borderStroke);
            g2.setColor(Color.green);
            for (LandMass landMass : this.borderMasses) {
                g2.draw(stx.createTransformedShape(landMass));
            }
        }
        if (this.plotTravelTimes) {
            g2.setColor(this.travelTimeColor);
            if (this.travelTimesDashed) {
                g2.setStroke(dashedStroke);
            } else {
                g2.setStroke(stroke);
            }
            for (Map.Entry entry : this.travelTimes.entrySet()) {
                g2.draw(stx.createTransformedShape((Shape)entry.getValue()));
            }
            for (TopoShape topoShape : this.travelTimeLabels) {
                g2.setColor(topoShape.getFontColor());
                g2.setFont(topoShape.getFont());
                Shape shape = topoShape.getShape();
                PathIterator pi = shape.getPathIterator(stx);
                float[] coords = new float[2];
                pi.currentSegment(coords);
                g2.drawString(topoShape.getLabel(), coords[0] + 2.0f, coords[1] + 2.0f);
            }
        }
        if (this.plotSources) {
            composite = g2.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.55f);
            g2.setStroke(thinStroke);
            ArrayList<UnitSource> arrayList = this.unitSources;
            synchronized (arrayList) {
                for (UnitSource u : this.unitSources) {
                    if (u.isActive()) {
                        g2.setColor(Color.white);
                        g2.setComposite(alphaComposite);
                        g2.fill(stx.createTransformedShape(u));
                        g2.setComposite((Composite)((Object)composite));
                    }
                    g2.setColor(this.unitSourceEdgeColor);
                    g2.draw(stx.createTransformedShape(u));
                }
            }
        }
        if (this.plotSourceCenters) {
            g2.setColor(Color.blue);
            for (TopoShape topoShape : this.sourceCenters) {
                g2.fill(stx.createTransformedShape(topoShape.getShape()));
            }
        }
        if (this.plotEvacMaps) {
            composite = g2.getComposite();
            for (ArrayList<TopoShape> arrayList : this.evacShapeMap.values()) {
                for (TopoShape ts : arrayList) {
                    g2.setComposite(AlphaComposite.getInstance(3, ts.getAlpha()));
                    g2.setColor(ts.getFillColor());
                    g2.fill(stx.createTransformedShape(ts.getShape()));
                }
            }
            g2.setComposite((Composite)((Object)composite));
        }
        if (this.plotPlateShapes) {
            for (TopoShape topoShape : this.plateShapes) {
                g2.setColor(topoShape.getDrawColor());
                g2.setStroke(stroke);
                g2.draw(stx.createTransformedShape(topoShape.getShape()));
            }
        }
        if (this.plotWarningPolys) {
            g2.setStroke(stroke);
            composite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            for (TopoShape topoShape : this.warningPolys) {
                if (topoShape.getDraw()) {
                    g2.setColor(topoShape.getDrawColor());
                    g2.draw(stx.createTransformedShape(topoShape.getShape()));
                }
                if (!topoShape.getFill()) continue;
                g2.setColor(topoShape.getFillColor());
                g2.fill(stx.createTransformedShape(topoShape.getShape()));
            }
            g2.setComposite((Composite)((Object)composite));
        }
        if (this.plotGreensLaw) {
            for (TopoShape topoShape : this.greensLine) {
                g2.setColor(topoShape.getDrawColor());
                g2.setStroke(thickStroke);
                g2.draw(stx.createTransformedShape(topoShape.getShape()));
            }
        }
        if (this.plotCoastalGauges) {
            float radius = 2.0f / (float)Math.pow(this.scale, 0.75);
            for (TopoShape topoShape : this.coastalGauges) {
                Ellipse2D.Float circ = (Ellipse2D.Float)topoShape.getShape();
                circ.height = radius;
                circ.width = radius * (float)aspectRatio;
                Point2D.Float lpt = topoShape.getLabelCoords();
                circ.x = lpt.x - circ.width / 2.0f;
                circ.y = lpt.y - circ.height / 2.0f;
                g2.setColor(topoShape.getFillColor());
                g2.fill(stx.createTransformedShape(circ));
            }
        }
        if (this.plotSites) {
            g2.setColor(propGridColor);
            g2.draw(stx.createTransformedShape(this.propGridPoly));
        }
        if (this.plotDartBuoys) {
            g2.setFont(this.countryFontSmall);
            for (TopoShape topoShape : this.dartBuoys) {
                g2.setColor(topoShape.getFillColor());
                g2.fill(stx.createTransformedShape(topoShape.getShape()));
                Point2D.Float float_ = new Point2D.Float(topoShape.getLabelCoords().x, topoShape.getLabelCoords().y);
                stx.transform(float_, float_);
                g2.drawString(topoShape.getLabel(), float_.x + 4.0f, float_.y - 4.0f);
            }
        }
        for (TopoShape topoShape : this.gobs) {
            void var8_58;
            if (topoShape.getFill()) {
                Object var8_53 = null;
                if (topoShape.getTransparent()) {
                    Composite composite2 = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, topoShape.getAlpha()));
                }
                g2.setColor(topoShape.getFillColor());
                g2.fill(stx.createTransformedShape(topoShape.getShape()));
                if (topoShape.getTransparent()) {
                    void var8_55;
                    g2.setComposite((Composite)var8_55);
                }
            }
            if (topoShape.getDraw()) {
                g2.setColor(topoShape.getDrawColor());
                g2.setStroke(stroke);
                g2.draw(stx.createTransformedShape(topoShape.getShape()));
            }
            if (!topoShape.isLabel()) continue;
            g2.setColor(topoShape.getFontColor());
            g2.setFont(topoShape.getFont());
            Point2D.Float float_ = topoShape.getLabelCoords();
            if (float_ == null) {
                Shape s = topoShape.getShape();
                PathIterator pi = s.getPathIterator(null);
                float[] fArray = new float[2];
                pi.currentSegment(fArray);
                Point2D.Float float_2 = new Point2D.Float(fArray[0] + 2.0f, fArray[1] + 2.0f);
            }
            Point2D.Float ptx = new Point2D.Float(var8_58.x, var8_58.y);
            stx.transform(ptx, ptx);
            int lineHeight = g2.getFontMetrics().getHeight();
            for (String line : topoShape.getLabel().split("\n")) {
                g2.drawString(line, ptx.x, ptx.y += (float)lineHeight);
            }
        }
        if (this.plotQuakes) {
            Object selectedQuake = null;
            for (TopoShape topoShape : this.quakes) {
                g2.setColor(topoShape.getFillColor());
                g2.fill(stx.createTransformedShape(topoShape.getShape()));
                if (!topoShape.getDraw()) continue;
                selectedQuake = topoShape;
            }
            if (selectedQuake != null) {
                g2.setColor(((TopoShape)selectedQuake).getDrawColor());
                g2.setStroke(thickStroke);
                g2.draw(stx.createTransformedShape(((TopoShape)selectedQuake).getShape()));
            }
        }
        if (this.plotRunups) {
            for (Runup runup : this.runups) {
                if (!runup.getEvent_id().equals(this.runupEventID)) continue;
                runup.setScale(10.0 / this.scale);
                g2.setColor(Color.BLACK);
                g2.setStroke(thinStroke);
                g2.draw(stx.createTransformedShape(runup));
                g2.setColor(runup.getFillColor());
                g2.fill(stx.createTransformedShape(runup));
            }
        }
        if (this.plotCityNames) {
            g2.setFont(this.cityFont);
            g2.setColor(new Color(25, 25, 25));
            float radius = 1.0f / (float)this.scale;
            boolean bl = false;
            try {
                for (Map.Entry<City, Ellipse2D.Float> e : this.cityNames.entrySet()) {
                    void var7_40;
                    Ellipse2D.Float ellipse = e.getValue();
                    Point2D.Float float_ = new Point2D.Float(ellipse.x, ellipse.y);
                    if (!this.windowExtents.contains(float_)) continue;
                    ellipse.width = radius;
                    ellipse.height = radius;
                    g2.fill(stx.createTransformedShape(ellipse));
                    stx.transform(float_, float_);
                    g2.drawString(e.getKey().getName(), float_.x + 4.0f, float_.y - 4.0f);
                    if (++var7_40 <= 25) continue;
                    break;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        if (this.plotCountryNames) {
            g2.setFont(this.countryFont);
            g2.setColor(Color.BLACK);
            FontMetrics metrics = g2.getFontMetrics(this.countryFont);
            for (Map.Entry<String, Point2D.Float> entry : this.countryNames.entrySet()) {
                Point2D.Float pt = new Point2D.Float();
                stx.transform(entry.getValue(), pt);
                g2.drawString(entry.getKey(), pt.x - (float)(metrics.stringWidth(entry.getKey()) / 2), pt.y);
            }
        }
        if (this.rubberBanding && this.rubberRect != null) {
            g2.setColor(rubberColor);
            g2.draw(stx.createTransformedShape(this.rubberRect));
        }
        if (this.plotEpicenter) {
            double radius = 8.0 / this.scale;
            this.epicenter.setRaDius(radius);
            g2.setColor(Color.BLACK);
            g2.setStroke(starStroke);
            g2.draw(stx.createTransformedShape(this.epicenter));
        }
        if (this.plotGraticules) {
            g2.setColor(this.gratColor);
            if (this.gratsDashed) {
                g2.setStroke(dashedStroke);
            } else {
                g2.setStroke(thinStroke);
            }
            g2.draw(stx.createTransformedShape(this.grats));
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(thinStroke);
        g2.draw(this.zoomInRec);
        g2.draw(this.zoomOutRec);
        g2.draw(this.panUpRec);
        g2.draw(this.panLeftRec);
        g2.draw(this.panRightRec);
        g2.draw(this.panDownRec);
        g2.draw(this.homeRec);
        g2.drawImage(this.biPanUp, null, 10, 10);
        g2.drawImage(this.biPanLeft, null, 1, 30);
        g2.drawImage(this.biPanRight, null, 19, 30);
        g2.drawImage(this.biPanDown, null, 10, 50);
        g2.drawImage(this.biZoomIn, null, 10, 80);
        g2.drawImage(this.biZoomOut, null, 10, 100);
        g2.drawImage(this.biHome, null, 10, 130);
        if (this.plotColorbar) {
            g2.drawImage(this.colorbarImage, null, this.getWidth() - this.colorbarImage.getWidth(), this.getHeight() - this.colorbarImage.getHeight() - 15);
        }
        if (this.plotCHGColorbar) {
            g2.drawImage(this.chgColorbarImage, null, this.getWidth() - this.chgColorbarImage.getWidth() - 80, this.getHeight() - this.chgColorbarImage.getHeight() - 20);
        }
        if (this.plotOverlayText) {
            for (OverlayText overlayText : this.overlayList) {
                g2.setFont(overlayText.font);
                g2.setColor(overlayText.color);
                g2.drawString(overlayText.text, (int)((double)this.getWidth() * overlayText.xfraction), (int)((double)this.getHeight() * overlayText.yfraction));
            }
        }
        if (this.plotTiles) {
            g2.setFont(this.cityFont);
            g2.setColor(Color.LIGHT_GRAY);
            FontMetrics metrics = g2.getFontMetrics(this.cityFont);
            int n = metrics.stringWidth(this.copyText);
            g2.fillRect(this.getWidth() - n - 4, this.getHeight() - 15, n + 4, 15);
            g2.setColor(Color.BLACK);
            g2.drawString(this.copyText, this.getWidth() - n - 2, this.getHeight() - 1);
        }
        g2.dispose();
    }

    private void initializeButtons() {
        this.panUpRec = new Rectangle2D.Double(10.0, 10.0, 18.0, 18.0);
        this.panLeftRec = new Rectangle2D.Double(1.0, 30.0, 18.0, 18.0);
        this.panRightRec = new Rectangle2D.Double(19.0, 30.0, 18.0, 18.0);
        this.panDownRec = new Rectangle2D.Double(10.0, 50.0, 18.0, 18.0);
        this.zoomInRec = new Rectangle2D.Double(10.0, 80.0, 18.0, 18.0);
        this.zoomOutRec = new Rectangle2D.Double(10.0, 100.0, 18.0, 18.0);
        this.homeRec = new Rectangle2D.Double(10.0, 130.0, 18.0, 18.0);
        try {
            this.biZoomIn = ImageIO.read(this.getClass().getResourceAsStream("images/zoomin.png"));
            this.biZoomOut = ImageIO.read(this.getClass().getResourceAsStream("images/zoomout.png"));
            this.biPanRight = ImageIO.read(this.getClass().getResourceAsStream("images/panright.png"));
            this.biPanLeft = ImageIO.read(this.getClass().getResourceAsStream("images/panleft.png"));
            this.biPanUp = ImageIO.read(this.getClass().getResourceAsStream("images/panup.png"));
            this.biPanDown = ImageIO.read(this.getClass().getResourceAsStream("images/pandown.png"));
            this.biHome = ImageIO.read(this.getClass().getResourceAsStream("images/home.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvas.this.repeatPan();
            }
        });
        this.panTimer.setInitialDelay(500);
    }

    public void setAspectRatio(double aspect) {
        aspectRatio = aspect;
    }

    public double getAspectRatio() {
        return aspectRatio;
    }

    public Color getBackgroundColor() {
        return backColor;
    }

    public void setBackgroundColor(Color c) {
        backColor = c;
    }

    public Color getLandColor() {
        return this.landColor;
    }

    public void setLandColor(Color c) {
        this.landColor = c;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        log.fine("TopoCanvas, w: " + w + " h: " + h);
        if (w < 1000 || h < 800) {
            this.countryFont = this.countryFontSmall;
            this.cityFont = this.cityFontSmall;
        } else {
            this.countryFont = this.countryFontBig;
            this.cityFont = this.cityFontBig;
        }
    }

    public Rectangle2D.Double getWindowExtents() {
        Point2D ul = this.getTranslatedPoint(0.0, 0.0);
        Point2D lr = this.getTranslatedPoint(this.getWidth(), this.getHeight());
        this.pixelToWorld.transform(ul, ul);
        this.pixelToWorld.transform(lr, lr);
        return new Rectangle2D.Double(ul.getX(), lr.getY(), lr.getX() - ul.getX(), ul.getY() - lr.getY());
    }

    private void updateWorldTransform() {
        double sy = -3.3333333333333335;
        double sx = -sy / aspectRatio;
        double ty = 225.0;
        this.worldToPixel = new AffineTransform(sx, 0.0, 0.0, sy, 0.0, ty);
        try {
            this.pixelToWorld = this.worldToPixel.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        this.updateImageTransforms();
        this.tileDownloader.setWorldTransform(this.worldToPixel);
    }

    private void updateImageTransforms() {
        Image image;
        for (Map.Entry<Image, Rectangle2D.Double> e : this.imageExtents.entrySet()) {
            image = e.getKey();
            this.imageTransforms.put(image, this.getImageTransform(image, e.getValue()));
        }
        for (Map.Entry<Image, Rectangle2D.Double> e : this.tileExtents.entrySet()) {
            image = e.getKey();
            this.tileTransforms.put(image, this.getImageTransform(image, e.getValue()));
        }
    }

    private AffineTransform getImageTransform(Image im, Rectangle2D.Double rec) {
        Point2D ul = new Point2D.Double(rec.x, rec.y + rec.height);
        Point2D lr = new Point2D.Double(rec.x + rec.width, rec.y);
        ul = this.worldToPixel.transform(ul, ul);
        lr = this.worldToPixel.transform(lr, lr);
        double sx = (lr.getX() - ul.getX()) / (double)im.getWidth(this);
        double sy = (lr.getY() - ul.getY()) / (double)im.getHeight(this);
        double tx = ul.getX();
        double ty = ul.getY();
        return new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
    }

    public void addImage(Image im, Rectangle2D.Double extents) {
        this.imageExtents.put(im, extents);
        this.imageTransforms.put(im, this.getImageTransform(im, extents));
        this.plotImages(true);
    }

    public void removeImage(Image im) {
        this.imageExtents.remove(im);
        this.imageTransforms.remove(im);
    }

    public void plotImages(boolean b) {
        this.plotImages = b;
        this.repaint();
    }

    public void clearImages() {
        this.imageExtents.clear();
        this.imageTransforms.clear();
        this.repaint();
    }

    public void setImageTransparency(double alpha) {
        this.imageAlpha = alpha;
        this.repaint();
    }

    public void plotTiles(boolean b) {
        this.plotTiles = b;
        this.useTiles(this.zoomLevel);
        this.repaint();
    }

    public void clearTiles() {
        this.tileExtents.clear();
        this.tileTransforms.clear();
        this.repaint();
    }

    public void plotBackground(boolean b) {
        this.plotBackground = b;
        if (this.plotBackground && this.backgroundImage == null) {
            try {
                this.backgroundImage = ImageIO.read(this.getClass().getResource("images/world_all_4096x2048comp.jpg"));
                this.backgroundTransform = this.getImageTransform(this.backgroundImage, new Rectangle2D.Double(0.0, -90.0, 360.0, 180.0));
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                this.plotBackground = false;
            }
        }
        this.repaint();
    }

    public void setBackgroundImage(String resourceURLstring) {
        this.setBackgroundImage(resourceURLstring, new Rectangle2D.Double(0.0, -90.0, 360.0, 180.0));
    }

    public void setBackgroundImage(String resourceURLstring, Rectangle2D.Double rec) {
        try {
            URL resourceURL = new URL(resourceURLstring);
            this.backgroundImage = ImageIO.read(resourceURL);
            this.backgroundTransform = this.getImageTransform(this.backgroundImage, rec);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
            this.plotBackground = false;
        }
    }

    public void setBackgroundImage(BufferedImage bi) {
        this.setBackgroundImage(bi, new Rectangle2D.Double(0.0, -90.0, 360.0, 180.0));
    }

    public void setBackgroundImage(BufferedImage bi, Rectangle2D.Double rec) {
        this.backgroundImage = bi;
        this.backgroundTransform = this.getImageTransform(this.backgroundImage, rec);
    }

    public void plotOverlayText(boolean b) {
        this.plotOverlayText = b;
        this.repaint();
    }

    public void addOverlayText(double xfrac, double yfrac, String txt) {
        this.overlayList.add(new OverlayText(xfrac, yfrac, txt, this.overlayFont, Color.BLACK));
    }

    public void addOverlayText(double xfrac, double yfrac, String txt, Font f, Color c) {
        this.overlayList.add(new OverlayText(xfrac, yfrac, txt, f, c));
        this.repaint();
    }

    public void clearOverlayText() {
        this.overlayList.clear();
    }

    public void setColorbarImage(BufferedImage im) {
        this.colorbarImage = im;
    }

    public void plotColorbar(boolean b) {
        if (b && this.colorbarImage == null) {
            log.warning("Attempting to set plotColorbar to true when colorbarImage is null");
            return;
        }
        this.plotColorbar = b;
        this.repaint();
    }

    public void setCHGColorbarImage(BufferedImage im) {
        this.chgColorbarImage = im;
    }

    public void plotCHGColorbar(boolean b) {
        if (b && this.chgColorbarImage == null) {
            log.warning("Attempting to set plotCHGColorbar to true when chgColorbarImage is null");
            return;
        }
        this.plotCHGColorbar = b;
        this.repaint();
    }

    public void setQuakes(ArrayList<TopoShape> quakes) {
        this.quakes = quakes;
    }

    public void plotQuakes(boolean b) {
        if (b && this.quakes == null) {
            log.warning("Attempting to set plotQuakes to true when quakes is null");
            return;
        }
        this.plotQuakes = b;
        this.repaint();
    }

    public ArrayList<TopoShape> getClickedQuakes() {
        return this.clickedQuakes;
    }

    public void setMaxAmp(MOSTGrid grid, ColorLUT lut) {
        this.maxGrid = grid;
        this.maxColors = lut;
        this.plotMaxAmp = true;
    }

    public void plotMaxAmp(boolean b) {
        if (b && this.maxGrid == null) {
            log.warning("Attempting to set plotMaxAmp to true when maxGrid is null");
            return;
        }
        this.plotMaxAmp = b;
        this.repaint();
    }

    public void setHA(MOSTGridHA grid, ColorLUT lut) {
        this.haGrid = grid;
        this.haColors = lut;
        this.plotHA = true;
    }

    public void plotHA(boolean b) {
        if (b && this.haGrid == null) {
            log.warning("Attempting to set plotHA to true when haGrid is null");
            return;
        }
        this.plotHA = b;
        this.repaint();
    }

    public void setCoastalGauges(ArrayList<TopoShape> ts) {
        this.coastalGauges = ts;
    }

    public void plotCoastalGauges(boolean b) {
        if (b && this.coastalGauges == null) {
            log.warning("Attempting to set plotCoastalGauges to grue when coastalGauges is null");
            return;
        }
        this.plotCoastalGauges = b;
        this.repaint();
    }

    public void setDARTBuoys(ArrayList<TopoShape> ts) {
        this.dartBuoys = ts;
    }

    public void plotDartBuoys(boolean b) {
        if (b && this.dartBuoys == null) {
            log.warning("Attempting to set plotDartBuoys to grue when dartBuoys is null");
            return;
        }
        this.plotDartBuoys = b;
        this.repaint();
    }

    public void setGreensLaw(ArrayList<TopoShape> ts) {
        this.greensLine = ts;
    }

    public void plotGreensLaw(boolean b) {
        if (b && this.greensLine == null) {
            log.warning("Attempting to set plotGreenslaw to true when greensLine is null");
            return;
        }
        this.plotGreensLaw = b;
        this.repaint();
    }

    public void setWarningPolys(ArrayList<TopoShape> ts) {
        this.warningPolys = ts;
    }

    public void plotWarningPolys(boolean b) {
        if (b && this.warningPolys == null) {
            log.warning("Attempting to set plotWarningPolys to true when warningPolys is null");
            return;
        }
        this.plotWarningPolys = b;
        this.repaint();
    }

    public void setEvacMaps(HashMap<String, ArrayList<TopoShape>> m) {
        this.evacShapeMap = m;
    }

    public void plotEvacMaps(boolean b) {
        if (b && this.evacShapeMap == null) {
            log.warning("Attempting to set plotEvacMaps to true when evacShapMap is null");
            return;
        }
        this.plotEvacMaps = b;
        this.repaint();
    }

    public void setPlateBoundaries(ArrayList<TopoShape> al) {
        this.plateShapes = al;
    }

    public void plotPlateBoundaries(boolean b) {
        if (b && this.plateShapes == null) {
            log.warning("Attempting to set plotPlateBoundaries to true when plateShapes is null");
            return;
        }
        this.plotPlateShapes = b;
        this.repaint();
    }

    public void setRunups(ArrayList<Runup> r) {
        this.runups = r;
    }

    public void setRunupsEventId(String eid) {
        this.runupEventID = eid;
    }

    public void plotRunups(boolean b) {
        if (b && this.runups == null) {
            log.warning("Attempting to set plotRunups to true when runups is null");
            return;
        }
        this.plotRunups = b;
        this.repaint();
    }

    public void addShape(Shape shape, Color fillColor, Color drawColor, String text, Color fontColor, Font font) {
        TopoShape ts = new TopoShape(shape);
        if (fillColor != null) {
            ts.setFillColor(fillColor);
        }
        if (drawColor != null) {
            ts.setDrawColor(drawColor);
        }
        if (fontColor != null) {
            ts.setFontColor(fontColor);
        }
        if (font != null) {
            ts.setFont(font);
        }
        if (text != null) {
            ts.setLabel(text);
        }
        this.addTopoShape(ts);
    }

    public void addTopoShape(TopoShape topoShape) {
        this.gobs.add(topoShape);
        this.repaint();
    }

    public void clearTopoShapes() {
        this.gobs.clear();
        this.repaint();
    }

    public void addLandMass(File f) throws IOException {
        this.addLandMass(f, null, this.maxZoomLevel);
    }

    public void addLandMass(File f, Rectangle2D rec) throws IOException {
        this.addLandMass(f, rec, this.maxZoomLevel);
    }

    public void addLandMass(File f, Rectangle2D rec, int zoomLimit) throws IOException {
        ArrayList<Area> lma = null;
        lma = GSHHSReader.getAreas(f, rec);
        lma = GSHHSReader.tileAreas(lma);
        this.landMassesLOD.put(lma, zoomLimit);
        this.plotLand = true;
        this.repaint();
    }

    public void addLandMass(File f, int zoomLimit) throws IOException {
        ArrayList<Area> lma = GSHHSReader.getTileAreas(f);
        this.addLandMass(lma, zoomLimit);
    }

    public void addLandMass(URI uri, int zoomLimit) throws IOException {
        ArrayList<Area> lma = GSHHSReader.getTileAreas(uri);
        this.addLandMass(lma, zoomLimit);
    }

    public void addLandMass(ArrayList<Area> lma, int zoomLimit) throws IOException {
        this.landMassesLOD.put(lma, zoomLimit);
        this.plotLand = true;
        this.repaint();
    }

    public void plotLandMass(boolean b) {
        this.plotLand = b;
        this.repaint();
    }

    public void addBorders(File f) throws IOException {
        this.addBorders(f, null);
    }

    public void addBorders(URL url) throws IOException {
        this.borderMasses = url.getPath().endsWith(".b") ? GSHHSReader.readIt(url, true) : GSHHSReader.getBorders(url);
    }

    public void addBorders(File f, Rectangle2D rec) throws IOException {
        this.plotBorders = true;
        this.repaint();
    }

    public void addBorders(String netcdfFilename) {
        this.borderMasses = GSHHSReader.getBorders(netcdfFilename);
    }

    public void plotBorders(boolean b) {
        this.plotBorders = b;
        this.repaint();
    }

    public void plotGraticules(boolean b) {
        this.plotGraticules = b;
        if (this.plotGraticules && this.grats == null) {
            this.setGraticulesDefault();
        }
    }

    public void setGraticulesDefault() {
        this.grats = new GeneralPath(0);
        this.grats.moveTo(180.0, -90.0);
        this.grats.lineTo(180.0, 90.0);
        this.grats.moveTo(0.0, 0.0);
        this.grats.lineTo(360.0, 0.0);
        this.repaint();
    }

    public void setGraticules(GeneralPath gp) {
        this.grats = gp;
        this.repaint();
    }

    public void setGraticulesDashed(boolean b) {
        this.gratsDashed = b;
        this.repaint();
    }

    public void setGraticulesColor(Color c) {
        this.gratColor = c;
        this.repaint();
    }

    public void plotCountryNames(boolean b) {
        this.plotCountryNames = b;
        if (this.countryNames.size() == 0) {
            this.loadCountryNames(this.getClass().getResourceAsStream("images/CountryLabels.csv"));
        }
        this.repaint();
    }

    public void loadCountryNames(InputStream is) {
        block18: {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            String[] sa = line.split(",");
                            try {
                                float lon = Float.parseFloat(sa[1]);
                                float lat = Float.parseFloat(sa[2]);
                                this.countryNames.put(sa[0], new Point2D.Float(lon, lat));
                                continue block13;
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                        }
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Can't load Country Names from CountryNames.csv", ioe);
            }
        }
    }

    public void plotCityNames(boolean b) {
        this.plotCityNames = b;
        if (this.cityNames.size() == 0) {
            this.loadCityNames(this.getClass().getResourceAsStream("images/cities5000strip.txt.gz"));
        }
        this.repaint();
    }

    public void loadCityNames(InputStream is) {
        ArrayList<City> cities;
        block19: {
            cities = new ArrayList<City>();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(is), "UTF-8"));
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            String[] sa = line.split(",");
                            try {
                                cities.add(new City(sa[0], Double.parseDouble(sa[1]), Double.parseDouble(sa[2]), sa[3], sa[4], Double.parseDouble(sa[5])));
                                continue block13;
                            }
                            catch (NumberFormatException nfe) {
                                log.warning("error parsing city: " + line);
                            }
                        }
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error loading city names", ioe);
            }
        }
        Collections.sort(cities);
        for (City c : cities) {
            this.cityNames.put(c, new Ellipse2D.Float((float)c.getLon(), (float)c.getLat(), 0.1f, 0.1f * (float)aspectRatio));
        }
        log.fine("Loaded city info, number of cities: " + this.cityNames.size());
    }

    public void setEpicenter(double lon, double lat) {
        this.epicenter = new StarShape(lon, lat, 0.5, 0.2, 5, -0.3141592653589793, aspectRatio);
        this.plotEpicenter(true);
    }

    public Point2D getEpicenter() {
        return this.epicenter.getCenter();
    }

    public void plotEpicenter(boolean b) {
        this.plotEpicenter = b;
        this.repaint();
    }

    public void setMovingEpicenter(boolean b) {
        this.movingEpicenter = b;
        if (this.movingEpicenter) {
            if (this.starCursor != null) {
                log.fine("Setting star cursor: " + this.starCursor.getName() + ":" + this.starCursor.toString() + ":" + this.starCursor.getType());
                this.setCursor(this.starCursor);
            }
        } else {
            log.fine("Setting default cursor");
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setTravelTimesDashed(boolean b) {
        this.travelTimesDashed = b;
    }

    public void setTravelTimes(ArrayList<Double> tlevs, ArrayList<GeneralPath> ttpaths, ArrayList<TopoShape> ttlabs) {
        this.setTravelTimes(tlevs, ttpaths, ttlabs, false);
    }

    public void setTravelTimes(ArrayList<Double> tlevs, ArrayList<GeneralPath> ttpaths, ArrayList<TopoShape> ttlabs, boolean dashed) {
        this.travelTimes.clear();
        this.travelTimesDashed = dashed;
        for (int i = 0; i < ttpaths.size(); ++i) {
            this.travelTimes.put(tlevs.get(i), ttpaths.get(i));
        }
        this.travelTimeLabels = ttlabs;
    }

    public void clearTravelTimes() {
        this.travelTimes.clear();
        this.travelTimeLabels.clear();
    }

    public void plotTravelTimes(boolean b) {
        this.plotTravelTimes = b;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceCenters(Collection<UnitSource> sources) {
        ArrayList<TopoShape> arrayList = this.sourceCenters;
        synchronized (arrayList) {
            this.sourceCenters.clear();
            for (UnitSource s : sources) {
                Ellipse2D.Float circ = new Ellipse2D.Float();
                circ.width = 0.45f;
                circ.height = 0.45f;
                circ.x = (float)s.getLongitude() - circ.width / 2.0f;
                circ.y = (float)s.getLatitude() - circ.height / 2.0f;
                TopoShape ts = new TopoShape(circ);
                ts.setFillColor(new Color(0, 0, 255));
                ts.setFill(true);
                this.sourceCenters.add(ts);
            }
        }
    }

    public void plotSourceCenters(boolean b) {
        this.plotSourceCenters = b;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSources(Collection<UnitSource> sources) {
        ArrayList<UnitSource> arrayList = this.unitSources;
        synchronized (arrayList) {
            this.unitSources.clear();
            this.unitSources.addAll(sources);
        }
        this.plotSources(true);
    }

    public void plotSources(boolean b) {
        this.plotSources = b;
        this.repaint();
    }

    public void selectSources(boolean b) {
        this.selectDB = b;
    }

    public void setActive(SourceCombo sc) {
        this.setActive(sc.getSources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean b) {
        ArrayList<UnitSource> arrayList = this.unitSources;
        synchronized (arrayList) {
            for (UnitSource aSource : this.unitSources) {
                aSource.setActive(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Collection<UnitSource> sv) {
        ArrayList<UnitSource> arrayList = this.unitSources;
        synchronized (arrayList) {
            for (UnitSource aSource : this.unitSources) {
                aSource.setActive(false);
                for (UnitSource inputSource : sv) {
                    if (!inputSource.getName().equals(aSource.getName())) continue;
                    aSource.setActive(true);
                    aSource.setAlpha(inputSource.getAlpha());
                }
            }
        }
        this.repaint();
    }

    public ArrayList<UnitSource> getActive() {
        ArrayList<UnitSource> activeSources = new ArrayList<UnitSource>();
        for (UnitSource u : this.unitSources) {
            if (!u.isActive()) continue;
            activeSources.add(u);
        }
        return activeSources;
    }

    public void setUnitSourceEdgeColor(Color c) {
        this.unitSourceEdgeColor = c;
        this.repaint();
    }

    public void setTileCache(File cacheDir) {
        this.tileDownloader.setCacheDir(cacheDir);
    }

    public void setProvider(int p, boolean cleanCache) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.copyText = this.tileDownloader.setProvider(p, cleanCache);
        this.tileLevel = 0;
        this.clearTiles();
        if (this.plotTiles) {
            this.useTiles(this.zoomLevel);
            this.repaint();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public int getProvider() {
        return this.tileDownloader.getProvider();
    }

    private void useTiles(int zl) {
        if (!this.plotTiles) {
            return;
        }
        int tl = 1;
        switch (zl) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                tl = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                tl = 4;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                tl = 5;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                tl = 6;
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                tl = 7;
                break;
            }
            case 20: 
            case 21: {
                tl = 8;
                break;
            }
            case 22: 
            case 23: {
                tl = 9;
                break;
            }
            case 24: 
            case 25: {
                tl = 10;
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                tl = 11;
                break;
            }
            default: {
                tl = 1;
            }
        }
        if (zl > 28) {
            tl = 12;
        }
        log.info("loading tiles, zommlevel: " + zl + ", changing tileLevel: " + this.tileLevel + " to: " + tl);
        if (this.tileThread != null) {
            this.tileThread.interrupt();
        }
        this.tileDownloader.setTileLevel(tl);
        this.tileThread = new Thread(this.tileDownloader);
        this.tileThread.start();
        this.tileLevel = tl;
    }

    public void setTileImages(HashMap<Image, Rectangle2D.Double> te, HashMap<Image, AffineTransform> tt2) {
        while (this.paintingTiles) {
        }
        this.tileExtents = te;
        this.tileTransforms = tt2;
        this.tileThread = null;
        this.repaint();
    }

    public void setNavLock(boolean nl) {
        this.navLock = nl;
    }

    public boolean getNavLock() {
        return this.navLock;
    }

    public void zoomIn() {
        this.zoom(this.zoomLevel + 1);
    }

    public void zoomOut() {
        this.zoom(this.zoomLevel - 1);
    }

    public void zoom(int lvl) {
        double es;
        if (this.navLock) {
            return;
        }
        int oldLevel = this.zoomLevel;
        if (lvl < this.minZoomLevel) {
            lvl = this.minZoomLevel;
        }
        if (lvl > this.maxZoomLevel) {
            lvl = this.maxZoomLevel;
        }
        if (this.zoomLevel == lvl) {
            return;
        }
        this.scale = es = this.zoomLevelToScale(lvl);
        this.zoomLevel = lvl;
        this.useTiles(this.zoomLevel);
        this.repaint();
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    private int scaleToZoomLevel(double s) {
        int result = (int)Math.rint(Math.log(s) / Math.log(this.zoomScaleDelta)) + 1;
        if (result > this.maxZoomLevel) {
            result = this.maxZoomLevel;
        }
        if (result < this.minZoomLevel) {
            result = this.minZoomLevel;
        }
        return result;
    }

    private double zoomLevelToScale(int zl) {
        return Math.pow(this.zoomScaleDelta, zl);
    }

    public void setZoomScaleDelta(double s) {
        this.zoomScaleDelta = s;
        this.zoomLevel = this.scaleToZoomLevel(1.0);
        this.scale = this.zoomLevelToScale(this.zoomLevel);
    }

    public void zoomTo(double minLat, double maxLat, double minLon, double maxLon) {
        Rectangle2D.Double rec = new Rectangle2D.Double(minLon, minLat, maxLon - minLon, maxLat - minLat);
        this.zoomTo(rec);
    }

    public void zoomTo(Rectangle2D rec) {
        if (this.navLock) {
            return;
        }
        int oldZoomLevel = this.zoomLevel;
        this.panTo(rec.getCenterX(), rec.getCenterY());
        for (ArrayList<Area> this.landMasses : this.landMassesLOD.keySet()) {
        }
        this.zoom(this.maxZoomLevel);
        this.windowExtents = this.getWindowExtents();
        while (!this.windowExtents.contains(rec)) {
            this.zoomOut();
            this.windowExtents = this.getWindowExtents();
            if (this.zoomLevel != this.minZoomLevel) continue;
        }
        this.useTiles(this.zoomLevel);
        this.repaint();
        this.firePropertyChange("zoomComplete", oldZoomLevel, this.zoomLevel);
    }

    public void setMaxZoomLevel(int zl) {
        this.maxZoomLevel = zl;
    }

    public int getMaxZoomLevel() {
        return this.maxZoomLevel;
    }

    public void panTo(double lon, double lat) {
        log.fine("Panning to lon: " + lon + " lat: " + lat);
        Point2D pt = new Point2D.Double(lon, lat);
        pt = this.worldToPixel.transform(pt, pt);
        pt = this.getPanAndZoomTransform().transform(pt, pt);
        this.lastX = (int)pt.getX();
        this.lastY = (int)pt.getY();
        this.pan(this.getWidth() / 2, this.getHeight() / 2);
    }

    private void pan(int x, int y) {
        if (this.navLock) {
            return;
        }
        Point2D adjPreviousPoint = this.getTranslatedPoint(this.lastX, this.lastY);
        Point2D adjNewPoint = this.getTranslatedPoint(x, y);
        double newX = adjNewPoint.getX() - adjPreviousPoint.getX();
        double newY = adjNewPoint.getY() - adjPreviousPoint.getY();
        this.lastX = x;
        this.lastY = y;
        this.currentX += newX;
        this.currentY += newY;
        this.repaint();
    }

    private void panRight() {
        int x = this.lastX - 15;
        int y = this.lastY;
        this.lastPan = 1;
        this.pan(x, y);
    }

    private void panLeft() {
        int x = this.lastX + 15;
        int y = this.lastY;
        this.lastPan = 2;
        this.pan(x, y);
    }

    private void panUp() {
        int x = this.lastX;
        int y = this.lastY + 15;
        this.lastPan = 3;
        this.pan(x, y);
    }

    private void panDown() {
        int x = this.lastX;
        int y = this.lastY - 15;
        this.lastPan = 4;
        this.pan(x, y);
    }

    private void repeatPan() {
        switch (this.lastPan) {
            case 1: {
                this.panRight();
                break;
            }
            case 2: {
                this.panLeft();
                break;
            }
            case 3: {
                this.panUp();
                break;
            }
            case 4: {
                this.panDown();
                break;
            }
            default: {
                log.warning(Integer.toString(this.lastPan));
            }
        }
    }

    public void setHome(Rectangle2D.Double rec) {
        this.homeLatLonRec = rec;
    }

    public Rectangle2D.Double getHome() {
        return this.homeLatLonRec;
    }

    public void goHome() {
        this.zoomTo(this.homeLatLonRec);
    }

    private AffineTransform getPanAndZoomTransform() {
        AffineTransform tx = new AffineTransform();
        double centerX = (double)this.getWidth() / 2.0;
        double centerY = (double)this.getHeight() / 2.0;
        tx.translate(centerX, centerY);
        tx.scale(this.scale, this.scale);
        tx.translate(this.currentX, this.currentY);
        return tx;
    }

    private Point2D getTranslatedPoint(double panelX, double panelY) {
        AffineTransform tx = this.getPanAndZoomTransform();
        Point2D.Double point2d = new Point2D.Double(panelX, panelY);
        try {
            return tx.inverseTransform(point2d, null);
        }
        catch (NoninvertibleTransformException ex) {
            log.log(Level.SEVERE, "Can't invert pandAndZoom transform", ex);
            return null;
        }
    }

    public Point2D getPointerLocation() {
        return this.pointerLocation;
    }

    public void setPickPoints(boolean b) {
        this.pickPoints = b;
    }

    public void setGrid0(Rectangle2D r) {
        this.propGridPoly = r;
        this.plotSites = true;
        this.repaint();
    }

    public void plotSites(boolean b) {
        this.plotSites = b;
        this.repaint();
    }

    public boolean isRubberbanding() {
        return this.rubberBanding;
    }

    public void setRubberbanding(boolean b) {
        this.rubberBanding = b;
    }

    public Range2D getRubberbandRegion() {
        return new Range2D(this.rubberRect);
    }

    public void setRubberbandRegion(double minlon, double maxlon, double minlat, double maxlat) {
        this.rubberRect.x = minlon;
        this.rubberRect.y = maxlat;
        this.rubberRect.width = maxlon - minlon;
        this.rubberRect.height = maxlat - minlat;
        this.rubberBanding = true;
        this.repaint();
    }

    public static void main(String[] args) throws Exception {
        final TopoCanvas map = new TopoCanvas();
        map.loadCountryNames(new FileInputStream("/Users/cmoore/tsunami/devel/EventEditor/src/gov/noaa/tsunami/websift/ee/images/CountryLabels.csv"));
        map.loadCityNames(new FileInputStream("/Users/cmoore/tsunami/devel/EventEditor/src/gov/noaa/tsunami/websift/ee/images/cities.txt.gz"));
        BufferedImage im = ImageIO.read(new URL("file:///Users/cmoore/tsunami/matlab/googleEarthPropImages/propmax.png"));
        map.addImage(im, new Rectangle2D.Double(219.4833, -50.326, 70.4, 50.8426));
        map.setHome(new Rectangle2D.Double(219.4833, -50.326, 70.4, 50.8426));
        try {
            map.addLandMass(new File("/Users/cmoore/tsunami/Coastline/gshhs/gshhs_l.nc"), 8);
            map.addBorders(new File("/Users/cmoore/ComMIT/etc/wdb_borders_i.b"));
        }
        catch (IOException mue) {
            log.log(Level.WARNING, "Error loading map background, etc", mue);
        }
        map.setEpicenter(234.88, 45.73);
        map.plotCityNames(true);
        map.plotCountryNames(true);
        map.plotBorders(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.add(map);
                frame.setSize(1400, 1000);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                map.panTo(205.0, 0.0);
                map.zoom(2);
                map.getWindowExtents();
            }
        });
    }

    class MouseHandler
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        public SourceInfoFrame sourceInfoWindow = null;

        MouseHandler() {
        }

        private void showSourceInfo(MouseEvent e, UnitSource aSource) {
            if (this.sourceInfoWindow == null) {
                this.sourceInfoWindow = new SourceInfoFrame();
            }
            this.sourceInfoWindow.setSource(aSource);
            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
            this.sourceInfoWindow.setLocation(p.x + e.getX(), p.y + e.getY());
            this.sourceInfoWindow.setVisible(true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TopoCanvas.this.lastX = e.getX();
            TopoCanvas.this.lastY = e.getY();
            Point2D.Double Pt = new Point2D.Double(e.getX(), e.getY());
            TopoCanvas.this.rubberBanding = false;
            if (TopoCanvas.this.zoomInRec.contains(Pt)) {
                int oldZoomLevel = TopoCanvas.this.zoomLevel;
                TopoCanvas.this.zoomIn();
                TopoCanvas.this.firePropertyChange("zoomComplete", oldZoomLevel, TopoCanvas.this.zoomLevel);
                return;
            }
            if (TopoCanvas.this.zoomOutRec.contains(Pt)) {
                int oldZoomLevel = TopoCanvas.this.zoomLevel;
                TopoCanvas.this.zoomOut();
                TopoCanvas.this.firePropertyChange("zoomComplete", oldZoomLevel, TopoCanvas.this.zoomLevel);
                return;
            }
            if (TopoCanvas.this.panUpRec.contains(Pt)) {
                TopoCanvas.this.isPanning = true;
                TopoCanvas.this.panUp();
                TopoCanvas.this.panTimer.start();
                return;
            }
            if (TopoCanvas.this.panDownRec.contains(Pt)) {
                TopoCanvas.this.isPanning = true;
                TopoCanvas.this.panDown();
                TopoCanvas.this.panTimer.start();
                return;
            }
            if (TopoCanvas.this.panLeftRec.contains(Pt)) {
                TopoCanvas.this.isPanning = true;
                TopoCanvas.this.panLeft();
                TopoCanvas.this.panTimer.start();
                return;
            }
            if (TopoCanvas.this.panRightRec.contains(Pt)) {
                TopoCanvas.this.isPanning = true;
                TopoCanvas.this.panRight();
                TopoCanvas.this.panTimer.start();
                return;
            }
            if (TopoCanvas.this.homeRec.contains(Pt)) {
                TopoCanvas.this.goingHome = true;
                TopoCanvas.this.firePropertyChange("goHome", null, null);
                return;
            }
            if (e.getClickCount() == 2) {
                int oldZoomLevel = TopoCanvas.this.zoomLevel;
                Point2D adjPreviousPoint = TopoCanvas.this.getTranslatedPoint(TopoCanvas.this.lastX, TopoCanvas.this.lastY);
                Point2D adjNewPoint = TopoCanvas.this.getTranslatedPoint(TopoCanvas.this.getWidth() / 2, TopoCanvas.this.getHeight() / 2);
                double newX = adjNewPoint.getX() - adjPreviousPoint.getX();
                double newY = adjNewPoint.getY() - adjPreviousPoint.getY();
                TopoCanvas.this.currentX = TopoCanvas.this.currentX + newX;
                TopoCanvas.this.currentY = TopoCanvas.this.currentY + newY;
                TopoCanvas.this.zoomIn();
                TopoCanvas.this.firePropertyChange("zoomComplete", oldZoomLevel, TopoCanvas.this.zoomLevel);
                return;
            }
            if (TopoCanvas.this.pickPoints) {
                TopoCanvas.this.pointerLocation = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                TopoCanvas.this.pixelToWorld.transform(TopoCanvas.this.pointerLocation, TopoCanvas.this.pointerLocation);
                TopoCanvas.this.firePropertyChange("pickedPoint", null, TopoCanvas.this.pointerLocation);
                return;
            }
            if (e.isShiftDown()) {
                Point2D p = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                TopoCanvas.this.pixelToWorld.transform(p, p);
                TopoCanvas.this.rubberRect.setRect(p.getX(), p.getY(), 0.01, 0.01);
                TopoCanvas.this.rubberBanding = true;
                return;
            }
            if (e.isPopupTrigger()) {
                if (TopoCanvas.this.movingEpicenter) {
                    TopoCanvas.this.setMovingEpicenter(false);
                    TopoCanvas.this.pointerLocation = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                    TopoCanvas.this.pixelToWorld.transform(TopoCanvas.this.pointerLocation, TopoCanvas.this.pointerLocation);
                    TopoCanvas.this.setEpicenter(TopoCanvas.this.pointerLocation.getX(), TopoCanvas.this.pointerLocation.getY());
                    TopoCanvas.this.firePropertyChange("epicenterLocation", null, TopoCanvas.this.pointerLocation);
                } else {
                    if (TopoCanvas.this.epicenter.contains(TopoCanvas.this.pointerLocation)) {
                        TopoCanvas.this.setMovingEpicenter(true);
                        return;
                    }
                    if (TopoCanvas.this.plotQuakes) {
                        TopoCanvas.this.clickedQuakes.clear();
                        for (Object ts : TopoCanvas.this.quakes) {
                            if (!((TopoShape)ts).getShape().contains(TopoCanvas.this.pointerLocation)) continue;
                            TopoCanvas.this.clickedQuakes.add(ts);
                        }
                        if (TopoCanvas.this.clickedQuakes.size() > 0) {
                            TopoCanvas.this.firePropertyChange("clickedQuakes", null, TopoCanvas.this.clickedQuakes);
                            return;
                        }
                    }
                    if (TopoCanvas.this.plotRunups && e.isPopupTrigger()) {
                        ArrayList clickedRunups = new ArrayList();
                        for (Runup r : TopoCanvas.this.runups) {
                            if (!r.getEvent_id().equals(TopoCanvas.this.runupEventID) || !r.contains(TopoCanvas.this.pointerLocation)) continue;
                            clickedRunups.add(r);
                        }
                        if (clickedRunups.size() > 0) {
                            RunupDataFrame rif = new RunupDataFrame();
                            rif.setRunups(clickedRunups);
                            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
                            rif.setLocation(p.x + 10, p.y + 10);
                            rif.setVisible(true);
                            return;
                        }
                    }
                    if (TopoCanvas.this.plotWarningPolys) {
                        TopoCanvas.this.clickedPolys.clear();
                        for (Object ts : TopoCanvas.this.warningPolys) {
                            if (!((TopoShape)ts).getShape().contains(TopoCanvas.this.pointerLocation)) continue;
                            TopoCanvas.this.clickedPolys.add(ts);
                        }
                        if (TopoCanvas.this.clickedPolys.size() > 0) {
                            TopoCanvas.this.firePropertyChange("clickedPolys", null, TopoCanvas.this.clickedPolys);
                        }
                    }
                    if (TopoCanvas.this.selectDB) {
                        boolean clicked = false;
                        for (UnitSource u : TopoCanvas.this.unitSources) {
                            if (!u.contains(TopoCanvas.this.pointerLocation)) continue;
                            if (e.isControlDown()) {
                                this.showSourceInfo(e, u);
                                return;
                            }
                            u.setActive(!u.isActive());
                            clicked = true;
                            TopoCanvas.this.repaint();
                            TopoCanvas.this.firePropertyChange("clickedSources", null, u);
                            return;
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TopoCanvas.this.movingEpicenter) {
                TopoCanvas.this.repaint();
                return;
            }
            if (TopoCanvas.this.goingHome) {
                return;
            }
            if (TopoCanvas.this.rubberBanding) {
                TopoCanvas.this.pointerLocation = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                TopoCanvas.this.pixelToWorld.transform(TopoCanvas.this.pointerLocation, TopoCanvas.this.pointerLocation);
                TopoCanvas.this.rubberRect.add(TopoCanvas.this.pointerLocation);
                TopoCanvas.this.repaint();
                return;
            }
            TopoCanvas.this.isPanning = true;
            TopoCanvas.this.pan(e.getX(), e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TopoCanvas.this.pointerLocation = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
            TopoCanvas.this.pixelToWorld.transform(TopoCanvas.this.pointerLocation, TopoCanvas.this.pointerLocation);
            TopoCanvas.this.firePropertyChange("pointerLocation", null, TopoCanvas.this.pointerLocation);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int ticks = e.getWheelRotation();
            int oldZoomLevel = TopoCanvas.this.zoomLevel;
            if (ticks < 0) {
                TopoCanvas.this.zoomIn();
            } else if (ticks > 0) {
                TopoCanvas.this.zoomOut();
            }
            TopoCanvas.this.firePropertyChange("zoomComplete", oldZoomLevel, TopoCanvas.this.zoomLevel);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TopoCanvas.this.panTimer.isRunning()) {
                TopoCanvas.this.panTimer.stop();
            }
            if (TopoCanvas.this.isPanning) {
                TopoCanvas.this.isPanning = false;
                TopoCanvas.this.firePropertyChange("panComplete", null, null);
                TopoCanvas.this.useTiles(TopoCanvas.this.zoomLevel);
            }
            if (TopoCanvas.this.goingHome) {
                TopoCanvas.this.goingHome = false;
                return;
            }
            if (TopoCanvas.this.movingEpicenter) {
                TopoCanvas.this.setMovingEpicenter(false);
                TopoCanvas.this.pointerLocation = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                TopoCanvas.this.pixelToWorld.transform(TopoCanvas.this.pointerLocation, TopoCanvas.this.pointerLocation);
                TopoCanvas.this.setEpicenter(TopoCanvas.this.pointerLocation.getX(), TopoCanvas.this.pointerLocation.getY());
                TopoCanvas.this.firePropertyChange("epicenterLocation", null, TopoCanvas.this.pointerLocation);
            }
            if (TopoCanvas.this.rubberBanding) {
                TopoCanvas.this.rubberBanding = false;
                TopoCanvas.this.firePropertyChange("rubberbandRegion", null, TopoCanvas.this.getRubberbandRegion());
                TopoCanvas.this.repaint();
                return;
            }
            if (e.isPopupTrigger()) {
                if (TopoCanvas.this.movingEpicenter) {
                    TopoCanvas.this.setMovingEpicenter(false);
                    TopoCanvas.this.pointerLocation = TopoCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                    TopoCanvas.this.pixelToWorld.transform(TopoCanvas.this.pointerLocation, TopoCanvas.this.pointerLocation);
                    TopoCanvas.this.setEpicenter(TopoCanvas.this.pointerLocation.getX(), TopoCanvas.this.pointerLocation.getY());
                    TopoCanvas.this.firePropertyChange("epicenterLocation", null, TopoCanvas.this.pointerLocation);
                } else {
                    if (TopoCanvas.this.epicenter.contains(TopoCanvas.this.pointerLocation)) {
                        TopoCanvas.this.setMovingEpicenter(true);
                        return;
                    }
                    if (TopoCanvas.this.plotQuakes) {
                        TopoCanvas.this.clickedQuakes.clear();
                        for (Object ts : TopoCanvas.this.quakes) {
                            if (!((TopoShape)ts).getShape().contains(TopoCanvas.this.pointerLocation)) continue;
                            TopoCanvas.this.clickedQuakes.add(ts);
                        }
                        if (TopoCanvas.this.clickedQuakes.size() > 0) {
                            TopoCanvas.this.firePropertyChange("clickedQuakes", null, TopoCanvas.this.clickedQuakes);
                            return;
                        }
                    }
                    if (TopoCanvas.this.plotRunups && e.isPopupTrigger()) {
                        ArrayList clickedRunups = new ArrayList();
                        for (Runup r : TopoCanvas.this.runups) {
                            if (!r.getEvent_id().equals(TopoCanvas.this.runupEventID) || !r.contains(TopoCanvas.this.pointerLocation)) continue;
                            clickedRunups.add(r);
                        }
                        if (clickedRunups.size() > 0) {
                            RunupDataFrame rif = new RunupDataFrame();
                            rif.setRunups(clickedRunups);
                            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
                            rif.setLocation(p.x + 10, p.y + 10);
                            rif.setVisible(true);
                            return;
                        }
                    }
                    if (TopoCanvas.this.plotWarningPolys) {
                        TopoCanvas.this.clickedPolys.clear();
                        for (Object ts : TopoCanvas.this.warningPolys) {
                            if (!((TopoShape)ts).getShape().contains(TopoCanvas.this.pointerLocation)) continue;
                            TopoCanvas.this.clickedPolys.add(ts);
                        }
                        if (TopoCanvas.this.clickedPolys.size() > 0) {
                            TopoCanvas.this.firePropertyChange("clickedPolys", null, TopoCanvas.this.clickedPolys);
                        }
                    }
                    if (TopoCanvas.this.selectDB) {
                        boolean clicked = false;
                        for (UnitSource u : TopoCanvas.this.unitSources) {
                            if (!u.contains(TopoCanvas.this.pointerLocation)) continue;
                            if (e.isControlDown()) {
                                this.showSourceInfo(e, u);
                                return;
                            }
                            u.setActive(!u.isActive());
                            clicked = true;
                            TopoCanvas.this.repaint();
                            TopoCanvas.this.firePropertyChange("clickedSources", null, u);
                            return;
                        }
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class OverlayText {
        public double xfraction;
        public double yfraction;
        public String text;
        public Font font;
        public Color color;

        public OverlayText(double xfraction, double yfraction, String txt, Font f, Color c) {
            this.xfraction = xfraction;
            this.yfraction = yfraction;
            this.text = txt;
            this.font = f;
            this.color = c;
        }
    }
}

