/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.ColorLUT;
import gov.noaa.tsunami.websift.ee.MOSTGrid;
import gov.noaa.tsunami.websift.ee.MOSTGridHA;
import gov.noaa.tsunami.websift.ee.MarchingSquares;
import gov.noaa.tsunami.websift.ee.TopoCanvas;
import gov.noaa.tsunami.websift.ee.TopoShape;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class TopoCanvasTester
extends JFrame
implements ActionListener,
PropertyChangeListener {
    public static final Logger log = Logger.getLogger("gov.noaa.tsunami");
    private PropagationDatabase propdb = PropagationDatabase.getInstance();
    private TopoCanvas map;
    private final Timer animationTimer;
    private int timeStep = -1;
    private int timeStepMax = 0;
    double maxLat = 65.0;
    double minLat = -60.0;
    double minLon = 100.0;
    double maxLon = 292.0;
    private MOSTGridHA mostGridHA;
    private MOSTGridHA mostGridHB;
    private MOSTGridHA mostGridHC;
    private BufferedImage haImage = null;
    private BufferedImage hbImage = null;
    private BufferedImage hcImage = null;
    private ColorLUT haLUT = new ColorLUT();
    private ColorLUT hbLUT = new ColorLUT();
    private ColorLUT hcLUT = new ColorLUT();
    private MOSTGrid mostGrid = null;
    private BufferedImage maxImage = null;
    private boolean imageMax = true;
    private ColorLUT maxLUT = new ColorLUT();
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton8;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTextField latTextField;
    private JTextField lonTextField;
    private JPanel mapPanel;
    private JFormattedTextField maxLatTextField;
    private JFormattedTextField maxLonTextField;
    private JFormattedTextField minLatTextField;
    private JFormattedTextField minLonTextField;

    public TopoCanvasTester() {
        this.initComponents();
        log.info("Starting");
        this.map = new TopoCanvas();
        this.map.setMaxZoomLevel(58);
        this.map.setLog(log);
        this.mapPanel.add((Component)this.map, "Center");
        try {
            this.map.addLandMass(new File("/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/etc/gshhs_l.nc"), 6);
            this.map.addLandMass(new File("/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/etc/gshhs_f.nc"), 20);
            this.map.addBorders(new File("/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/etc/wdb_borders_i.b").toURI().toURL());
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error loading map coast file", ioe);
        }
        this.map.plotLandMass(false);
        this.map.plotBorders(true);
        this.map.setSize(this.mapPanel.getSize());
        this.map.panTo(205.0, 0.0);
        this.map.plotGraticules(true);
        this.mapPanel.requestFocus();
        this.map.setProvider(2, false);
        this.map.plotTiles(true);
        File etcDir = new File("/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/etc");
        File f = new File(etcDir, "info_sz.dat");
        this.propdb.clearUnitSources();
        try {
            this.propdb.addDatabaseLocation(etcDir.getPath(), null, false);
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "no sources", ioe);
        }
        this.map.setSources(this.propdb.getUnitSources());
        this.map.selectSources(true);
        this.map.addPropertyChangeListener(this);
        this.animationTimer = new Timer(10, this);
        this.animationTimer.setActionCommand("timerFired");
        this.haLUT.setColormapRedBlue();
        this.hbLUT.setColormapRedBlue();
        this.hcLUT.setColormapRedBlue();
        this.maxLUT.setColormapTweb();
        this.setMOSTGrid("/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/eventSources/japan2011_h.nc");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.latTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.lonTextField = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jButton2 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.jRadioButton8 = new JRadioButton();
        this.jButton3 = new JButton();
        this.maxLatTextField = new JFormattedTextField();
        this.minLonTextField = new JFormattedTextField();
        this.maxLonTextField = new JFormattedTextField();
        this.minLatTextField = new JFormattedTextField();
        this.jSplitPane2 = new JSplitPane();
        this.mapPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.setDefaultCloseOperation(3);
        this.jLabel2.setText("Lon:");
        this.jLabel2.setEnabled(false);
        this.latTextField.setHorizontalAlignment(0);
        this.latTextField.setText("null");
        this.latTextField.setEnabled(false);
        this.jLabel3.setText("Lat: ");
        this.jLabel3.setEnabled(false);
        this.lonTextField.setHorizontalAlignment(0);
        this.lonTextField.setText("null");
        this.lonTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lonTextField, -2, 165, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.latTextField, -2, 155, -2).addContainerGap(620, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.lonTextField, -2, -1, -2).addComponent(this.latTextField, -2, -1, -2)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jButton1.setText("Play");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jButton1ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setSelected(true);
        this.jCheckBox3.setText("tiles");
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jCheckBox4.setText("continents");
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Image Max");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jButton2ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("max amp");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("A-Grid");
        this.jCheckBox5.setText("B-Grid");
        this.jCheckBox6.setSelected(true);
        this.jCheckBox6.setText("C-Grid");
        this.jCheckBox7.setText("background");
        this.jCheckBox7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jCheckBox7ActionPerformed(evt);
            }
        });
        this.jCheckBox8.setSelected(true);
        this.jCheckBox8.setText("PropDB");
        this.jCheckBox8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jCheckBox8ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Tile Provider");
        this.buttonGroup2.add(this.jRadioButton1);
        this.jRadioButton1.setText("OSM");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton2);
        this.jRadioButton2.setText("OSM_HOT");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton3);
        this.jRadioButton3.setSelected(true);
        this.jRadioButton3.setText("ESRI_WORLD");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton4);
        this.jRadioButton4.setText("ESRI_NATGEO");
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton5);
        this.jRadioButton5.setText("USGS");
        this.jRadioButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton6);
        this.jRadioButton6.setText("NASA");
        this.jRadioButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton6ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton7);
        this.jRadioButton7.setText("Carto");
        this.jRadioButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton7ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton8);
        this.jRadioButton8.setText("Carto dark");
        this.jRadioButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jRadioButton8ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Load Run");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.jButton3ActionPerformed(evt);
            }
        });
        this.maxLatTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.maxLatTextField.setText("65.0");
        this.maxLatTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.maxLatTextFieldActionPerformed(evt);
            }
        });
        this.minLonTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.minLonTextField.setText("100.0");
        this.minLonTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.minLonTextFieldActionPerformed(evt);
            }
        });
        this.maxLonTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.maxLonTextField.setText("292.0");
        this.maxLonTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.maxLonTextFieldActionPerformed(evt);
            }
        });
        this.minLatTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.minLatTextField.setText("-60.0");
        this.minLatTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopoCanvasTester.this.minLatTextFieldActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton1)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.minLonTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.maxLonTextField, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox4).addComponent(this.jButton2).addComponent(this.jCheckBox2).addComponent(this.jCheckBox5).addComponent(this.jCheckBox7).addComponent(this.jCheckBox8).addComponent(this.jCheckBox3).addComponent(this.jCheckBox6).addComponent(this.jLabel1).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5).addComponent(this.jRadioButton6).addComponent(this.jRadioButton7).addComponent(this.jRadioButton8).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBox1).addComponent(this.jButton3)).addComponent(this.maxLatTextField, -2, -1, -2).addComponent(this.minLatTextField, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox8).addGap(49, 49, 49).addComponent(this.maxLatTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minLonTextField, -2, -1, -2).addComponent(this.maxLonTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.minLatTextField, -2, -1, -2).addContainerGap(957, Short.MAX_VALUE)));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(1.0);
        this.mapPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mapPanel.setPreferredSize(new Dimension(872, 872));
        this.mapPanel.setLayout(new BorderLayout());
        this.jSplitPane2.setTopComponent(this.mapPanel);
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel5.setPreferredSize(new Dimension(872, 150));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jSplitPane2.setRightComponent(this.jPanel5);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.animationTimer.isRunning()) {
            this.animationTimer.stop();
            this.jButton1.setText("Start");
        } else {
            this.animationTimer.start();
            this.jButton1.setText("Stop");
        }
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        this.map.plotTiles(this.jCheckBox3.isSelected());
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        this.map.plotLandMass(this.jCheckBox4.isSelected());
        this.map.plotBorders(this.jCheckBox4.isSelected());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.imageMax) {
            this.imageMax = false;
            this.map.removeImage(this.maxImage);
            this.map.plotMaxAmp(true);
            this.jButton2.setText("Boxes Max");
        } else {
            this.imageMax = true;
            this.map.addImage(this.maxImage, this.mostGrid.getExtents());
            this.map.plotMaxAmp(false);
            this.jButton2.setText("Image Max");
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.map.addImage(this.maxImage, this.mostGrid.getExtents());
            this.map.repaint();
        } else {
            this.map.removeImage(this.maxImage);
            this.map.repaint();
        }
    }

    private void jCheckBox7ActionPerformed(ActionEvent evt) {
        this.map.plotBackground(this.jCheckBox7.isSelected());
    }

    private void jCheckBox8ActionPerformed(ActionEvent evt) {
        this.map.plotSources(this.jCheckBox8.isSelected());
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.map.setProvider(0, false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.map.setProvider(1, false);
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.map.setProvider(2, false);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.map.setProvider(3, false);
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.map.setProvider(4, false);
    }

    private void jRadioButton6ActionPerformed(ActionEvent evt) {
        this.map.setProvider(5, false);
    }

    private void jRadioButton7ActionPerformed(ActionEvent evt) {
        this.map.setProvider(6, false);
    }

    private void jRadioButton8ActionPerformed(ActionEvent evt) {
        this.map.setProvider(7, false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JFileChooser modelChooser = new JFileChooser();
        modelChooser.setFileSelectionMode(2);
        modelChooser.setDialogTitle("Open MOST runup file");
        if (modelChooser.showOpenDialog(this) == 0) {
            this.setMOSTGridHA(modelChooser.getSelectedFile().getPath());
        }
    }

    private void maxLatTextFieldActionPerformed(ActionEvent evt) {
        this.maxLat = ((Number)this.maxLatTextField.getValue()).doubleValue();
        this.setExtents();
    }

    private void minLonTextFieldActionPerformed(ActionEvent evt) {
        this.minLon = ((Number)this.minLonTextField.getValue()).doubleValue();
        this.setExtents();
    }

    private void maxLonTextFieldActionPerformed(ActionEvent evt) {
        this.maxLon = ((Number)this.maxLonTextField.getValue()).doubleValue();
        this.setExtents();
    }

    private void minLatTextFieldActionPerformed(ActionEvent evt) {
        this.minLat = ((Number)this.minLatTextField.getValue()).doubleValue();
        this.setExtents();
    }

    private void setExtents() {
        this.map.zoomTo(this.minLat, this.maxLat, this.minLon, this.maxLon);
    }

    public void setMOSTGridHA(String fileName) {
        int idx = fileName.indexOf("runup");
        if (idx == -1) {
            return;
        }
        System.out.println("fn: " + fileName.substring(0, idx += 5));
        this.mostGridHA = new MOSTGridHA(fileName.substring(0, idx) + "A_ha.nc", true);
        this.mostGridHB = new MOSTGridHA(fileName.substring(0, idx) + "B_ha.nc", true);
        this.mostGridHC = new MOSTGridHA(fileName.substring(0, idx) + "_ha.nc", true);
        this.timeStepMax = this.mostGridHC.getNumberOfTimeSteps();
        this.setTimeStep(56);
        this.map.plotImages(true);
        this.map.plotHA(false);
    }

    public void setMOSTGrid(String fileName) {
        log.info("creating MOSTGrid, true");
        this.mostGrid = new MOSTGrid(fileName, true);
        this.mostGrid.setMagnitude(8.3);
        this.maxLUT.setData(this.mostGrid.getMaxAmp());
        if (this.maxImage != null) {
            this.map.removeImage(this.maxImage);
        }
        this.maxImage = this.maxLUT.getImageTweb();
        this.maxImage = ColorLUT.brighten(this.maxImage, 1.02f);
        this.map.addImage(this.maxImage, this.mostGrid.getExtents());
        this.map.plotMaxAmp(false);
        this.map.plotImages(true);
        MarchingSquares ms = new MarchingSquares();
        ms.setAxes(this.mostGrid.getLons(), this.mostGrid.getLats());
        ArrayList<Double> tlevs = new ArrayList<Double>();
        for (int i = 1; i < 24; ++i) {
            tlevs.add(Double.valueOf(i));
        }
        GeneralPath[] ttpaths = ms.mkIsos(this.mostGrid.getTravelTime(), tlevs);
        ArrayList<GeneralPath> paths = new ArrayList<GeneralPath>();
        for (int i = 0; i < ttpaths.length; ++i) {
            paths.add(ttpaths[i]);
        }
        this.map.setTravelTimes(tlevs, paths, new ArrayList<TopoShape>());
        this.map.plotTravelTimes(true);
        log.info("creating MOSTGrid, false");
        MOSTGrid mostGrid2 = new MOSTGrid(fileName, false);
        ColorLUT lut = new ColorLUT();
        lut.setData(mostGrid2.getMaxAmp());
        lut.setColormapTweb();
        this.map.setMaxAmp(mostGrid2, lut);
        this.map.plotMaxAmp(false);
    }

    public void setTimeStep(int t) {
        int tt2 = t;
        if (tt2 >= this.timeStepMax) {
            tt2 = this.timeStepMax - 1;
        }
        if (tt2 < 0) {
            tt2 = 0;
        }
        log.info("Setting time step to: " + tt2);
        if (tt2 != this.timeStep) {
            boolean success;
            int oldts = this.timeStep;
            this.timeStep = tt2;
            if (this.jCheckBox2.isSelected()) {
                success = this.mostGridHA.readStep(tt2);
                if (success) {
                    this.haLUT.setData(this.mostGridHA.getHA());
                    if (this.haImage != null) {
                        this.map.removeImage(this.haImage);
                    }
                    this.haImage = this.haLUT.getImageIndexed();
                    this.map.addImage(this.haImage, this.mostGridHA.getExtents());
                }
            } else {
                this.map.removeImage(this.haImage);
            }
            if (this.jCheckBox5.isSelected()) {
                success = this.mostGridHB.readStep(tt2);
                if (success) {
                    this.hbLUT.setData(this.mostGridHB.getHA());
                    if (this.hbImage != null) {
                        this.map.removeImage(this.hbImage);
                    }
                    this.hbImage = this.hbLUT.getImageIndexed();
                    this.map.addImage(this.hbImage, this.mostGridHB.getExtents());
                }
            } else {
                this.map.removeImage(this.hbImage);
            }
            if (this.jCheckBox6.isSelected()) {
                success = this.mostGridHC.readStep(tt2);
                if (success) {
                    this.hcLUT.setData(this.mostGridHC.getHA());
                    if (this.hcImage != null) {
                        this.map.removeImage(this.hcImage);
                    }
                    this.hcImage = this.hcLUT.getImageIndexed();
                    this.map.addImage(this.hcImage, this.mostGridHC.getExtents());
                }
            } else {
                this.map.removeImage(this.hcImage);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("timerFired")) {
            int newTS = this.timeStep + 1;
            if (newTS >= this.timeStepMax) {
                newTS = 0;
            }
            this.setTimeStep(newTS);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("clickedSources")) {
            UnitSource u = (UnitSource)evt.getNewValue();
            SourceCombo sc = new SourceCombo(this.map.getActive());
            log.info("new sources: " + sc.toString());
        } else if (evt.getPropertyName().equals("pointerLocation")) {
            Point2D.Double pt = (Point2D.Double)evt.getNewValue();
            if (pt == null) {
                this.latTextField.setText("null");
                this.lonTextField.setText("null");
            } else {
                if (pt.y < 0.0) {
                    this.latTextField.setText(String.format("%2.5f%c S", Math.abs(pt.y), Character.valueOf('\u00b0')));
                } else {
                    this.latTextField.setText(String.format("%2.5f%c N", pt.y, Character.valueOf('\u00b0')));
                }
                if (pt.x > 180.0) {
                    this.lonTextField.setText(String.format("%2.5f%c W", Math.abs(360.0 - pt.x), Character.valueOf('\u00b0')));
                } else {
                    this.lonTextField.setText(String.format("%2.5f%c E", pt.x, Character.valueOf('\u00b0')));
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TopoCanvasTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TopoCanvasTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TopoCanvasTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TopoCanvasTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TopoCanvasTester().setVisible(true);
            }
        });
    }
}

