/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.util.ArrayList;
import javax.swing.AbstractListModel;

public class UniqueListModel<E>
extends AbstractListModel<E> {
    private ArrayList<E> delegate;

    public UniqueListModel() {
        this(new ArrayList());
    }

    public UniqueListModel(ArrayList<E> v) {
        this.delegate = v;
    }

    public void addElement(E obj) {
        if (this.delegate.indexOf(obj) == -1) {
            int index = this.delegate.size();
            this.delegate.add(obj);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void insertElement(E obj) {
        if (this.delegate.indexOf(obj) != -1) {
            return;
        }
        if (!(obj instanceof Comparable) || this.delegate.size() == 0 || !(this.delegate.get(0) instanceof Comparable)) {
            this.addElement(obj);
            return;
        }
        int count = 0;
        int size = this.delegate.size();
        while (((Comparable)obj).compareTo((Comparable)this.delegate.get(count)) > 0) {
            if (++count != size) continue;
            --count;
            break;
        }
        this.delegate.add(count, obj);
        this.fireContentsChanged(this, count, size + 1);
    }

    public void setElementAt(E obj, int index) {
        if (this.delegate.indexOf(obj) == -1) {
            this.delegate.set(index, obj);
            this.fireContentsChanged(this, index, index);
        }
    }

    public E set(int index, E element) {
        if (this.delegate.indexOf(element) == -1) {
            E rv = this.delegate.get(index);
            this.delegate.set(index, element);
            this.fireContentsChanged(this, index, index);
            return rv;
        }
        return null;
    }

    public void add(int index, E element) {
        if (this.delegate.indexOf(element) == -1) {
            this.delegate.add(index, element);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public E getElementAt(int index) {
        return this.delegate.get(index);
    }

    public int size() {
        return this.delegate.size();
    }

    public E get(int index) {
        return this.delegate.get(index);
    }

    public E remove(int index) {
        E rv = this.delegate.get(index);
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return rv;
    }

    public void removeIndices(int[] indices) {
        for (int i = indices.length - 1; i >= 0; --i) {
            this.remove(indices[i]);
        }
    }
}

