/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasinBoundaries {
    public static final double Re = 6371.22;
    public static final double D2R = Math.PI / 180;
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private static boolean dataValid = false;
    private static HashMap<Basin, Path2D.Double> basinMap = new HashMap();

    public static boolean loadBasins(String basinFileName) {
        return BasinBoundaries.loadBasins(new File(basinFileName));
    }

    public static boolean loadBasins(File basinFile) {
        try {
            BasinBoundaries.parseBasins(basinFile);
            dataValid = true;
            log.info("Basin boundaries parsed, number basins: " + basinMap.size());
            BasinBoundaries.testPacific();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        return dataValid;
    }

    public static boolean isDataLoaded() {
        return dataValid;
    }

    public static Path2D.Double parseKMLPoly(File f) {
        Path2D.Double pp = new Path2D.Double();
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = br.readLine()) != null) {
                int i;
                if (!line.contains("<coordinates>")) continue;
                line = br.readLine();
                String[] sarr = line.trim().replaceAll(",", " ").split("\\s+");
                double[] x = new double[sarr.length / 3];
                double[] y = new double[sarr.length / 3];
                int count = 0;
                boolean add360 = false;
                for (i = 1; i < sarr.length; i += 3) {
                    try {
                        x[count] = Double.parseDouble(sarr[i - 1]);
                        y[count] = Double.parseDouble(sarr[i]);
                    }
                    catch (NumberFormatException nfe) {
                        log.log(Level.WARNING, "error parsing kml coords", nfe);
                    }
                    if (x[count] < -380.0 || x[count] > 380.0 || y[count] < -90.0 || y[count] > 90.0) continue;
                    if (x[count] < 0.0) {
                        add360 = true;
                    }
                    ++count;
                }
                if (add360) {
                    i = 0;
                    while (i < x.length) {
                        int n = i++;
                        x[n] = x[n] + 360.0;
                    }
                }
                pp.moveTo(x[0], y[0]);
                for (i = 1; i < x.length; ++i) {
                    pp.lineTo(x[i], y[i]);
                }
            }
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error parsing kml file: " + f.getPath());
        }
        return pp;
    }

    private static void parseBasins(File basinFile) throws IOException {
        Path2D.Double pp = null;
        try (BufferedReader br = new BufferedReader(new FileReader(basinFile));){
            String line;
            String basinString = "";
            Basin basin = Basin.UNKNOWN;
            while ((line = br.readLine()) != null) {
                int i;
                if (line.contains("Polygon id=")) {
                    basinString = line.split("\"")[1];
                    basin = BasinBoundaries.getBasin(basinString);
                    pp = new Path2D.Double();
                    basinMap.put(basin, pp);
                }
                if (!line.contains("<coordinates>")) continue;
                line = br.readLine();
                String[] sarr = line.trim().replaceAll(",", " ").split("\\s+");
                double[] x = new double[sarr.length / 3];
                double[] y = new double[sarr.length / 3];
                int count = 0;
                boolean add360 = false;
                for (i = 1; i < sarr.length; i += 3) {
                    try {
                        x[count] = Double.parseDouble(sarr[i - 1]);
                        y[count] = Double.parseDouble(sarr[i]);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println(sarr[i - 1] + ": " + sarr[i]);
                    }
                    if (x[count] < -380.0 || x[count] > 380.0 || y[count] < -90.0 || y[count] > 90.0) continue;
                    if (x[count] < 0.0) {
                        add360 = true;
                    }
                    ++count;
                }
                if (add360) {
                    i = 0;
                    while (i < x.length) {
                        int n = i++;
                        x[n] = x[n] + 360.0;
                    }
                }
                pp.moveTo(x[0], y[0]);
                for (i = 1; i < x.length; ++i) {
                    pp.lineTo(x[i], y[i]);
                }
            }
        }
    }

    public static void testPacific() {
        Path2D.Double pp = basinMap.get((Object)Basin.PACIFIC);
        double lon = 0.0;
        double lat = 0.0;
        double[] coords = new double[2];
        int count = 0;
        PathIterator pi = pp.getPathIterator(null);
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            lon += coords[0];
            lat += coords[1];
            ++count;
            pi.next();
        }
        log.info("Done parsing basin.kml. Pacific geometric center, lon: " + (lon /= (double)count) + " lat: " + (lat /= (double)count) + ", extent: " + pp.getBounds2D());
    }

    public static HashMap<Basin, Path2D.Double> getBasinMap() {
        return basinMap;
    }

    public static Basin getBasin(String b) {
        if ("pacific".equals(b.toLowerCase())) {
            return Basin.PACIFIC;
        }
        if ("atlantic".equals(b.toLowerCase())) {
            return Basin.ATLANTIC;
        }
        if ("indian".equals(b.toLowerCase())) {
            return Basin.INDIAN;
        }
        return Basin.UNKNOWN;
    }

    public static Path2D.Double getBasinOutline(Basin b) {
        return basinMap.get((Object)b);
    }

    public static Path2D.Double getBasinOutline(double lon, double lat) {
        return BasinBoundaries.getBasinOutline(BasinBoundaries.getBasin(lon, lat));
    }

    public static Rectangle2D.Double getBasinBounds(Basin b) {
        Rectangle2D.Double rec = new Rectangle2D.Double();
        Path2D.Double pp = basinMap.get((Object)b);
        if (pp == null) {
            return rec;
        }
        return (Rectangle2D.Double)pp.getBounds2D();
    }

    public static String getBasinString(double lon, double lat) {
        Basin b = BasinBoundaries.getBasin(lon, lat);
        return b.toString();
    }

    public static Basin getBasin(double lon, double lat) {
        for (Basin b : basinMap.keySet()) {
            Path2D.Double pp = basinMap.get((Object)b);
            if (!pp.contains(lon, lat)) continue;
            return b;
        }
        return Basin.UNKNOWN;
    }

    public static Basin getBasin(Path2D.Double country) {
        for (Basin b : basinMap.keySet()) {
            Path2D.Double pp = basinMap.get((Object)b);
            PathIterator pi = country.getPathIterator(null);
            double[] coords = new double[2];
            while (!pi.isDone()) {
                pi.currentSegment(coords);
                if (pp.contains(coords[0], coords[1])) {
                    return b;
                }
                pi.next();
            }
        }
        return Basin.UNKNOWN;
    }

    public static double distanceBetween(double lat1, double lon1, double lat2, double lon2) {
        double dist = 0.0;
        double theta = Math.sin(lat1 * (Math.PI / 180)) * Math.sin(lat2 * (Math.PI / 180)) + Math.cos(lat1 * (Math.PI / 180)) * Math.cos(lat2 * (Math.PI / 180)) * Math.cos((lon1 - lon2) * (Math.PI / 180));
        theta = Math.acos(theta);
        dist = 6371.22 * theta;
        return dist;
    }

    public static enum Basin {
        PACIFIC,
        ATLANTIC,
        INDIAN,
        UNKNOWN;

    }
}

