/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CountryBoundaries {
    public static final double Re = 6371.22;
    public static final double D2R = Math.PI / 180;
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private static boolean dataValid = false;
    private static HashMap<String, Path2D.Double> countryMap = new HashMap();
    private static HashMap<String, Path2D.Double> basinMap = new HashMap();
    private static ArrayList<String> pacificCountries = new ArrayList();
    private static ArrayList<String> atlanticCountries = new ArrayList();
    private static ArrayList<String> indianCountries = new ArrayList();
    private static ArrayList<String> medCountries = new ArrayList();

    public static boolean loadCountries(InputStream is) {
        dataValid = false;
        try {
            CountryBoundaries.parseCountries2(is);
            dataValid = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dataValid;
    }

    public static boolean loadCountries(String countryFileName) {
        return CountryBoundaries.loadCountries(new File(countryFileName));
    }

    public static boolean loadCountries(File countryFile) {
        try {
            CountryBoundaries.parseCountries2(countryFile);
            dataValid = true;
            log.info("Country boundaries parsed, number countries: " + countryMap.size());
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        return dataValid;
    }

    public static boolean isDataLoaded() {
        return dataValid;
    }

    private static void parseCountries2(File countryFile) throws IOException {
        CountryBoundaries.parseCountries2(new FileInputStream(countryFile));
    }

    private static void parseCountries2(InputStream is) throws IOException {
        Path2D.Double pp = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            String country = "";
            String basins = "0000";
            while ((line = br.readLine()) != null) {
                if (line.contains("BasinID=")) {
                    pp = new Path2D.Double();
                    if (line.contains("Pacific")) {
                        basinMap.put("Pacific", pp);
                    }
                    if (line.contains("Atlantic")) {
                        basinMap.put("Atlantic", pp);
                    }
                    if (line.contains("Indian")) {
                        basinMap.put("Indian", pp);
                    }
                    if (line.contains("Mediterranean")) {
                        basinMap.put("Mediterranean", pp);
                    }
                }
                if (line.contains("Basins=")) {
                    String[] sarr = line.split("\"");
                    basins = sarr[1];
                    if (basins.charAt(0) == '1') {
                        pacificCountries.add(country);
                    }
                    if (basins.charAt(1) == '1') {
                        indianCountries.add(country);
                    }
                    if (basins.charAt(2) == '1') {
                        atlanticCountries.add(country);
                    }
                    if (basins.charAt(3) == '1') {
                        medCountries.add(country);
                    }
                }
                if (line.contains("CountryID=")) {
                    country = line.split("\"")[1];
                    pp = new Path2D.Double();
                    countryMap.put(country, pp);
                }
                if (!line.contains("<coordinates>")) continue;
                line = br.readLine();
                ArrayList<Point2D.Double> pts = CountryBoundaries.getLatLon(line);
                if (pts.size() < 3) {
                    log.warning("Error: parsing kml coordinates, less than 3 found...");
                    continue;
                }
                double add360 = 0.0;
                for (Point2D.Double pt : pts) {
                    if (!(pt.x < 0.0)) continue;
                    add360 = 360.0;
                    break;
                }
                if (country.equals("France") || country.equals("Spain") || country.equals("United Kingdom")) {
                    for (Point2D.Double pt : pts) {
                        if (!(pt.x < 300.0)) continue;
                        pt.x += 360.0;
                    }
                }
                Point2D.Double pt = pts.get(0);
                pp.moveTo(pt.x, pt.y);
                for (int i = 1; i < pts.size(); ++i) {
                    pt = pts.get(i);
                    pp.lineTo(pt.x + add360, pt.y);
                }
                pp.closePath();
            }
        }
    }

    private static ArrayList<Point2D.Double> getLatLon(String s) {
        String[] coords;
        ArrayList<Point2D.Double> latLonArray = new ArrayList<Point2D.Double>();
        for (String c : coords = s.trim().split("(\\s+)")) {
            Point2D.Double pt = CountryBoundaries.getCoord(c);
            if (pt == null) continue;
            latLonArray.add(pt);
        }
        return latLonArray;
    }

    private static Point2D.Double getCoord(String s) {
        String[] coord = s.split(",");
        if (coord.length != 3) {
            return null;
        }
        double lon = 0.0;
        double lat = 0.0;
        try {
            lon = Double.parseDouble(coord[0]);
            lat = Double.parseDouble(coord[1]);
            if (lon < -180.0 || lon > 380.0 || lat < -90.0 || lat > 90.0) {
                return null;
            }
        }
        catch (NumberFormatException ignore) {
            return null;
        }
        return new Point2D.Double(lon, lat);
    }

    public static void listBasinCountries(String basin) {
        ArrayList<String> list = null;
        if (basin.equals("Pacific")) {
            log.info("Listing Pacific basin countries");
            list = pacificCountries;
        } else if (basin.equals("Atlantic")) {
            log.info("Listing Atlantic basin countries");
            list = atlanticCountries;
        } else if (basin.equals("Indian")) {
            log.info("Listing Indian basin countries");
            list = indianCountries;
        } else if (basin.equals("Mediterranean")) {
            log.info("Listing Mediterranean basin countries");
            list = medCountries;
        } else {
            log.info("Can't find basin: " + basin);
            return;
        }
        log.info(list.toString());
    }

    public static void testJapan() {
        Path2D.Double pp = countryMap.get("Japan");
        double lon = 0.0;
        double lat = 0.0;
        double[] coords = new double[2];
        int count = 0;
        PathIterator pi = pp.getPathIterator(null);
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            lon += coords[0];
            lat += coords[1];
            ++count;
            pi.next();
        }
        log.info("Done parsing country.kml. Japan geometric center, lon: " + (lon /= (double)count) + " lat: " + (lat /= (double)count) + ", extent: " + pp.getBounds2D());
    }

    public static HashMap<String, Path2D.Double> getCountryMap() {
        return countryMap;
    }

    public static ArrayList<String> getCountries() {
        ArrayList<String> countries = new ArrayList<String>();
        for (String s : countryMap.keySet()) {
            countries.add(s);
        }
        Collections.sort(countries);
        return countries;
    }

    public static ArrayList<String> getCountriesNotLandlockedInBasin(Path2D.Double basinPath) {
        ArrayList<String> llcountries = CountryBoundaries.getCountriesNotLandlocked();
        ArrayList<String> countries = new ArrayList<String>();
        for (String c : llcountries) {
            if (!basinPath.intersects(CountryBoundaries.getCountryBounds(c))) continue;
            countries.add(c);
        }
        return countries;
    }

    public static ArrayList<String> getCountriesNotLandlocked() {
        ArrayList<String> countries = CountryBoundaries.getCountries();
        countries.removeAll(CountryBoundaries.getCountriesLandlocked());
        Collections.sort(countries);
        return countries;
    }

    public static ArrayList<String> getCountriesLandlocked() {
        ArrayList<String> countries = new ArrayList<String>();
        countries.add("Antarctica");
        countries.add("Bolivia");
        countries.add("Paraguay");
        countries.add("Andorra");
        countries.add("Austria");
        countries.add("Belarus");
        countries.add("Czech Republic");
        countries.add("Hungary");
        countries.add("Liechtenstein");
        countries.add("Luxembourg");
        countries.add("Macedonia");
        countries.add("Moldova");
        countries.add("San Marino");
        countries.add("Serbia");
        countries.add("Slovakia");
        countries.add("Switzerland");
        countries.add("Vatican City");
        countries.add("Botswana");
        countries.add("Burundi");
        countries.add("Burkina Faso");
        countries.add("Central African Republic");
        countries.add("Chad");
        countries.add("Ethiopia");
        countries.add("Lesotho");
        countries.add("Malawi");
        countries.add("Niger");
        countries.add("Rwanda");
        countries.add("Swaziland");
        countries.add("Uganda");
        countries.add("Zambia");
        countries.add("Zimbabwe");
        countries.add("Afghanistan");
        countries.add("Armenia");
        countries.add("Azerbaijan");
        countries.add("Bhutan");
        countries.add("Laos");
        countries.add("Kazakhstan");
        countries.add("Kyrgyzstan");
        countries.add("Mongolia");
        countries.add("Nepal");
        countries.add("Tajikistan");
        countries.add("Turkmenistan");
        countries.add("Uzbekistan");
        Collections.sort(countries);
        return countries;
    }

    public static Path2D.Double getCountryOutline(String country) {
        return countryMap.get(country);
    }

    public static Rectangle2D.Double getCountryBounds(String country) {
        Rectangle2D.Double rec = new Rectangle2D.Double();
        Path2D.Double pp = countryMap.get(country);
        if (pp == null) {
            return rec;
        }
        return (Rectangle2D.Double)pp.getBounds2D();
    }

    public static ArrayList<String> getCountriesWithin(Rectangle2D.Double rec) {
        ArrayList<String> countries = new ArrayList<String>();
        for (String c : CountryBoundaries.getCountries()) {
            Path2D.Double pp = countryMap.get(c);
            if (!pp.intersects(rec)) continue;
            countries.add(c);
        }
        return countries;
    }

    public static String getCountry(double lon, double lat) {
        String country = "Texas";
        Path2D.Double pp = null;
        ArrayList<String> wetCountries = null;
        if (lon < 0.0) {
            lon += 360.0;
        }
        if (basinMap.size() > 0) {
            pp = basinMap.get("Pacific");
            if (pp.contains(lon, lat)) {
                wetCountries = pacificCountries;
            }
            if ((pp = basinMap.get("Indian")).contains(lon, lat)) {
                wetCountries = indianCountries;
            }
            if ((pp = basinMap.get("Atlantic")).contains(lon, lat)) {
                wetCountries = atlanticCountries;
            }
            if ((pp = basinMap.get("Mediterranean")).contains(lon, lat)) {
                wetCountries = medCountries;
            }
            if (wetCountries == null) {
                wetCountries = CountryBoundaries.getCountries();
            }
        } else {
            wetCountries = CountryBoundaries.getCountriesNotLandlocked();
        }
        for (String c : wetCountries) {
            pp = countryMap.get(c);
            if (!pp.contains(lon, lat)) continue;
            return c;
        }
        double closest = 10000.0;
        double[] coords = new double[2];
        for (String c : wetCountries) {
            pp = countryMap.get(c);
            PathIterator pi = pp.getPathIterator(null);
            while (!pi.isDone()) {
                pi.currentSegment(coords);
                double d = CountryBoundaries.distanceBetween(coords[1], coords[0], lat, lon);
                if (d < closest) {
                    closest = d;
                    country = c;
                }
                pi.next();
                int skip = 10;
                for (int i = 0; i <= skip; ++i) {
                    if (pi.isDone()) continue;
                    pi.next();
                }
            }
        }
        return country;
    }

    public static double distanceBetween(double lat1, double lon1, double lat2, double lon2) {
        double dist = 0.0;
        double theta = Math.sin(lat1 * (Math.PI / 180)) * Math.sin(lat2 * (Math.PI / 180)) + Math.cos(lat1 * (Math.PI / 180)) * Math.cos(lat2 * (Math.PI / 180)) * Math.cos((lon1 - lon2) * (Math.PI / 180));
        theta = Math.acos(theta);
        dist = 6371.22 * theta;
        return dist;
    }

    public static void main(String[] args) {
        if (CountryBoundaries.loadCountries(new File("/Volumes/big/Users/cmoore/Library/TsuCAT/etc/countryReducedAKandHI.kml"))) {
            CountryBoundaries.listBasinCountries("Pacific");
            CountryBoundaries.listBasinCountries("Atlantic");
            CountryBoundaries.listBasinCountries("Indian");
            CountryBoundaries.listBasinCountries("Mediterranean");
            log.info("Listing Countries not land-locked:");
            ArrayList<String> wet = CountryBoundaries.getCountriesNotLandlocked();
            log.info(wet.toString());
            log.info("Country: " + CountryBoundaries.getCountry(93.063, 2.327));
            log.info("dist Lesotho to SF: " + CountryBoundaries.distanceBetween(59.9, 30.3, 37.8, -122.4));
            Rectangle2D.Double rec = CountryBoundaries.getCountryBounds("Midway Is.");
            log.info("Midway rec: " + rec);
            log.info("Country: " + CountryBoundaries.getCountry(292.278, -23.265));
            log.info("Country: " + CountryBoundaries.getCountry(296.994, -20.659));
            for (String c : CountryBoundaries.getCountries()) {
                Path2D.Double pp = CountryBoundaries.getCountryOutline(c);
                double[] coords = new double[2];
                boolean count = false;
                PathIterator pi = pp.getPathIterator(null);
                boolean west = false;
                boolean east = false;
                while (!pi.isDone()) {
                    pi.currentSegment(coords);
                    if (coords[0] < 360.0) {
                        west = true;
                    }
                    if (coords[0] > 360.0) {
                        east = true;
                    }
                    pi.next();
                }
                if (!east || !west) continue;
                System.out.println("Country: " + c + " spans the prime meridian!");
            }
            for (String c : CountryBoundaries.getCountries()) {
                rec = CountryBoundaries.getCountryBounds(c);
                if (!(rec.width > 300.0)) continue;
                System.out.println("Country: " + c + " spans over 300 degrees longitude!");
            }
        }
    }
}

