/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import gov.noaa.tsunami.websift.events.EventParser;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class EventFileManager
extends EventParser {
    private String[] eventPaths = null;
    private Map<String, File> parsedEventFiles = null;

    public EventFileManager(String[] eventDirectories) {
        this.eventPaths = eventDirectories;
    }

    public EventFileManager(String eventDirectory) {
        this(eventDirectory.split("\\s"));
    }

    private Map<String, File> getEventFilenameMap() throws IOException {
        HashMap<String, Integer> eventids = new HashMap<String, Integer>();
        HashMap<String, File> eventfiles = new HashMap<String, File>();
        for (String evtpathname : this.eventPaths) {
            File evtdir = new File(evtpathname);
            Pattern filepattern = Pattern.compile("sift-(\\w+)-(\\d+).xml", 2);
            for (File evfile : evtdir.listFiles()) {
                Matcher filematch = filepattern.matcher(evfile.getName());
                if (!filematch.matches() || !evfile.isFile()) continue;
                int update = Integer.parseInt(filematch.group(2));
                String evid = filematch.group(1);
                if (eventids.containsKey(evid) && update <= (Integer)eventids.get(evid)) continue;
                eventids.put(evid, update);
                eventfiles.put(evid, evfile);
            }
        }
        return eventfiles;
    }

    @Override
    public Vector<SeismicEvent> getEvents(Properties searchSettings) throws IOException {
        Map<String, File> currenteventfiles = this.getEventFilenameMap();
        if (this.parsedEventFiles == null || !currenteventfiles.equals(this.parsedEventFiles) || this.events.size() == 0 && currenteventfiles.size() > 0) {
            this.events.clear();
            for (File evfile : currenteventfiles.values()) {
                try {
                    this.parseEvents(evfile.toString());
                }
                catch (SAXException e) {
                    log.warning("SiftServlet> XML error parsing " + evfile.getName() + " - skipped.");
                }
            }
            SeismicEvent.sortEventsByTime(this.events);
            this.parsedEventFiles = currenteventfiles;
        }
        if (searchSettings != null) {
            Vector<SeismicEvent> filteredevents = new Vector<SeismicEvent>(this.events.capacity());
            for (SeismicEvent se : this.events) {
                if (!EventFileManager.eventMatchesFilter(se, searchSettings)) continue;
                filteredevents.add(se);
            }
            return filteredevents;
        }
        return this.events;
    }

    @Override
    public void forceParse() {
        super.forceParse();
        this.parsedEventFiles = null;
    }

    @Override
    public String getEventLocation(SeismicEvent evt) {
        String evid = evt.getID().replaceFirst("-\\d+$", "");
        File eventFile = this.parsedEventFiles.get(evid);
        return eventFile != null ? eventFile.getPath() : null;
    }

    @Override
    public boolean saveEventName(SeismicEvent se) {
        boolean eventNameSet = false;
        String name = se.getName();
        File file = new File(this.getEventLocation(se));
        String inputLine = "";
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((inputLine = br.readLine()) != null) {
                sb.append(inputLine);
            }
            br.close();
            inputLine = sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (inputLine.length() == 0) {
            return false;
        }
        int idx = sb.indexOf("<annotation>");
        if (idx == -1) {
            int i = sb.indexOf("</xml>");
            sb.insert(i, "<annotation><eventname>" + name + "</eventname></annotation>");
        } else {
            int edx = sb.indexOf("<eventname>");
            if (edx == -1) {
                sb.insert(idx + 12, "<eventname>" + name + "</eventname>");
            } else {
                int e2dx = sb.indexOf("</eventname>");
                sb.replace(edx + 11, e2dx, name);
            }
        }
        try {
            PrintWriter pw = new PrintWriter(file);
            pw.println(sb.toString());
            pw.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean saveEventInversion(SeismicEvent se, SourceScenario source) {
        boolean eventNameSet = false;
        return eventNameSet;
    }
}

