/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class EventManager {
    protected Vector<SeismicEvent> events = new Vector();
    protected static Logger log = Logger.getLogger("gov.noaa.tsunami.websift.propdb");

    public abstract String getEventLocation(SeismicEvent var1);

    public abstract Vector<SeismicEvent> getEvents(Properties var1) throws IOException;

    public static void setLogger(Logger l) {
        log = l;
    }

    public Vector<SeismicEvent> getEvents() throws IOException {
        return this.getEvents(null);
    }

    public void forceParse() {
        this.events.clear();
    }

    public abstract boolean saveEventInversion(SeismicEvent var1, SourceScenario var2);

    public abstract boolean saveEventName(SeismicEvent var1);

    public SeismicEvent getMostRecentEvent() {
        try {
            return this.getEvents().firstElement();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static boolean eventMatchesFilter(SeismicEvent event, Properties event_setup_props) {
        if (event_setup_props == null) {
            return true;
        }
        Calendar now = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        try {
            if (event_setup_props.getProperty("filter_min_magnitude", "").length() != 0) {
                double mag = Double.parseDouble(event_setup_props.getProperty("filter_min_magnitude"));
                if (event.getMagnitude() < mag && now.getTimeInMillis() - event.getDate() > 1209600000L) {
                    return false;
                }
            }
        }
        catch (NumberFormatException mag) {
            // empty catch block
        }
        try {
            String d1 = event_setup_props.getProperty("filter_begin_date", "");
            String d2 = event_setup_props.getProperty("filter_end_date", "");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date evdate = event.getCalendar().getTime();
            if (d1.length() != 0 && evdate.before(df.parse(d1)) || d2.length() != 0 && evdate.after(df.parse(d2))) {
                return false;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public SeismicEvent newEventCheck() {
        return null;
    }
}

