/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import gov.noaa.tsunami.websift.events.EventManager;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class EventParser
extends EventManager
implements ContentHandler,
ErrorHandler {
    private String currentEventSource = null;
    private final Stack<String> tagstack = new Stack();
    private String character_buf;
    private String sourceComboString = "";
    private SourceScenario.Type inversionType = SourceScenario.Type.MANUAL;
    private String inversionUser = "";
    private String inversionNotes = "";
    private long inversionTimestamp = 0L;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
    private boolean ignoreInvalidEvent;
    private int inversionId = -1;
    private String inversionName = "";
    private Date inversionPublishDate = null;
    private List<Date[]> inversionPublishHistory = new ArrayList<Date[]>();
    private String authority = null;
    private Date authDate = null;
    private static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public EventParser() {
        this.dateParser.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected void parseEvents(String eventResource) throws IOException, SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        this.currentEventSource = eventResource;
        this.ignoreInvalidEvent = false;
        xmlReader.parse(eventResource);
    }

    @Override
    public abstract String getEventLocation(SeismicEvent var1);

    public static void prettyPrint(File inFile, File outFile) {
        try {
            StreamSource xmlInput = new StreamSource(new FileReader(inFile));
            StreamResult xmlOutput = new StreamResult(outFile);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            FileWriter fileWriter = new FileWriter(outFile);
        }
        catch (IOException | TransformerException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.tagstack.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        assert (this.tagstack.empty()) : "XML tag parse stack should be empty at end of document";
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String qname, Attributes attrs) throws SAXException {
        String containingTag = this.tagstack.empty() ? null : this.tagstack.peek();
        localName = localName.toLowerCase();
        this.tagstack.push(localName);
        this.character_buf = "";
        if (this.ignoreInvalidEvent) {
            return;
        }
        if (localName.equals("xml") && attrs.getIndex("eventid") > 0 || localName.equals("event")) {
            this.events.add(new SeismicEvent());
            ((SeismicEvent)this.events.lastElement()).setID(attrs.getValue("eventid"));
        }
        if (localName.equals("inversion")) {
            this.inversionPublishHistory.clear();
            this.inversionPublishDate = null;
            this.authority = null;
            this.authDate = null;
            String s = attrs.getValue("method");
            if (s == null) {
                System.out.println("Warning: unspecified inversion type.");
                this.inversionType = SourceScenario.Type.UNKNOWN;
            } else {
                try {
                    this.inversionType = SourceScenario.Type.valueOf(s.toUpperCase());
                }
                catch (Exception unknownType) {
                    log.warning("Warning: unrecognized inversion type: " + s);
                    this.inversionType = SourceScenario.Type.UNKNOWN;
                }
            }
            this.inversionName = "";
            this.sourceComboString = "";
            this.inversionUser = "";
            this.inversionNotes = "";
            this.inversionTimestamp = 0L;
            s = attrs.getValue("id");
            if (s != null && s.length() > 0) {
                try {
                    this.inversionId = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    log.warning("NumberFormatException parsing ID for event: " + ((SeismicEvent)this.events.lastElement()).getID());
                    this.cancelCurrentEventParse();
                }
            }
            if ((s = attrs.getValue("name")) != null && s.trim().length() > 0) {
                this.inversionName = s;
            }
            if ((s = attrs.getValue("published")) != null) {
                try {
                    this.inversionPublishDate = this.dateParser.parse(s);
                }
                catch (Exception x) {
                    System.out.println("Date parse failed for " + s + " : " + x);
                }
            }
        }
        if (localName.equals("published") && "history".equals(containingTag)) {
            String pub = attrs.getValue("date");
            String revoked = attrs.getValue("revoked");
            try {
                Date pubDate = this.dateParser.parse(pub);
                Date revDate = this.dateParser.parse(revoked);
                this.inversionPublishHistory.add(new Date[]{pubDate, revDate});
            }
            catch (Exception x) {
                System.out.println("Date parse failed : " + x);
            }
        }
        if (localName.equals("authoritative") && "inversion".equals(containingTag)) {
            this.authority = attrs.getValue("authority");
            try {
                this.authDate = this.dateParser.parse(attrs.getValue("date"));
            }
            catch (ParseException ex) {
                Logger.getLogger(EventParser.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            if (containingTag != null && containingTag.equals("hypocenter")) {
                if (localName.equals("origin_time")) {
                    ((SeismicEvent)this.events.lastElement()).setTime(Integer.parseInt(attrs.getValue("year")), Integer.parseInt(attrs.getValue("month")), Integer.parseInt(attrs.getValue("day")), Integer.parseInt(attrs.getValue("hour")), Integer.parseInt(attrs.getValue("min")), Integer.parseInt(attrs.getValue("secs")));
                } else if (localName.equals("moment")) {
                    ((SeismicEvent)this.events.lastElement()).setMagnitude(Double.parseDouble(attrs.getValue("magnitude")));
                }
            }
        }
        catch (NumberFormatException ex) {
            log.warning("NumberFormatException parsing hypocenter for event: " + ((SeismicEvent)this.events.lastElement()).getID());
            this.cancelCurrentEventParse();
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String qname) throws SAXException {
        String containingTag;
        String closingTag = this.tagstack.pop();
        String string = containingTag = this.tagstack.empty() ? null : this.tagstack.peek();
        assert (closingTag.equals(localName.toLowerCase()));
        if (closingTag.equals("event")) {
            this.ignoreInvalidEvent = false;
        } else if (this.ignoreInvalidEvent) {
            return;
        }
        if (containingTag != null && containingTag.equals("hypocenter")) {
            try {
                if (closingTag.equals("latitude")) {
                    ((SeismicEvent)this.events.lastElement()).setLatitude(Double.parseDouble(this.character_buf));
                } else if (closingTag.equals("longitude")) {
                    ((SeismicEvent)this.events.lastElement()).setLongitude(Double.parseDouble(this.character_buf));
                } else if (closingTag.equals("depth")) {
                    ((SeismicEvent)this.events.lastElement()).setDepth(Double.parseDouble(this.character_buf));
                }
            }
            catch (NumberFormatException ex) {
                log.warning("NumberFormatException parsing hypocenter for event: " + ((SeismicEvent)this.events.lastElement()).getID());
                this.cancelCurrentEventParse();
            }
        } else if (containingTag != null && containingTag.equals("annotation")) {
            if (closingTag.equals("eventname") && this.character_buf.length() > 0) {
                ((SeismicEvent)this.events.lastElement()).setName(this.character_buf);
            }
        } else if (containingTag != null && containingTag.equals("inversion")) {
            if (closingTag.equals("sourcecombination")) {
                if (this.character_buf.length() > 0) {
                    this.sourceComboString = this.character_buf;
                }
            } else if (closingTag.equals("dart")) {
                if (this.character_buf.length() > 0) {
                    this.sourceComboString = this.character_buf;
                }
                this.inversionType = SourceScenario.Type.DART;
            } else if (closingTag.equals("seismic")) {
                if (this.character_buf.length() > 0) {
                    this.sourceComboString = this.character_buf;
                }
                this.inversionType = SourceScenario.Type.SEISMIC;
            } else if (closingTag.equals("usr")) {
                if (this.character_buf.length() > 0) {
                    this.inversionUser = this.character_buf;
                }
            } else if (closingTag.equals("notes")) {
                if (this.character_buf.length() > 0) {
                    this.inversionNotes = this.character_buf;
                }
            } else if (closingTag.equals("created") && this.character_buf.length() > 0) {
                try {
                    Date d = this.sdf.parse(this.character_buf);
                    this.inversionTimestamp = d.getTime();
                }
                catch (ParseException ex) {
                    Logger.getLogger(EventParser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (closingTag.equals("inversion")) {
            String ssID = String.format("t%d", this.inversionId);
            SourceScenario ss = new SourceScenario(ssID, this.inversionName, (SeismicEvent)this.events.lastElement(), this.sourceComboString, this.inversionType, this.inversionUser, this.inversionNotes, this.inversionTimestamp);
            ss.setPublished(this.inversionPublishDate);
            ss.setPublishHistory(this.inversionPublishHistory);
            if (this.authority != null) {
                ss.setAuthoritative(true);
                ss.setAuthority(this.authority);
                ss.setAuthoritativeDate(this.authDate);
            }
            ((SeismicEvent)this.events.lastElement()).addSourceScenario(ss);
        }
        this.character_buf = "";
    }

    private void cancelCurrentEventParse() {
        if (this.events.size() > 0) {
            this.events.remove(this.events.size() - 1);
            this.ignoreInvalidEvent = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.character_buf = this.character_buf + String.copyValueOf(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

