/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import gov.noaa.tsunami.websift.events.EventParser;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class EventServiceManager
extends EventParser {
    private final URL eventServiceURL;

    public EventServiceManager(URL _eventServiceURL) {
        this.eventServiceURL = _eventServiceURL;
    }

    @Override
    public Vector<SeismicEvent> getEvents(Properties searchSettings) {
        try {
            this.events.clear();
            log.info("SiftServlet> parsing events from web service: " + this.eventServiceURL.toString());
            this.parseEvents(this.eventServiceURL.toString());
        }
        catch (Exception e) {
            log.warning("SiftServlet> XML parse error on web service result: " + e.getMessage());
            e.printStackTrace();
        }
        Vector<SeismicEvent> filteredEvents = new Vector<SeismicEvent>();
        for (SeismicEvent e : this.events) {
            if (!EventServiceManager.eventMatchesFilter(e, searchSettings)) continue;
            filteredEvents.add(e);
        }
        this.events = filteredEvents;
        SeismicEvent.sortEventsByTime(this.events);
        return this.events;
    }

    @Override
    public String getEventLocation(SeismicEvent evt) {
        URL evturl = this.getEventURL(evt);
        return evturl != null ? evturl.toString() : null;
    }

    public URL getEventURL(SeismicEvent evt) {
        try {
            return new URL(this.eventServiceURL, "event/" + evt.getID() + "/webservice");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected String writeToService(URL serviceurl, String xmltext) throws IOException {
        String rv;
        if (!this.eventServiceURL.getProtocol().equals("http")) {
            throw new IOException("eventServiceURL must be http");
        }
        HttpURLConnection service = (HttpURLConnection)serviceurl.openConnection();
        service.setRequestMethod("POST");
        service.setRequestProperty("Content-Type", "application/xml");
        service.setDoOutput(true);
        DataOutputStream outstream = new DataOutputStream(service.getOutputStream());
        outstream.writeBytes("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
        outstream.writeBytes(xmltext);
        outstream.flush();
        outstream.close();
        BufferedReader rvreader = new BufferedReader(new InputStreamReader(service.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((rv = rvreader.readLine()) != null) {
            sb.append(rv);
        }
        return sb.toString();
    }

    @Override
    public boolean saveEventName(SeismicEvent event) {
        log.info("SiftServlet> saving event name " + event.getName() + " to Atlas service");
        try {
            String outxml = String.format("<event eventid=\"%s\"><annotation><eventname>%s</eventname></annotation></event>", event.getID(), event.getName());
            this.writeToService(this.getEventURL(event), outxml);
        }
        catch (IOException ex) {
            log.warning("SiftServlet> IO error writing to Atlas service: " + ex.toString());
            return false;
        }
        return true;
    }

    private void xmlTag(StringBuilder outbuf, String tagname, String value) {
        if (value != null && value.length() > 0) {
            outbuf.append(String.format("<%1$s>%2$s</%1$s>", tagname, value));
        }
    }

    @Override
    public boolean saveEventInversion(SeismicEvent event, SourceScenario si) {
        log.info("SiftServlet> saving inversion to Atlas service");
        StringBuilder outxmlbuf = new StringBuilder();
        if (si == null) {
            return false;
        }
        outxmlbuf.append(String.format("<event eventid=\"%s\"><inversion>", event.getID()));
        this.xmlTag(outxmlbuf, "usr", si.getUser());
        this.xmlTag(outxmlbuf, "sourcecombination", si.getSourceNamesAndSlips());
        this.xmlTag(outxmlbuf, "notes", si.getNotes());
        outxmlbuf.append("</inversion></event>");
        try {
            this.writeToService(this.getEventURL(event), outxmlbuf.toString());
        }
        catch (IOException ex) {
            log.warning("SiftServlet> IO error writing to Atlas service: " + ex.toString());
            return false;
        }
        return true;
    }

    private String getSearchQuery(Properties searchSettings) {
        StringBuilder buf = new StringBuilder();
        if (searchSettings.getProperty("filter_min_magnitude", "").length() != 0) {
            buf.append(String.format("&min_magnitude=%s", searchSettings.getProperty("filter_min_magnitude")));
        }
        if (searchSettings.getProperty("filter_begin_date", "").length() != 0) {
            buf.append(String.format("&begin_date=%s", searchSettings.getProperty("filter_begin_date")));
        }
        if (searchSettings.getProperty("filter_end_date", "").length() != 0) {
            buf.append(String.format("&end_date=%s", searchSettings.getProperty("filter_end_date")));
        }
        if (searchSettings.getProperty("filter_event_provider", "").length() != 0) {
            buf.append(String.format("&provider=%s", searchSettings.getProperty("filter_event_provider")));
        }
        if (Boolean.parseBoolean(searchSettings.getProperty("all_named_events"))) {
            buf.append("&all_named=on");
        }
        return buf.toString();
    }
}

