/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class FlinnEngdahl {
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private static boolean dataValid = false;
    private static HashMap<String, Path2D.Float> regionMap = new HashMap();
    private static ArrayList<String> regionNames = new ArrayList();

    public static boolean loadRegions(String regionsFilename) {
        dataValid = true;
        try {
            NetcdfFile nc = NetcdfFile.open(regionsFilename);
            Variable v = nc.findVariable("id");
            int[] ids = (int[])v.read().copyTo1DJavaArray();
            v = nc.findVariable("name");
            char[] names = (char[])v.read().copyTo1DJavaArray();
            for (int i = 0; i < ids.length; ++i) {
                regionNames.add(new String(names, i * 54, 54).trim());
            }
            v = nc.findVariable("start");
            int[] start = (int[])v.read().copyTo1DJavaArray();
            v = nc.findVariable("end");
            int[] end = (int[])v.read().copyTo1DJavaArray();
            v = nc.findVariable("lons");
            int[] lons = (int[])v.read().copyTo1DJavaArray();
            v = nc.findVariable("lats");
            int[] lats = (int[])v.read().copyTo1DJavaArray();
            for (int i = 0; i < ids.length; ++i) {
                Path2D.Float pp = new Path2D.Float();
                regionMap.put(regionNames.get(i), pp);
                pp.moveTo(lons[start[i] - 1], lats[start[i] - 1]);
                boolean moveNext = false;
                for (int j = start[i] + 1; j < end[i]; ++j) {
                    if ((double)lons[j - 1] == -999.0) {
                        moveNext = true;
                        continue;
                    }
                    if (moveNext) {
                        pp.moveTo(lons[j - 1], lats[j - 1]);
                        moveNext = false;
                        continue;
                    }
                    pp.lineTo(lons[j - 1], lats[j - 1]);
                }
            }
            nc.close();
            FlinnEngdahl.fixDominicanRepublic();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        return dataValid;
    }

    private static void fixDominicanRepublic() {
        Path2D.Float pp = regionMap.get("Dominican Republic region");
        Path2D.Float ppa = new Path2D.Float();
        float[] coords = new float[2];
        PathIterator pi = pp.getPathIterator(null);
        int count = 1;
        boolean move = true;
        while (!pi.isDone()) {
            pi.next();
            pi.currentSegment(coords);
            if (move) {
                ppa.moveTo(coords[0], coords[1]);
            } else {
                ppa.lineTo(coords[0], coords[1]);
            }
            if (count == 10) {
                ppa.lineTo(292.0f, 20.0f);
                ppa.lineTo(292.0f, 19.0f);
            }
            ++count;
        }
        regionMap.put("Dominican Republic region", ppa);
    }

    public static String getRegion(double lon, double lat) {
        String region = "";
        if (!dataValid) {
            log.log(Level.SEVERE, "Can't get Flinn-Engdahl region because data file invalid.\nPlease call loadRegions with the location of the feregions.nc file.");
            region = "nowhere";
        }
        for (String r : regionNames) {
            Path2D.Float pp = regionMap.get(r);
            if (!pp.contains(lon, lat)) continue;
            return r;
        }
        return region;
    }

    public static void main(String[] args) {
        if (FlinnEngdahl.loadRegions("/Volumes/big/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/etc/feregions.nc")) {
            log.info("off the coast of California? : " + FlinnEngdahl.getRegion(238.0, 32.0));
            log.info(" New Ireland region, Papua New Guinea ? : " + FlinnEngdahl.getRegion(152.1184, -3.59564));
            log.info("off the coast of Costa Rica ? : " + FlinnEngdahl.getRegion(274.93577, 9.2615));
            log.info("off Dominican Republic? : " + FlinnEngdahl.getRegion(291.5, 19.4));
        }
    }
}

