/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import gov.noaa.tsunami.websift.events.CountryBoundaries;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.events.SimpleEventParser;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QuakeNGDCParser {
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private SeismicEvent event;

    public void QuakeNGDCParser() {
    }

    public void parseEarthquakes(File f, Vector<SeismicEvent> events) {
        block16: {
            String line = null;
            int count = 0;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));){
                String[] arr = null;
                while ((line = reader.readLine()) != null) {
                    double mag;
                    arr = line.split("\t");
                    if (arr.length <= 15) continue;
                    int yr = this.parseInt(arr[1], 0);
                    int mo = this.parseInt(arr[2], 1);
                    int da = this.parseInt(arr[3], 1);
                    int hr = this.parseInt(arr[4], 0);
                    int mn = this.parseInt(arr[5], 0);
                    int sc = this.parseInt(arr[6], 0);
                    int validity = this.parseInt(arr[7], 1);
                    if (validity < 3 || Double.isNaN(mag = this.parseDouble(arr[9], Double.NaN))) continue;
                    String country = arr[13];
                    country = country.replaceAll("\"", "");
                    double lat = this.parseDouble(arr[15], 100.0);
                    double lon = this.parseDouble(arr[16], 500.0);
                    if (lon < 0.0) {
                        lon += 360.0;
                    }
                    this.event = new SeismicEvent(mag, lon, lat);
                    this.event.setCountry(country);
                    this.event.setDepth(0.0);
                    this.event.setTime(yr, mo, da, hr, mn, sc);
                    this.event.setID(String.format("%d", ++count));
                    events.add(this.event);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                log.log(Level.WARNING, "Error parsing NGDC events", x);
                if (line == null) break block16;
                log.info("line:" + line);
            }
        }
    }

    public int parseInt(String s, int defaultVal) {
        int retVal = defaultVal;
        if (s.length() > 0) {
            try {
                retVal = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public double parseDouble(String s, double defaultVal) {
        double retVal = defaultVal;
        if (s.length() > 0) {
            try {
                retVal = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static void main(String[] args) {
        File testFile = new File("/Users/cmoore/tsunami/devel/TsuCAT/TsuCAT/etc/ngdcEvents2022.txt");
        Vector<SeismicEvent> events = new Vector<SeismicEvent>();
        QuakeNGDCParser p = new QuakeNGDCParser();
        p.parseEarthquakes(testFile, events);
        System.out.println("size: " + events.size());
        for (SeismicEvent e : events) {
            System.out.println(e);
        }
        Iterator<SeismicEvent> it = events.iterator();
        while (it.hasNext()) {
            SeismicEvent se = it.next();
            if (!(se.getMagnitude() < 6.2)) continue;
            it.remove();
        }
        GregorianCalendar cal = new GregorianCalendar(1699, 6, 1);
        Iterator<SeismicEvent> it2 = events.iterator();
        while (it2.hasNext()) {
            SeismicEvent se = it2.next();
            if (!se.getCalendar().before(cal)) continue;
            it2.remove();
        }
        PropagationDatabase propdb = PropagationDatabase.getInstance();
        try {
            propdb.addDatabaseLocation("/Users/cmoore/Library/TsuCAT/etc", true);
        }
        catch (IOException ex) {
            PropagationDatabase.propdbLogger.log(Level.SEVERE, null, ex);
        }
        int count = 0;
        for (SeismicEvent se : events) {
            String ssID = String.format("n%d", ++count);
            SourceCombo sourceCombo = propdb.getSeismicInversion(se.getMagnitude(), se.getLongitude(), se.getLatitude());
            SourceScenario ss = new SourceScenario(ssID, se, sourceCombo.getSourceNames(), SourceScenario.Type.SEISMIC);
            se.addSourceScenario(ss);
        }
        for (SeismicEvent se : events) {
            System.out.println("event: " + se.toString() + " sc: " + se.getScenarioList().get(0).getSourceNamesAndSlips());
        }
        CountryBoundaries.loadCountries(new File("/Users/cmoore/ComMIT/etc/countryReducedAKandHI.kml"));
        File allEventsFile = new File("/Users/cmoore/ComMIT/etc/allEvents.xml");
        SimpleEventParser eventParser = new SimpleEventParser();
        Vector<SeismicEvent> twebEvents = eventParser.getEvents(allEventsFile);
        for (SeismicEvent se : twebEvents) {
            se.setCountry(CountryBoundaries.getCountry(se.getLongitude(), se.getLatitude()).toUpperCase());
        }
    }
}

