/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Runup
implements Shape {
    private String id = "";
    private String event_id = "";
    private boolean doubtful = true;
    private String loc_name = "home";
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double water_ht = 0.0;
    private double inundation = 0.0;
    private int type = -1;
    private Color fillColor = new Color(0, 255, 197);
    private Color drawColor = Color.BLACK;
    private float[] xpoints;
    private float[] ypoints;
    private float scale = 1.0f;

    public Runup() {
        this("", "", true, "home", 0.0, 0.0, 0.0, 0.0, -1);
    }

    public Runup(String id, String event_id, boolean doubtful, String loc_name, double latitude, double longitude, double water_ht, double inundation, int type) {
        this.id = id;
        this.event_id = event_id;
        this.doubtful = doubtful;
        this.loc_name = loc_name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.water_ht = water_ht;
        this.inundation = inundation;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEvent_id() {
        return this.event_id;
    }

    public void setEvent_id(String event_id) {
        this.event_id = event_id;
    }

    public boolean isDoubtful() {
        return this.doubtful;
    }

    public void setDoubtful(boolean doubtful) {
        this.doubtful = doubtful;
    }

    public String getLoc_name() {
        return this.loc_name;
    }

    public void setLoc_name(String loc_name) {
        this.loc_name = loc_name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude < 0.0 ? longitude + 360.0 : longitude;
    }

    public double getWater_ht() {
        return this.water_ht;
    }

    public void setWater_ht(double water_ht) {
        this.water_ht = water_ht;
    }

    public double getInundation() {
        return this.inundation;
    }

    public void setInundation(double inundation) {
        this.inundation = inundation;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        return String.format("ID: %s lat: %2.5f, lon: %2.5f, loc: %s, ht: %2.3f[m], inun: %2.3f[m], type: %d, doubtful: %s", this.event_id, this.latitude, this.longitude, this.loc_name, this.water_ht, this.inundation, this.type, this.doubtful ? "true" : "false");
    }

    public void setScale(double scale) {
        this.scale = (float)scale;
        this.constructShape();
    }

    public void constructShape() {
        switch (this.type) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.fillColor = new Color(255, 170, 0);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                this.fillColor = new Color(0, 255, 197);
            }
        }
        float lo = (float)this.longitude;
        float wid = 0.04f;
        float la = (float)this.latitude;
        float hit = 1.2f;
        if (this.water_ht < 10.0) {
            hit = 1.0f;
        }
        if (this.water_ht < 5.0) {
            hit = 0.8f;
        }
        if (this.water_ht < 2.0) {
            hit = 0.6f;
        }
        if (this.water_ht < 1.0) {
            hit = 0.4f;
        }
        this.xpoints = new float[]{lo, lo + (wid *= this.scale), lo + wid, lo - wid, lo - wid, lo};
        this.ypoints = new float[]{la, la, la + (hit *= this.scale), la + hit, la, la};
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setDrawColor(Color c) {
        this.drawColor = c;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    @Override
    public Rectangle getBounds() {
        float xMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMin = Float.MAX_VALUE;
        float yMax = Float.MIN_VALUE;
        for (int i = 0; i < this.xpoints.length; ++i) {
            xMin = xMin < this.xpoints[i] ? xMin : this.xpoints[i];
            xMax = xMax > this.xpoints[i] ? xMax : this.xpoints[i];
            yMin = yMin < this.ypoints[i] ? yMin : this.ypoints[i];
            yMax = yMax > this.ypoints[i] ? yMax : this.ypoints[i];
        }
        return new Rectangle((int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public boolean crossPositive(float x_a, float y_a, float x_b, float y_b, double x_d, double y_d) {
        return (x_d - (double)x_a) * (double)(y_b - y_a) - (y_d - (double)y_a) * (double)(x_b - x_a) > 0.0;
    }

    @Override
    public boolean contains(double x, double y) {
        for (int i = 0; i < this.xpoints.length - 1; ++i) {
            if (!this.crossPositive(this.xpoints[i], this.ypoints[i], this.xpoints[i + 1], this.ypoints[i + 1], x, y)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new StarShapePathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new StarShapePathIterator(at);
    }

    class StarShapePathIterator
    implements PathIterator {
        AffineTransform transform;
        int index;

        public StarShapePathIterator(AffineTransform at) {
            this.transform = at;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > Runup.this.xpoints.length;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= Runup.this.xpoints.length) {
                return 4;
            }
            coords[0] = Runup.this.xpoints[this.index];
            coords[1] = Runup.this.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= Runup.this.xpoints.length) {
                return 4;
            }
            coords[0] = Runup.this.xpoints[this.index];
            coords[1] = Runup.this.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

