/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.events;

import gov.noaa.tsunami.websift.events.BaseEvent;
import gov.noaa.tsunami.websift.events.BasinBoundaries;
import gov.noaa.tsunami.websift.propdb.Point3D;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class SeismicEvent
extends BaseEvent
implements Serializable {
    private double longitude = 180.0;
    private double latitude = 0.0;
    private double Mw = -1.0;
    private double depth = 0.0;
    private GregorianCalendar eventTime;
    private BasinBoundaries.Basin basin = BasinBoundaries.Basin.UNKNOWN;
    private String country = "";
    private String xmlFileName;
    private static final double Re = 6371.22;
    private static final double D2R = Math.PI / 180;
    public static final int SEED = 851;
    private static final SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    private static final DecimalFormat dfx = new DecimalFormat("0.0#");
    private static final DecimalFormat dfxxx = new DecimalFormat("0.000");
    private boolean focalMechanism = false;
    private double node1Strike = 0.0;
    private double node1Rake = 0.0;
    private double node1Dip = 0.0;
    private double node2Strike = 0.0;
    private double node2Rake = 0.0;
    private double node2Dip = 0.0;
    private boolean hypothetical = false;

    public SeismicEvent() {
        this(-1.0, 180.0, 0.0);
    }

    public SeismicEvent(double mag, double lon, double lat) {
        this(mag, lon, lat, false);
    }

    public SeismicEvent(double mag, double lon, double lat, boolean hypothetical) {
        this.eventTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.eventTime.setTimeInMillis(0L);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.Mw = mag;
        this.longitude = lon;
        this.latitude = lat;
        this.hypothetical = hypothetical;
    }

    public void setBasin(BasinBoundaries.Basin b) {
        this.basin = b;
    }

    public BasinBoundaries.Basin getBasin() {
        return this.basin;
    }

    public void setFocalMechanism() {
        this.focalMechanism = true;
    }

    public boolean getFocalMechanism() {
        return this.focalMechanism;
    }

    public double getNode1Strike() {
        return this.node1Strike;
    }

    public void setNode1Strike(double node1Strike) {
        this.node1Strike = node1Strike;
    }

    public double getNode1Rake() {
        return this.node1Rake;
    }

    public void setNode1Rake(double node1Rake) {
        this.node1Rake = node1Rake;
    }

    public double getNode1Dip() {
        return this.node1Dip;
    }

    public void setNode1Dip(double node1Dip) {
        this.node1Dip = node1Dip;
    }

    public double getNode2Strike() {
        return this.node2Strike;
    }

    public void setNode2Strike(double node2Strike) {
        this.node2Strike = node2Strike;
    }

    public double getNode2Rake() {
        return this.node2Rake;
    }

    public void setNode2Rake(double node2Rake) {
        this.node2Rake = node2Rake;
    }

    public double getNode2Dip() {
        return this.node2Dip;
    }

    public void setNode2Dip(double node2Dip) {
        this.node2Dip = node2Dip;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double lon) {
        this.longitude = lon;
        if (this.longitude < 0.0) {
            this.longitude += 360.0;
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double lat) {
        this.latitude = lat;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public static String properNounCapitalize(String s) {
        String t = s.trim();
        if (t.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String[] sarr = t.split(" ");
        String spc = "";
        for (int i = 0; i < sarr.length; ++i) {
            sb.append(spc);
            if (sarr[i].equals("and")) {
                sb.append(sarr[i]);
            } else if (sarr[i].length() > 1) {
                sb.append(sarr[i].substring(0, 1).toUpperCase());
                sb.append(sarr[i].substring(1).toLowerCase());
            }
            spc = " ";
        }
        return sb.toString();
    }

    public Point3D getEpicenter() {
        return new Point3D(this.longitude, this.latitude, 0.0);
    }

    public void setEpicenter(Point3D p) {
        this.longitude = p.x;
        this.latitude = p.y;
    }

    public double getMagnitude() {
        return this.Mw;
    }

    public void setMagnitude(double mag) {
        this.Mw = mag;
    }

    public void setDepth(double d) {
        this.depth = d;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setFileName(String name) {
        this.xmlFileName = name;
    }

    public String getFileName() {
        return this.xmlFileName;
    }

    public void setHypothetical(boolean b) {
        this.hypothetical = b;
    }

    public boolean isHypothetical() {
        return this.hypothetical;
    }

    public void setTime(int year, int month, int day, int hh, int mm, int ss) {
        this.eventTime.set(year, month - 1, day, hh, mm, ss);
    }

    public void setTime(Calendar cal) {
        this.eventTime.setTime(cal.getTime());
    }

    public GregorianCalendar getCalendar() {
        return this.eventTime;
    }

    public long getDate() {
        return this.eventTime.getTimeInMillis();
    }

    public String getTime() {
        return df.format(this.eventTime.getTime());
    }

    public String getFileTime() {
        SimpleDateFormat ftdf = new SimpleDateFormat("yyyyMMMdd");
        ftdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return ftdf.format(this.eventTime.getTime()) + "_" + this.id;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SeismicEvent)) {
            return false;
        }
        SeismicEvent that_se = (SeismicEvent)that;
        return Math.abs(this.getDate() - that_se.getDate()) < 180000L && Math.abs(this.getLatitude() - that_se.getLatitude()) < 0.8 && Math.abs(this.getLongitude() - that_se.getLongitude()) < 0.8;
    }

    public int hashCode() {
        int result = 851 + (int)(this.getDate() ^ this.getDate() >>> 32);
        result = result * 31 + this.id.hashCode();
        return result;
    }

    public double distanceFrom(double lat1, double lon1) {
        double theta = Math.sin(lat1 * (Math.PI / 180)) * Math.sin(this.latitude * (Math.PI / 180)) + Math.cos(lat1 * (Math.PI / 180)) * Math.cos(this.latitude * (Math.PI / 180)) * Math.cos((lon1 - this.longitude) * (Math.PI / 180));
        theta = Math.acos(theta);
        return 6371.22 * theta;
    }

    public String Print2() {
        return "Current event: " + this.eventTime.get(5) + " " + (this.eventTime.get(2) + 1) + " " + this.eventTime.get(1) + " " + this.eventTime.get(11) + ":" + this.eventTime.get(12) + ":" + this.eventTime.get(13) + " (UTC) Mw: " + dfx.format(this.Mw) + " epicenter: " + dfxxx.format(this.longitude) + ", " + dfxxx.format(this.latitude);
    }

    public String getEpicenterString() {
        StringBuilder sb = new StringBuilder();
        if (this.latitude > 0.0) {
            sb.append(dfxxx.format(this.latitude)).append('\u00b0').append(" N, ");
        } else {
            sb.append(dfxxx.format(-this.latitude)).append('\u00b0').append(" S, ");
        }
        if (this.longitude > 180.0) {
            sb.append(dfxxx.format(360.0 - this.longitude)).append('\u00b0').append(" W");
        } else if (this.longitude < 0.0) {
            sb.append(dfxxx.format(-this.longitude)).append('\u00b0').append(" W");
        } else {
            sb.append(dfxxx.format(this.longitude)).append('\u00b0').append(" E");
        }
        return sb.toString();
    }

    public String Print() {
        return this.toString();
    }

    public boolean isProject() {
        return this.getMagnitude() < 0.0;
    }

    public String toString() {
        if (this.isProject()) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder();
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        sb.append(df.format(this.eventTime.getTime()) + " (UTC)  Mw: " + dfx.format(this.Mw));
        sb.append(" Ep: ");
        sb.append(this.getEpicenterString());
        if (this.depth != 0.0) {
            sb.append(" Dep: " + dfx.format(this.depth) + " [km]");
        }
        if (this.country.length() != 0) {
            sb.append(" \"" + this.country + "\"");
        }
        return sb.toString();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<event type=\"epicenter\" eventid=\"" + this.id + "\" uri=\"\">\n");
        sb.append("  <hypocenter>\n");
        sb.append("    <latitude units=\"degrees_north\">" + this.latitude + "</latitude>\n");
        sb.append("    <longitude units=\"degrees_east\">" + this.longitude + "</longitude>\n");
        sb.append("    <origin_time year=\"" + this.eventTime.get(1) + "\" month=\"" + (this.eventTime.get(2) + 1) + "\" day=\"" + this.eventTime.get(5) + "\" hour=\"" + this.eventTime.get(11) + "\" min=\"" + this.eventTime.get(12) + "\" secs=\"" + this.eventTime.get(13) + "\"/>\n");
        sb.append("    <moment magnitude=\"" + this.Mw + "\"/>\n");
        sb.append("    <depth units=\"kilometers\">" + this.depth + "</depth>\n");
        sb.append("  </hypocenter>\n");
        if (this.name != null && this.name.length() != 0) {
            sb.append("  <annotation>\n");
            sb.append("    <eventname>" + this.name + "</eventname>\n");
            sb.append("  </annotation>\n");
        }
        for (SourceScenario ss : this.getScenarioList()) {
            String tag = ss.getType().name().toLowerCase();
            sb.append(String.format("  <inversion><%1$s>%2$s</%1$s>", tag, ss.getSourceNamesAndSlips()));
            if (ss.getUser() != null && ss.getUser().length() != 0) {
                sb.append("  <usr>").append(ss.getUser()).append("</usr>\n");
            }
            if (ss.getNotes() != null && ss.getNotes().length() != 0) {
                sb.append("  <notes>").append(ss.getNotes()).append("</notes>\n");
            }
            sb.append(" </inversion>\n");
        }
        sb.append("</event>\n");
        return sb.toString();
    }

    public static void sortEventsByTime(Vector<SeismicEvent> se) {
        Collections.sort(se, new timeComparator());
    }

    private static class timeComparator
    implements Comparator<SeismicEvent> {
        private timeComparator() {
        }

        @Override
        public int compare(SeismicEvent o1, SeismicEvent o2) {
            int i = 0;
            i = o1.getCalendar().getTimeInMillis() > o2.getCalendar().getTimeInMillis() ? -1 : (o1.getCalendar().getTimeInMillis() < o2.getCalendar().getTimeInMillis() ? 1 : 0);
            return i;
        }
    }
}

