/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public abstract class AltCompression {
    private static final int HBYTE_MAX = 7;
    private static final int HBYTE_MIN = -8;
    private static final int MAX_COUNT = 8191;
    private static final int NOT_TOP_THREE_SHORT_BITS = 8191;
    private static final int TOP_TWO_SHORT_BITS = 49152;
    private static final int TYPE_0 = 0;
    private static final int TYPE_1 = 16384;
    private static final int TYPE_2 = 32768;
    private static final int TYPE_3 = 49152;
    private static final int RLE = 8192;
    private static final int[] maxRLENotWorthIt = new int[]{4, 3, 2, 1};
    private static final int[][] downgradeWorthIt = new int[][]{new int[0], {9}, {5, 5}, {2, 2, 3}};

    private AltCompression() {
    }

    public static byte[] encodeDynamic(float[] rr) {
        if (rr == null) {
            return null;
        }
        if (rr.length == 0) {
            return new byte[0];
        }
        if (rr.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("input array is too long ( " + rr.length + " >" + Short.MAX_VALUE + ")");
        }
        float am = AltCompression.absmax(rr);
        if (Float.isNaN(am)) {
            return null;
        }
        return AltCompression.actualEncode(rr, AltCompression.Q(am));
    }

    public static byte[] encode(float[] rr, int q) {
        if (rr == null) {
            return null;
        }
        if (rr.length == 0) {
            return new byte[0];
        }
        if (rr.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("input array is too long (" + rr.length + ">" + Short.MAX_VALUE + ")");
        }
        if (q < 1 || q > 31) {
            throw new IllegalArgumentException("Quantization number must 1 <= q <= 32");
        }
        return AltCompression.actualEncode(rr, q);
    }

    private static byte[] actualEncode(float[] rr, int q) {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(32 + rr.length * 4);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int nr = rr.length;
        int tempInt = 0;
        double diff = 0.0;
        int[] intStore = new int[nr];
        int[] matchCount = new int[nr];
        int[] storageType = new int[nr];
        double u0 = 0.0;
        double u1 = 0.0;
        double u2 = 0.0;
        int iq = 1;
        for (int i2 = 1; i2 <= q; ++i2) {
            iq *= 10;
        }
        double quant = 1.0 / (double)iq;
        double x = 0.0;
        int index = 0;
        for (i = 0; i < rr.length; ++i) {
            if (Float.isNaN(rr[i])) {
                tempInt = Integer.MIN_VALUE;
            } else {
                diff = (double)rr[i] + u2 - 2.0 * u1;
                x = diff * (double)iq;
                tempInt = (int)(x > 0.0 ? x + 0.5 : x - 0.5);
                u0 = quant * (double)tempInt - u2 + 2.0 * u1;
                u2 = u1;
                u1 = u0;
            }
            if (i > 0) {
                if (intStore[index] == tempInt) {
                    int n = index;
                    matchCount[n] = matchCount[n] + 1;
                    continue;
                }
                ++index;
            }
            intStore[index] = tempInt;
            int n = index;
            matchCount[n] = matchCount[n] + 1;
            if (tempInt <= 7 && tempInt >= -8) continue;
            storageType[index] = tempInt <= 127 && tempInt >= -128 ? 16384 : (tempInt <= Short.MAX_VALUE && tempInt >= Short.MIN_VALUE ? 32768 : 49152);
        }
        bb.putShort((short)rr.length);
        bb.put((byte)q);
        i = 0;
        block14: while (i <= index) {
            boolean rle;
            int j = i;
            int st = storageType[i];
            boolean bl = rle = matchCount[i] > maxRLENotWorthIt[st >> 14];
            if (rle) {
                bb.putShort((short)(st | matchCount[i] | 0x2000));
                switch (st) {
                    case 0: {
                        bb.put((byte)((intStore[i] << 4) + 8));
                        break;
                    }
                    case 16384: {
                        bb.put((byte)intStore[i]);
                        break;
                    }
                    case 32768: {
                        bb.putShort((short)intStore[i]);
                        break;
                    }
                    case 49152: {
                        bb.putInt(intStore[i]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++i;
                continue;
            }
            int reset = ++i;
            int ct = 0;
            int largestDowngrade = 0;
            while (i <= index) {
                if (st == storageType[i]) {
                    if (matchCount[i] > 2 + maxRLENotWorthIt[storageType[i] >> 14]) break;
                    reset = ++i;
                    ct = 0;
                    largestDowngrade = 0;
                    continue;
                }
                if (storageType[i] > st || matchCount[i] > 2 + maxRLENotWorthIt[storageType[i] >> 14]) break;
                int n = largestDowngrade = storageType[i] > largestDowngrade ? storageType[i] : largestDowngrade;
                if (downgradeWorthIt[st >> 14][largestDowngrade >> 14] >= ct + matchCount[i]) {
                    ct += matchCount[i];
                    ++i;
                    continue;
                }
                i = reset;
                ct = 0;
                break;
            }
            int total = 0;
            for (int z = j; z < i; ++z) {
                total += matchCount[z];
            }
            bb.putShort((short)(st | total & 0xFFFF));
            switch (st) {
                case 0: {
                    int z;
                    int k;
                    byte t = 0;
                    boolean tc = true;
                    for (k = j; k < i; ++k) {
                        for (z = 0; z < matchCount[k]; ++z) {
                            if (tc) {
                                t = (byte)(intStore[k] << 4);
                            } else {
                                t = (byte)(t | intStore[k] + 8);
                                bb.put(t);
                            }
                            tc = !tc;
                        }
                    }
                    if (tc) continue block14;
                    bb.put(t);
                    t = (byte)(t | 8);
                    break;
                }
                case 16384: {
                    int z;
                    int k;
                    for (k = j; k < i; ++k) {
                        for (z = 0; z < matchCount[k]; ++z) {
                            bb.put((byte)intStore[k]);
                        }
                    }
                    continue block14;
                }
                case 32768: {
                    int z;
                    int k;
                    for (k = j; k < i; ++k) {
                        for (z = 0; z < matchCount[k]; ++z) {
                            bb.putShort((short)intStore[k]);
                        }
                    }
                    continue block14;
                }
                case 49152: {
                    int z;
                    int k;
                    for (k = j; k < i; ++k) {
                        for (z = 0; z < matchCount[k]; ++z) {
                            bb.putInt(intStore[k]);
                        }
                    }
                    continue block14;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        byte[] result = new byte[bb.position()];
        bb.flip();
        bb.get(result);
        return result;
    }

    public static int[] info(byte[] ba) {
        return AltCompression.info(ByteBuffer.wrap(ba));
    }

    public static int[] info(ByteBuffer bb) {
        int pos = bb.position();
        int[] ret = new int[2];
        bb.order(ByteOrder.LITTLE_ENDIAN);
        ret[0] = bb.getShort();
        ret[1] = bb.get();
        bb.position(pos);
        return ret;
    }

    public static float[] decode(byte[] ba) {
        return AltCompression.decode(ByteBuffer.wrap(ba));
    }

    public static float[] decode(ByteBuffer bb) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer fdata = FloatBuffer.allocate(bb.getShort());
        int q = bb.get();
        double iq = 1.0;
        for (int i = 1; i <= q; ++i) {
            iq *= 10.0;
        }
        double quant = 1.0 / iq;
        int len = 0;
        byte dd = 0;
        double u0 = 0.0;
        double u1 = 0.0;
        double u2 = 0.0;
        block13: while (bb.position() < bb.limit()) {
            len = bb.getShort();
            int type = len & 0xC000;
            boolean rle = (0x2000 & len) == 8192;
            len = len & 0x1FFF & 0xFFFF;
            if (rle) {
                int i;
                int v = 0;
                switch (type) {
                    case 0: {
                        v = bb.get() >> 4;
                        break;
                    }
                    case 16384: {
                        v = bb.get();
                        break;
                    }
                    case 32768: {
                        v = bb.getShort();
                        break;
                    }
                    case 49152: {
                        v = bb.getInt();
                    }
                }
                if (v == Integer.MIN_VALUE) {
                    for (i = 0; i < len; ++i) {
                        fdata.put(Float.NaN);
                    }
                    continue;
                }
                for (i = 0; i < len; ++i) {
                    u0 = quant * (double)v + 2.0 * u1 - u2;
                    u2 = u1;
                    u1 = u0;
                    fdata.put((float)u0);
                }
                continue;
            }
            switch (type) {
                case 0: {
                    int i;
                    for (i = 0; i < len / 2; ++i) {
                        dd = bb.get();
                        u0 = quant * (double)(dd >> 4) + 2.0 * u1 - u2;
                        u2 = u1;
                        u1 = u0;
                        fdata.put((float)u0);
                        u0 = quant * (double)((dd & 0xF) - 8) + 2.0 * u1 - u2;
                        u2 = u1;
                        u1 = u0;
                        fdata.put((float)u0);
                    }
                    if (len % 2 <= 0) break;
                    dd = bb.get();
                    u0 = quant * (double)(dd >> 4) + 2.0 * u1 - u2;
                    u2 = u1;
                    u1 = u0;
                    fdata.put((float)u0);
                    break;
                }
                case 16384: {
                    int i;
                    for (i = 0; i < len; ++i) {
                        u0 = quant * (double)bb.get() + 2.0 * u1 - u2;
                        u2 = u1;
                        u1 = u0;
                        fdata.put((float)u0);
                    }
                    continue block13;
                }
                case 32768: {
                    int i;
                    for (i = 0; i < len; ++i) {
                        u0 = quant * (double)bb.getShort() + 2.0 * u1 - u2;
                        u2 = u1;
                        u1 = u0;
                        fdata.put((float)u0);
                    }
                    continue block13;
                }
                case 49152: {
                    int i;
                    for (i = 0; i < len; ++i) {
                        int v = bb.getInt();
                        if (v == Integer.MIN_VALUE) {
                            fdata.put(Float.NaN);
                            continue;
                        }
                        u0 = quant * (double)v + 2.0 * u1 - u2;
                        u2 = u1;
                        u1 = u0;
                        fdata.put((float)u0);
                    }
                    break;
                }
            }
        }
        if (bb.position() != bb.limit()) {
            throw new IllegalStateException("Decoding Error 1");
        }
        return fdata.array();
    }

    public static int Q(float[] fa) {
        float am = AltCompression.absmax(fa);
        if (Float.isNaN(am)) {
            throw new IllegalArgumentException("Cannot calculate quantization for NAN");
        }
        return AltCompression.Q(am);
    }

    public static int Q(float f) {
        return Math.min(8, Math.max(3, 3 + -((int)Math.ceil(Math.log10(f)))));
    }

    private static float absmax(float[] fa) {
        if (fa == null || fa.length == 0) {
            return Float.NaN;
        }
        float ret = Float.NaN;
        for (int i = 0; i < fa.length; ++i) {
            float abs;
            if (Float.isNaN(fa[i]) || !((abs = Math.abs(fa[i])) > ret) && !Float.isNaN(ret)) continue;
            ret = abs;
        }
        return ret;
    }
}

