/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.Decode;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class CombineFull {
    private String sourceDir;
    private double[] lons;
    private double[] lats;
    private double[] times;
    private Decode de;

    public CombineFull(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public float[][][] combineThese(String[] sources, double[] alpha) {
        float[][][] eta = null;
        try {
            this.getLonLatTime(sources[0]);
            eta = new float[this.lons.length][this.lats.length][this.times.length];
            for (int s = 0; s < sources.length; ++s) {
                NetcdfFile ncfile = NetcdfFile.open(this.sourceDir + sources[s]);
                ncfile.findVariable("ha");
                Variable haVar = ncfile.findVariable("ha");
                byte[] ha = (byte[])((ArrayByte.D1)haVar.read()).copyTo1DJavaArray();
                int[][] start = (int[][])ncfile.findVariable("start").read().copyToNDJavaArray();
                int[][] end = (int[][])ncfile.findVariable("end").read().copyToNDJavaArray();
                int[][] start_time = (int[][])ncfile.findVariable("start_time").read().copyToNDJavaArray();
                for (int j = 0; j < this.lats.length; ++j) {
                    for (int i = 0; i < this.lons.length; ++i) {
                        if (end[j][i] <= start[j][i]) continue;
                        float[] data = this.de.decode(Arrays.copyOfRange(ha, start[j][i], end[j][i] + 1), end[j][i] - start[j][i] + 1);
                        for (int k = start_time[j][i]; k < start_time[j][i] + data.length; ++k) {
                            eta[i][j][k] = eta[i][j][k] + (float)alpha[s] * data[k - start_time[j][i]];
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CombineFull.class.getName()).log(Level.SEVERE, null, ex);
        }
        return eta;
    }

    private void getLonLatTime(String fn) throws IOException {
        NetcdfFile ncfile = NetcdfFile.open(this.sourceDir + fn);
        this.de = new Decode(ncfile.findGlobalAttribute("Quantization").getNumericValue().floatValue(), -1.0E34f);
        Variable lonVar = ncfile.findVariable("lon");
        this.lons = (double[])((ArrayDouble.D1)lonVar.read()).copyTo1DJavaArray();
        Variable latVar = ncfile.findVariable("lat");
        this.lats = (double[])((ArrayDouble.D1)latVar.read()).copyTo1DJavaArray();
        Variable timeVar = ncfile.findVariable("time");
        this.times = (double[])((ArrayDouble.D1)timeVar.read()).copyTo1DJavaArray();
    }

    public double[] getLons() {
        return this.lons;
    }

    public double[] getLats() {
        return this.lats;
    }

    public double[] getTimes() {
        return this.times;
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        String dir = "/mnt/nctr_data/propdb/compressed/";
        CombineFull cf = new CombineFull(dir);
        String[] sn = new String[]{"ac_013_a_ha.nc", "ac_013_b_ha.nc", "ac_014_a_ha.nc", "ac_014_b_ha.nc"};
        double[] alphs = new double[]{5.5, 6.7, 2.3, 18.1};
        float[][][] myeta = cf.combineThese(sn, alphs);
        System.out.println("done, elapsed: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " secs.");
    }
}

