/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.tools.decode.NioSDecode;
import gov.noaa.tsunami.websift.propdb.AltCompression;
import gov.noaa.tsunami.websift.propdb.PropFileReaderBase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.Range2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class CompressedPropFileReader
extends PropFileReaderBase {
    private boolean dynamic = false;
    private Number quant = 0.0;
    private Variable bytevar;
    private int[][] srcStart;
    private int[][] srcEnd;
    private int[][] srcStartTime;
    private static final float FLOAT_MISSING_VALUE = -1.0E34f;

    public CompressedPropFileReader(File infile, PropagationDatabase.ModelVariable modelVariable, Range2D subset) throws PropagationDatabaseException {
        super(infile, modelVariable, subset);
        if (this.containsTimeseries()) {
            String bytevarName;
            if (this.ncfile.findGlobalAttribute("Quantization") != null) {
                Attribute qatt = this.ncfile.findGlobalAttribute("Quantization");
                this.dynamic = qatt.isString();
                this.quant = 0.0;
                if (!this.dynamic) {
                    this.quant = qatt.getNumericValue();
                }
            } else {
                throw new PropagationDatabaseException("Quantization attribute not found in compressed source file " + this.ncfile.getLocation());
            }
            try {
                this.srcStart = (int[][])this.findNcVariable("start").read(this.origin, this.shape).copyToNDJavaArray();
                this.srcEnd = (int[][])this.findNcVariable("end").read(this.origin, this.shape).copyToNDJavaArray();
                if (!this.dynamic) {
                    this.srcStartTime = (int[][])this.findNcVariable("start_time").read(this.origin, this.shape).copyToNDJavaArray();
                }
            }
            catch (IOException ex) {
                throw new PropagationDatabaseException(ex);
            }
            catch (InvalidRangeException ex) {
                throw new PropagationDatabaseException(ex);
            }
            switch (this.modelVariable) {
                case UA: {
                    bytevarName = "ua";
                    break;
                }
                case VA: {
                    bytevarName = "va";
                    break;
                }
                default: {
                    bytevarName = "ha";
                }
            }
            this.bytevar = this.findNcVariable(bytevarName);
            if (this.bytevar == null || this.bytevar.getDataType() != DataType.BYTE) {
                throw new PropagationDatabaseException(String.format("Byte variable %s not found in compressed propagation file %s", bytevarName, this.ncfile.getLocation()));
            }
            this.bytevar.getDimension(0).setUnlimited(false);
        }
    }

    public CompressedPropFileReader(File infile, PropagationDatabase.ModelVariable modelVar) throws PropagationDatabaseException {
        this(infile, modelVar, null);
    }

    public float[] getTimeseries(int ii, int jj) throws IOException {
        float[] srcResult = this.getZeroRemovedTimeseries(ii, jj);
        if (srcResult == null) {
            return null;
        }
        float[] result = new float[this.getTimeSize()];
        if (this.dynamic) {
            System.arraycopy(srcResult, 0, result, 0, srcResult.length);
        } else {
            System.arraycopy(srcResult, 0, result, this.getTimeseriesOffsetAt(ii, jj), srcResult.length);
        }
        return result;
    }

    public final byte[] getCompressedTimeseries(int ii, int jj) throws IOException {
        if (this.srcStart == null || this.srcStart[jj][ii] < 0) {
            return null;
        }
        int[] srcOrigin = new int[]{this.srcStart[jj][ii]};
        int[] copyShape = new int[]{this.srcEnd[jj][ii] - srcOrigin[0] + 1};
        try {
            return (byte[])this.bytevar.read(srcOrigin, copyShape).copyTo1DJavaArray();
        }
        catch (InvalidRangeException ex) {
            throw new ArrayIndexOutOfBoundsException(ex.getMessage());
        }
    }

    public final float[] getZeroRemovedTimeseries(int ii, int jj) throws IOException {
        byte[] srcBytes = this.getCompressedTimeseries(ii, jj);
        if (srcBytes == null) {
            return null;
        }
        try {
            if (this.dynamic) {
                return AltCompression.decode(srcBytes);
            }
            return NioSDecode.decode(srcBytes, this.quant.floatValue());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public final int getTimeseriesOffsetAt(int ii, int jj) {
        return this.srcStartTime[jj][ii];
    }

    public Array getTravelTimeArray() {
        try {
            Variable ttvar = this.findNcVariable("travel_time");
            return ttvar.read(this.origin, this.shape);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Array getDeformation() {
        try {
            Variable defvar = this.findNcVariable("deformation");
            int[] defshape = defvar.getShape();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < defshape.length; ++i) {
                ranges.add(new Range(0, defshape[i] - 1, 4));
            }
            return defvar.read(ranges);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Array getMaxValueArray() {
        String maxVariableName;
        switch (this.modelVariable) {
            case UA: {
                maxVariableName = "max_ua";
                break;
            }
            case VA: {
                maxVariableName = "max_va";
                break;
            }
            default: {
                maxVariableName = "max_height";
            }
        }
        try {
            Variable ttvar = this.findNcVariable(maxVariableName);
            return ttvar.read(this.origin, this.shape);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

