/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.Encode;
import gov.noaa.tsunami.websift.propdb.PropFileWriterBase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Dimension;

public class CompressedPropFileWriter
extends PropFileWriterBase {
    private float quantization;
    private ArrayInt startArr;
    private ArrayInt endArr;
    private ArrayInt startTimeArr;
    private Index startIdx;
    private Index endIdx;
    private Index startTimeIdx;
    private ArrayFloat maxValueArr = null;
    private ArrayFloat travelTimeArr = null;
    private ArrayFloat.D2 deformation = null;
    private Index maxValueIdx = null;
    private Index travelTimeIdx = null;
    private int outputIndex = 0;
    private int outputIndexWritten = 0;
    private Encode encoder;
    private ByteBuffer writeBuffer;
    private boolean outputSummaryVars = true;
    private float Tquant;
    private float eps = 3.0f;
    private float beta = 7.0f;
    private float Tmax = 30.0f;
    private float defmax = 0.0f;

    public CompressedPropFileWriter(File outFile, PropagationDatabase.ModelVariable modelVariable) {
        super(outFile, modelVariable);
        this.setQuantization(0.001f);
    }

    public void setOutputSummaryVariable(boolean doOutputVars) {
        if (this.time != null || this.longitude != null) {
            throw new IllegalStateException("setOutputSummaryVariable() can only be called before setDimensions()");
        }
        this.outputSummaryVars = doOutputVars;
    }

    @Override
    public void create() throws IOException {
        assert (!this.outputTimeseriesVars || this.writeBuffer != null) : "writeBuffer should have been allocated by setDimensions() if outputTimeseriesVars is set";
        if (this.outputTimeseriesVars) {
            this.addGlobalAttribute("Quantization", Float.valueOf(this.getQuantization()));
        }
        super.create();
    }

    @Override
    public void writeTimeseries(int ii, int jj, float[] timeseries) throws IOException {
        if (this.outputTimeseriesVars) {
            int bytesEncoded = this.encoder.encode(timeseries, timeseries.length);
            byte[] tsBytes = this.encoder.getInternalStore();
            if (tsBytes == null) {
                return;
            }
            this.writeCompressedTimeseries(ii, jj, this.encoder.getStartZeros(), tsBytes, bytesEncoded);
        }
        if (this.outputSummaryVars) {
            float tsmax = this.computeMaximum(timeseries);
            this.maxValueArr.set(this.maxValueIdx.set(jj, ii), tsmax);
            if (this.travelTimeArr != null) {
                this.travelTimeArr.set(this.travelTimeIdx.set(jj, ii), this.computeTravelTime(timeseries, this.deformation.get(jj, ii), tsmax));
            }
        }
    }

    public final void writeCompressedTimeseries(int ii, int jj, int startTimeOffset, byte[] tsBytes) throws IOException {
        this.writeCompressedTimeseries(ii, jj, startTimeOffset, tsBytes, tsBytes.length);
    }

    public final void writeCompressedTimeseries(int ii, int jj, int startTimeOffset, byte[] tsBytes, int byteCount) throws IOException {
        assert (byteCount <= tsBytes.length);
        if (!this.outputTimeseriesVars) {
            throw new IllegalStateException("writeCompressedTimeseries() cannot be called after setOutputTimeseriesVariable(false)");
        }
        this.startArr.set(this.startIdx.set(jj, ii), this.outputIndex);
        this.outputIndex += byteCount;
        this.endArr.set(this.endIdx.set(jj, ii), this.outputIndex - 1);
        this.startTimeArr.set(this.startTimeIdx.set(jj, ii), startTimeOffset);
        boolean useCache = true;
        if (byteCount > this.writeBuffer.remaining()) {
            this.flushWriteCache();
            if (byteCount > this.writeBuffer.remaining()) {
                this.writeTimeseriesBytes(tsBytes, byteCount);
                return;
            }
        }
        this.writeBuffer.put(tsBytes, 0, byteCount);
    }

    @Override
    public void close() throws IOException {
        if (this.outputTimeseriesVars) {
            try {
                this.outNcFile.write("start", this.startArr);
                this.outNcFile.write("end", this.endArr);
                this.outNcFile.write("start_time", this.startTimeArr);
            }
            catch (InvalidRangeException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        if (this.outputSummaryVars) {
            try {
                if (this.travelTimeArr != null) {
                    this.outNcFile.write("travel_time", this.travelTimeArr);
                }
                this.outNcFile.write(this.getMaximumVarName(), this.maxValueArr);
            }
            catch (InvalidRangeException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        this.flushWriteCache();
        super.close();
    }

    public float getQuantization() {
        return this.quantization;
    }

    public void setQuantization(float quantization) {
        this.quantization = quantization;
        this.encoder = new Encode(this.quantization, -1.0E34f);
    }

    void setTravelTimeArray(Array ttArr) {
        if (this.travelTimeArr != null && ttArr != null) {
            Array.arraycopy(ttArr, 0, this.travelTimeArr, 0, (int)Math.min(ttArr.getSize(), this.travelTimeArr.getSize()));
        }
    }

    void setMaxValueArray(Array mxArr) {
        if (this.maxValueArr != null && mxArr != null) {
            Array.arraycopy(mxArr, 0, this.maxValueArr, 0, (int)Math.min(mxArr.getSize(), this.maxValueArr.getSize()));
        }
    }

    private float computeTravelTime(float[] timeseries, float deform, float maxValue) {
        float Thmax = 0.05f * maxValue;
        float TD = 0.0f;
        float threshold = 0.0f;
        TD = (double)Math.abs(deform / this.defmax) < 0.02 ? this.eps * Math.abs(deform) : Math.min(this.eps * Math.abs(deform), maxValue / this.beta);
        threshold = Math.min(this.Tmax, Math.max(TD, Math.max(Thmax, this.Tquant)));
        for (int k = 0; k < timeseries.length; ++k) {
            if (!(timeseries[k] >= threshold)) continue;
            return (float)this.time[k] / 3600.0f;
        }
        return -1.0E34f;
    }

    private float computeMaximum(float[] timeseries) {
        float maxf = Float.NEGATIVE_INFINITY;
        for (float f : timeseries) {
            if (!(f > maxf)) continue;
            maxf = f;
        }
        return maxf;
    }

    private final void flushWriteCache() throws IOException {
        if (this.outputTimeseriesVars && this.writeBuffer.position() > 0) {
            this.writeTimeseriesBytes(this.writeBuffer.array(), this.writeBuffer.position());
            this.writeBuffer.clear();
        }
        assert (this.outputIndexWritten == this.outputIndex);
    }

    private final void writeTimeseriesBytes(byte[] bytes, int byteCount) throws IOException {
        Array arr = Array.factory(Byte.TYPE, new int[]{byteCount}, (Object)bytes);
        try {
            this.outNcFile.write(this.getModelVarName(), new int[]{this.outputIndexWritten}, arr);
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex.getMessage());
        }
        this.outputIndexWritten += byteCount;
    }

    public void setTquant(float tquant) {
        this.Tquant = tquant;
        this.defmax = (float)MAMath.getMaximum(this.deformation);
    }

    public void addDeformation(Array def, float slip) {
        ArrayFloat.D2 def2 = (ArrayFloat.D2)def;
        for (int i = 0; i < this.shape[0]; ++i) {
            for (int j = 0; j < this.shape[1]; ++j) {
                this.deformation.set(i, j, slip * def2.get(i, j));
            }
        }
    }

    @Override
    public void setDimensions(double[] lon, double[] lat, double[] tim) {
        Dimension timedim = null;
        Dimension idxdim = null;
        if (this.outputTimeseriesVars) {
            timedim = this.outNcFile.addDimension("time", tim.length);
            idxdim = this.outNcFile.addUnlimitedDimension("index");
        }
        super.setDimensions(lon, lat, tim);
        if (this.outputTimeseriesVars) {
            this.outNcFile.addVariable("time", DataType.DOUBLE, new Dimension[]{timedim});
            this.addVariableAttributes("time", null, "seconds", null);
            this.outNcFile.addVariable("start", DataType.INT, this.latlondims);
            this.addVariableAttributes("start", "Starting Index", null, null);
            this.addMissingValueAttributes("start", -1);
            this.outNcFile.addVariable("end", DataType.INT, this.latlondims);
            this.addVariableAttributes("end", "Ending Index", null, null);
            this.addMissingValueAttributes("end", -1);
            this.outNcFile.addVariable("start_time", DataType.INT, this.latlondims);
            this.addVariableAttributes("start_time", "Time of Starting Index", null, null);
            this.addMissingValueAttributes("start_time", -1);
            this.startArr = new ArrayInt(this.shape);
            this.endArr = new ArrayInt(this.shape);
            this.startTimeArr = new ArrayInt(this.shape);
            this.startIdx = this.startArr.getIndex();
            this.endIdx = this.endArr.getIndex();
            this.startTimeIdx = this.startTimeArr.getIndex();
            this.arrayInitialize(this.startArr, this.startIdx, this.shape);
            this.arrayInitialize(this.endArr, this.endIdx, this.shape);
            this.arrayInitialize(this.startTimeArr, this.startTimeIdx, this.shape);
        }
        if (this.outputSummaryVars) {
            String maxVarName = this.getMaximumVarName();
            this.outNcFile.addVariable(maxVarName, DataType.FLOAT, this.latlondims);
            this.addVariableAttributes(maxVarName, "Maximum " + this.getVarLongName(), this.getVarUnits(), null);
            this.addMissingValueAttributes(maxVarName, -1.0E34f);
            this.maxValueArr = new ArrayFloat(this.shape);
            this.deformation = new ArrayFloat.D2(this.shape[0], this.shape[1]);
            this.maxValueIdx = this.maxValueArr.getIndex();
            this.arrayInitialize(this.maxValueArr, this.maxValueIdx, this.shape);
            if (this.modelVariable == PropagationDatabase.ModelVariable.HA) {
                this.outNcFile.addVariable("travel_time", DataType.FLOAT, this.latlondims);
                this.addVariableAttributes("travel_time", "Travel Time", "hours", null);
                this.addMissingValueAttributes("travel_time", -1.0E34f);
                this.travelTimeArr = new ArrayFloat(this.shape);
                this.travelTimeIdx = this.travelTimeArr.getIndex();
                this.arrayInitialize(this.travelTimeArr, this.travelTimeIdx, this.shape);
            }
        }
        if (this.outputTimeseriesVars) {
            String mvarname = this.getModelVarName();
            this.outNcFile.addVariable(mvarname, DataType.BYTE, new Dimension[]{idxdim});
            this.addVariableAttributes(mvarname, this.getVarLongName(), this.getVarUnits(), null);
            int bufcapacity = this.time.length * this.latitude.length * this.longitude.length;
            if (bufcapacity > 524288) {
                bufcapacity = 524288;
            }
            this.writeBuffer = ByteBuffer.allocate(bufcapacity);
        }
    }

    private void arrayInitialize(ArrayFloat arr, Index idx, int[] shape) {
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                arr.set(idx.set(i, j), -1.0E34f);
            }
        }
    }

    private void arrayInitialize(ArrayInt arr, Index idx, int[] shape) {
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                arr.set(idx.set(i, j), -1);
            }
        }
    }

    protected String getMaximumVarName() {
        switch (this.modelVariable) {
            case UA: {
                return "max_ua";
            }
            case VA: {
                return "max_va";
            }
        }
        return "max_height";
    }
}

