/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

public class Decode {
    private static final int BUFFER_LEN = 8192;
    private float quant_ = 0.001f;
    private float fill_;
    private int istore_ = 0;

    public Decode(float quant, float fillvalue) {
        this.quant_ = quant;
        this.fill_ = fillvalue;
    }

    public float[] decode(byte[] store, int nstore) {
        int[] nnn = null;
        nnn = this.unpackStore(store, nstore);
        float[] out = new float[nnn.length];
        float u1 = 0.0f;
        float u2 = 0.0f;
        for (int i = 0; i < nnn.length; ++i) {
            if (nnn[i] < -2147483647) {
                out[i] = this.fill_;
                continue;
            }
            float u0 = this.quant_ * (float)nnn[i] + 2.0f * u1 - u2;
            u2 = u1;
            u1 = u0;
            out[i] = u0;
        }
        return out;
    }

    private int[] unpackStore(byte[] store, int nstore) {
        int[] ndata = new int[8192];
        byte[] read1 = new byte[8192];
        short[] read2 = new short[8192];
        int[] read4 = new int[8192];
        short[] bb = new short[1];
        byte[] aa = new byte[1];
        this.istore_ = 0;
        int idata = 0;
        while (this.istore_ < nstore) {
            this.get_shortArray(store, bb, 1);
            int len = bb[0];
            this.get_byteArray(store, aa, 1);
            if (len >= 8192) {
                throw new RuntimeException("Record is too long:" + len);
            }
            switch (aa[0]) {
                case 0: {
                    int i;
                    int jout = (len + 1) / 2;
                    this.get_byteArray(store, read1, jout);
                    for (i = 0; i < jout; ++i) {
                        byte dd = read1[i];
                        ndata[idata + 2 * i] = dd >> 4;
                        ndata[idata + 2 * i + 1] = (dd & 0xF) - 8;
                    }
                    break;
                }
                case 1: {
                    int i;
                    this.get_byteArray(store, read1, len);
                    for (i = 0; i < len; ++i) {
                        ndata[idata + i] = read1[i];
                    }
                    break;
                }
                case 2: {
                    int i;
                    this.get_shortArray(store, read2, len);
                    for (i = 0; i < len; ++i) {
                        ndata[idata + i] = read2[i];
                    }
                    break;
                }
                case 4: {
                    int i;
                    this.get_intArray(store, read4, len);
                    for (i = 0; i < len; ++i) {
                        ndata[idata + i] = read4[i];
                    }
                    break;
                }
            }
            idata += len;
        }
        if (this.istore_ != nstore) {
            throw new RuntimeException("Decoding Error 1");
        }
        int[] out = new int[idata];
        for (int i = 0; i < idata; ++i) {
            out[i] = ndata[i];
        }
        return out;
    }

    private void get_byteArray(byte[] store, byte[] buff, int len) {
        for (int i = this.istore_; i < this.istore_ + len; ++i) {
            buff[i - this.istore_] = store[i];
        }
        this.istore_ += len;
    }

    private void get_shortArray(byte[] store, short[] buff, int len) {
        for (int i = 0; i < len; ++i) {
            buff[i] = this.get_short(store);
        }
    }

    private void get_intArray(byte[] store, int[] buff, int len) {
        for (int i = 0; i < len; ++i) {
            int a0 = store[this.istore_++] & 0xFF;
            int a1 = store[this.istore_++] & 0xFF;
            int a2 = store[this.istore_++] & 0xFF;
            int a3 = store[this.istore_++] & 0xFF;
            buff[i] = a0 | a1 << 8 | a2 << 16 | a3 << 24;
        }
    }

    private short get_short(byte[] store) {
        short a0 = (short)(store[this.istore_++] & 0xFF);
        short a1 = (short)(store[this.istore_++] & 0xFF);
        return (short)(a0 & 0xFF | a1 << 8);
    }
}

