/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

public class Encode {
    private float quant_ = 0.001f;
    private float eps_;
    private int startZeros_ = 0;
    private int endZeros_ = 0;
    private byte[] store_;
    private int store_cntr_ = 0;
    private static final int HBYTE_MAX = 7;
    private static final int HBYTE_MIN = -8;
    private static final int BYTE_MAX = 127;
    private static final int BYTE_MIN = -128;
    private static final int SHORT_MAX = Short.MAX_VALUE;
    private static final int SHORT_MIN = Short.MIN_VALUE;
    private static final int INT_MAX = Integer.MAX_VALUE;
    private static final int INT_MIN = Integer.MIN_VALUE;
    private static final int NOUT_MIN = 3;

    public Encode(float quant, float eps) {
        this.quant_ = quant;
        this.eps_ = eps;
    }

    public int encode(float[] rr, int nr) {
        int i;
        int[] nn = new int[nr];
        int[] nBts = new int[nr];
        int[] nValues = new int[nr];
        byte[] n1 = new byte[nr];
        short[] n2 = new short[nr];
        int[] n4 = new int[nr];
        int cntr = 0;
        int bt = 0;
        int nout = 0;
        this.store_cntr_ = 0;
        this.store_ = new byte[4 * nr];
        float u1 = 0.0f;
        float u2 = 0.0f;
        this.startZeros_ = 0;
        boolean check_zero = true;
        for (i = 0; i < nr; ++i) {
            int nnn;
            if (rr[i] >= this.eps_) {
                float diff = rr[i] + u2 - 2.0f * u1;
                float x = diff / this.quant_;
                nnn = (int)(x + Math.signum(x) * 0.5f);
                float u0 = this.quant_ * (float)nnn + 2.0f * u1 - u2;
                u2 = u1;
                u1 = u0;
            } else {
                nnn = Integer.MIN_VALUE;
            }
            if (check_zero) {
                if (nnn == 0) {
                    ++this.startZeros_;
                    continue;
                }
                check_zero = false;
            }
            nn[i - this.startZeros_] = nnn;
            int nbt = 4;
            if (nnn <= Integer.MAX_VALUE && nnn >= Integer.MIN_VALUE) {
                nbt = 4;
            }
            if (nnn <= Short.MAX_VALUE && nnn >= Short.MIN_VALUE) {
                nbt = 2;
            }
            if (nnn <= 127 && nnn >= -128) {
                nbt = 1;
            }
            if (nnn <= 7 && nnn >= -8) {
                nbt = 0;
            }
            if (nbt > bt && nout >= 3) {
                nValues[cntr] = nout;
                nBts[cntr] = bt;
                ++cntr;
                nout = 0;
            }
            if (nbt < bt) {
                nValues[cntr] = nout;
                nBts[cntr] = bt;
                ++cntr;
                nout = 0;
            }
            bt = nbt;
            ++nout;
        }
        if (this.startZeros_ >= nr) {
            this.store_cntr_ = 0;
            this.endZeros_ = 0;
            return 0;
        }
        this.endZeros_ = nout;
        i = nr - this.startZeros_ - 1;
        while (nout != 0 && nn[i] == 0) {
            --i;
            --nout;
        }
        if (nout > 0) {
            nValues[cntr] = nout;
            nBts[cntr] = bt;
        } else {
            --cntr;
        }
        this.endZeros_ -= nout;
        int istart = 0;
        i = 0;
        while (i <= cntr) {
            nout = 0;
            bt = nBts[i];
            while (i <= cntr && nBts[i] == bt) {
                nout += nValues[i];
                ++i;
            }
            int iend = istart + nout - 1;
            switch (bt) {
                case 0: {
                    int k;
                    int jout = 0;
                    for (k = istart; k <= iend; k += 2) {
                        int a = nn[k];
                        int b = k < iend ? nn[k + 1] : 0;
                        n1[jout] = (byte)(16 * a + b + 8);
                        ++jout;
                    }
                    this.store_halfs(n1, nout);
                    break;
                }
                case 1: {
                    int k;
                    for (k = istart; k <= iend; ++k) {
                        n1[k - istart] = (byte)nn[k];
                    }
                    this.store_byteArray(n1, nout);
                    break;
                }
                case 2: {
                    int k;
                    for (k = istart; k <= iend; ++k) {
                        n2[k - istart] = (short)nn[k];
                    }
                    this.store_shortArray(n2, nout);
                    break;
                }
                case 4: {
                    int k;
                    for (k = istart; k <= iend; ++k) {
                        n4[k - istart] = nn[k];
                    }
                    this.store_intArray(n4, nout);
                }
            }
            istart = iend + 1;
        }
        return this.store_cntr_;
    }

    public byte[] getStore() {
        byte[] store = new byte[this.store_cntr_];
        System.arraycopy(this.store_, 0, store, 0, this.store_cntr_);
        return store;
    }

    public byte[] getInternalStore() {
        return this.store_;
    }

    public int getStartZeros() {
        return this.startZeros_;
    }

    public int getEndZeros() {
        return this.endZeros_;
    }

    private final void store_short(short val) {
        this.store_[this.store_cntr_++] = (byte)(val & 0xFF);
        this.store_[this.store_cntr_++] = (byte)(val >>> 8);
    }

    private final void store_halfs(byte[] buff, int nout) {
        short len2 = (short)nout;
        int len = (nout + 1) / 2;
        this.store_short(len2);
        this.store_[this.store_cntr_++] = 0;
        int iend = this.store_cntr_ + len - 1;
        for (int i = this.store_cntr_; i <= iend; ++i) {
            this.store_[i] = buff[i - this.store_cntr_];
        }
        this.store_cntr_ = iend + 1;
    }

    private final void store_byteArray(byte[] buff, int nout) {
        this.store_short((short)nout);
        this.store_[this.store_cntr_++] = 1;
        int iend = this.store_cntr_ + nout - 1;
        for (int i = this.store_cntr_; i <= iend; ++i) {
            this.store_[i] = buff[i - this.store_cntr_];
        }
        this.store_cntr_ = iend + 1;
    }

    private final void store_shortArray(short[] buff, int nout) {
        this.store_short((short)nout);
        this.store_[this.store_cntr_++] = 2;
        for (int i = 0; i < nout; ++i) {
            this.store_short(buff[i]);
        }
    }

    private final void store_intArray(int[] buff, int nout) {
        this.store_short((short)nout);
        this.store_[this.store_cntr_++] = 4;
        for (int i = 0; i < nout; ++i) {
            int bb = buff[i];
            this.store_[this.store_cntr_++] = (byte)(bb & 0xFF);
            this.store_[this.store_cntr_++] = (byte)(bb >>> 8 & 0xFF);
            this.store_[this.store_cntr_++] = (byte)(bb >>> 16 & 0xFF);
            this.store_[this.store_cntr_++] = (byte)(bb >>> 24 & 0xFF);
        }
    }
}

