/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.Range2D;
import java.io.File;
import java.io.IOException;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class PropFileReaderBase {
    protected final NetcdfFile ncfile;
    protected final int[] origin = new int[2];
    protected final int[] shape = new int[2];
    private int timeLength;
    private double[] sourceLons;
    private double[] sourceLats;
    protected PropagationDatabase.ModelVariable modelVariable;

    public PropFileReaderBase(NetcdfFile ncfile, Range2D subset) throws PropagationDatabaseException {
        this.ncfile = ncfile;
        this.modelVariable = PropFileReaderBase.findModelVariable(ncfile);
        this.configureDimensions(subset);
    }

    public PropFileReaderBase(NetcdfFile ncfile) throws PropagationDatabaseException {
        this(ncfile, null);
    }

    public PropFileReaderBase(File infile, PropagationDatabase.ModelVariable modelVariable, Range2D subset) throws PropagationDatabaseException {
        try {
            if (modelVariable != null) {
                this.ncfile = NetcdfFile.open(this.getCorrectFileName(infile.getPath(), modelVariable));
                this.modelVariable = modelVariable;
            } else {
                this.ncfile = NetcdfFile.open(infile.getPath());
                this.modelVariable = PropFileReaderBase.findModelVariable(this.ncfile);
            }
        }
        catch (IOException ex) {
            throw new PropagationDatabaseException(ex);
        }
        this.configureDimensions(subset);
    }

    public PropFileReaderBase(File infile, PropagationDatabase.ModelVariable modelVar) throws PropagationDatabaseException {
        this(infile, modelVar, null);
    }

    public PropFileReaderBase(File infile) throws PropagationDatabaseException {
        this(infile, null, null);
    }

    private void configureDimensions(Range2D subset) throws PropagationDatabaseException {
        try {
            Dimension timedim = this.findNcDimension("time");
            this.timeLength = timedim.getLength();
        }
        catch (PropagationDatabaseException ex) {
            this.timeLength = 0;
        }
        Variable latvarsrc = this.findNcVariable("lat");
        Variable lonvarsrc = this.findNcVariable("lon");
        try {
            this.sourceLons = (double[])lonvarsrc.read().copyTo1DJavaArray();
            this.sourceLats = (double[])latvarsrc.read().copyTo1DJavaArray();
        }
        catch (IOException ex) {
            throw new PropagationDatabaseException(ex);
        }
        if (subset == null) {
            this.origin[0] = 0;
            this.origin[1] = 0;
            this.shape[0] = (int)latvarsrc.getSize();
            this.shape[1] = (int)lonvarsrc.getSize();
        } else {
            double sx = this.sourceLons[0] < 0.0 && subset.x > 180.0 ? subset.x - 360.0 : (this.sourceLons[this.sourceLons.length - 1] > 180.0 && subset.x < 0.0 ? subset.x + 360.0 : subset.x);
            double[] rangeCoords = new double[]{sx, sx + subset.w};
            int[] xidx = PropFileReaderBase.findCoordinateIndices(this.sourceLons, rangeCoords);
            if (xidx[0] == 0 && xidx[1] == 0 || xidx[0] == this.sourceLons.length - 1 && xidx[1] == this.sourceLons.length - 1) {
                throw new PropagationDatabaseException("Requested longitude extent is outside of propagation grid " + this.ncfile.getLocation());
            }
            rangeCoords[0] = subset.y;
            rangeCoords[1] = subset.y + subset.h;
            int[] yidx = PropFileReaderBase.findCoordinateIndices(this.sourceLats, rangeCoords);
            if (yidx[0] == 0 && yidx[1] == 0 || yidx[0] == this.sourceLats.length - 1 && yidx[1] == this.sourceLats.length - 1) {
                throw new PropagationDatabaseException("Requested longitude extent is outside of propagation grid " + this.ncfile.getLocation());
            }
            this.origin[0] = yidx[0];
            this.origin[1] = xidx[0];
            this.shape[0] = yidx[1] - yidx[0] + 1;
            this.shape[1] = xidx[1] - xidx[0] + 1;
            double[] tmp = new double[this.shape[0]];
            System.arraycopy(this.sourceLats, this.origin[0], tmp, 0, this.shape[0]);
            this.sourceLats = tmp;
            tmp = new double[this.shape[1]];
            System.arraycopy(this.sourceLons, this.origin[1], tmp, 0, this.shape[1]);
            this.sourceLons = tmp;
        }
    }

    private static PropagationDatabase.ModelVariable findModelVariable(NetcdfFile ncf) throws PropagationDatabaseException {
        try {
            for (Variable v : ncf.getVariables()) {
                if (v.getName().equalsIgnoreCase("ha") || v.getName().equalsIgnoreCase("max_height")) {
                    return PropagationDatabase.ModelVariable.HA;
                }
                if (v.getName().equalsIgnoreCase("ua") || v.getName().equalsIgnoreCase("max_ua")) {
                    return PropagationDatabase.ModelVariable.UA;
                }
                if (!v.getName().equalsIgnoreCase("va") && !v.getName().equalsIgnoreCase("max_va")) continue;
                return PropagationDatabase.ModelVariable.VA;
            }
        }
        catch (Exception ex) {
            throw new PropagationDatabaseException("Expected to find one of HA, UA, or VA variable in input file " + ncf.getLocation());
        }
        throw new PropagationDatabaseException("Expected to find one of HA, UA, or VA variable in input file " + ncf.getLocation());
    }

    public double[] getLongitudeCoordinates() {
        return this.sourceLons;
    }

    public double[] getLatitudeCoordinates() {
        return this.sourceLats;
    }

    public double[] getTimeCoordinates() {
        try {
            return (double[])this.findNcVariable("time").read().copyTo1DJavaArray();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getLongitudeSize() {
        return this.sourceLons.length;
    }

    public int getLatitudeSize() {
        return this.sourceLats.length;
    }

    public int getTimeSize() {
        return this.timeLength;
    }

    public boolean containsTimeseries() {
        return this.getTimeSize() > 0;
    }

    protected Variable findNcVariable(String varName) throws PropagationDatabaseException {
        Variable rv = this.ncfile.findVariable(varName);
        if (rv != null) {
            rv.getDimension(0).setUnlimited(false);
            return rv;
        }
        rv = this.ncfile.findVariable(varName.toLowerCase());
        if (rv != null) {
            rv.getDimension(0).setUnlimited(false);
            return rv;
        }
        rv = this.ncfile.findVariable(varName.toUpperCase());
        if (rv != null) {
            rv.getDimension(0).setUnlimited(false);
            return rv;
        }
        throw new PropagationDatabaseException("Required variable " + varName + " not found in source file");
    }

    protected Dimension findNcDimension(String dimName) throws PropagationDatabaseException {
        Dimension rv = this.ncfile.findDimension(dimName);
        if (rv != null) {
            return rv;
        }
        rv = this.ncfile.findDimension(dimName.toLowerCase());
        if (rv != null) {
            return rv;
        }
        rv = this.ncfile.findDimension(dimName.toUpperCase());
        if (rv != null) {
            return rv;
        }
        throw new PropagationDatabaseException("Required dimension " + dimName + " not found in source file");
    }

    protected static int[] findCoordinateIndices(double[] sourceCoords, double[] findCoords) {
        int[] indices = new int[findCoords.length];
        for (int i = 0; i < findCoords.length; ++i) {
            double delta = Double.MAX_VALUE;
            for (int ci = 0; ci < sourceCoords.length; ++ci) {
                double d = Math.abs(sourceCoords[ci] - findCoords[i]);
                if (!(d < delta)) continue;
                indices[i] = ci;
                delta = d;
            }
        }
        return indices;
    }

    public Range2D getLatitudeLongitudeRange() {
        double x = this.sourceLons[0];
        double y = this.sourceLats[0];
        return new Range2D(x, y, this.sourceLons[this.sourceLons.length - 1] - x, this.sourceLats[this.sourceLats.length - 1] - y);
    }

    public PropagationDatabase.ModelVariable getModelVariable() {
        return this.modelVariable;
    }

    private String getCorrectFileName(String fn, PropagationDatabase.ModelVariable var) {
        String s;
        switch (var) {
            default: {
                s = "h";
                break;
            }
            case UA: {
                s = "u";
                break;
            }
            case VA: {
                s = "v";
            }
        }
        return fn.replaceFirst("[huv](a?\\.nc)", s + "$1");
    }

    List<Attribute> getGlobalAttributes() {
        return this.ncfile.getGlobalAttributes();
    }

    public void close() {
        try {
            this.ncfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

