/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.PropFileReaderBase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public abstract class PropFileWriterBase {
    protected NetcdfFileWriteable outNcFile;
    private String historyAttr;
    protected double[] longitude;
    protected double[] latitude;
    protected double[] time;
    protected int[] shape;
    protected Dimension[] latlondims;
    protected PropagationDatabase.ModelVariable modelVariable;
    protected boolean outputTimeseriesVars = true;
    protected static final float FLOAT_MISSING_VALUE = -1.0E34f;
    protected static final int INT_MISSING_VALUE = -1;

    public PropFileWriterBase(File outFile, PropagationDatabase.ModelVariable modelVariable) {
        try {
            this.outNcFile = NetcdfFileWriteable.createNew(outFile.toString());
        }
        catch (IOException ex) {
            Logger.getLogger(PropFileWriterBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.modelVariable = modelVariable;
    }

    public void setOutputTimeseriesVariable(boolean doOutputVars) {
        if (this.time != null || this.longitude != null) {
            throw new IllegalStateException("setOutputTimeseriesVariable() can only be called before setDimensions()");
        }
        this.outputTimeseriesVars = doOutputVars;
    }

    public void addGlobalAttribute(String attrname, String value) {
        if ("history".equals(attrname)) {
            this.historyAttr = value;
        }
        this.outNcFile.addGlobalAttribute(attrname, value);
    }

    public void addGlobalAttribute(Attribute att) {
        this.outNcFile.addGlobalAttribute(att);
    }

    public void addGlobalAttribute(String attrname, Number value) {
        this.outNcFile.addGlobalAttribute(attrname, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGlobalAttribute(String attrname, Object value) {
        Class<?> vclass = value.getClass();
        if (vclass.isArray()) {
            if (vclass.getComponentType().isPrimitive()) {
                this.outNcFile.addGlobalAttribute(attrname, PropFileWriterBase.primitivizeNumberArray(value));
                return;
            } else {
                if (((Object[])value).length < 0) {
                    return;
                }
                if (((Object[])value)[0] instanceof Number) {
                    this.outNcFile.addGlobalAttribute(attrname, PropFileWriterBase.primitivizeNumberArray(value));
                    return;
                } else {
                    if (!(((Object[])value)[0] instanceof String)) throw new IllegalArgumentException("expected array of String, Number, or primitives, not " + vclass.getSimpleName());
                    StringBuilder sb = new StringBuilder();
                    Object[] varr = (Object[])value;
                    for (int i = 0; i < varr.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append((String)varr[i]);
                    }
                    this.addGlobalAttribute(attrname, sb.toString());
                }
            }
            return;
        } else if (value instanceof String) {
            this.addGlobalAttribute(attrname, (String)value);
            return;
        } else {
            if (!(value instanceof Number)) throw new IllegalArgumentException("expected String, Number, or Number[] value, not " + vclass.getSimpleName());
            this.addGlobalAttribute(attrname, (Number)value);
        }
    }

    public void addHistoryEntry(String value) {
        if (this.historyAttr == null) {
            Attribute ha = null;
            try {
                ha = this.outNcFile.findGlobalAttribute("history");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.historyAttr = ha == null ? "" : ha.getStringValue() + "\n";
        }
        String timestamp = new SimpleDateFormat().format(Calendar.getInstance().getTime());
        this.addGlobalAttribute("history", String.format("%s%s %s\n", this.historyAttr, timestamp, value));
    }

    public abstract void writeTimeseries(int var1, int var2, float[] var3) throws IOException;

    public void close() throws IOException {
        this.outNcFile.close();
    }

    public void create() throws IOException {
        if (this.longitude == null || this.latitude == null || this.time == null && this.outputTimeseriesVars) {
            throw new IllegalStateException("Dimension variables are not defined yet; call setDimensions() before create()");
        }
        this.outNcFile.create();
        assert (this.shape[0] == this.latitude.length);
        assert (this.shape[1] == this.longitude.length);
        Array arr = Array.factory(Double.TYPE, new int[]{this.shape[0]}, (Object)this.latitude);
        try {
            this.outNcFile.write("lat", arr);
            arr = Array.factory(Double.TYPE, new int[]{this.shape[1]}, (Object)this.longitude);
            this.outNcFile.write("lon", arr);
            if (this.outputTimeseriesVars) {
                arr = Array.factory(Double.TYPE, new int[]{this.time.length}, (Object)this.time);
                this.outNcFile.write("time", arr);
            }
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void setDimensions(PropFileReaderBase pfr) {
        this.setDimensions(pfr.getLongitudeCoordinates(), pfr.getLatitudeCoordinates(), pfr.getTimeCoordinates());
    }

    public void setDimensions(double[] lon, double[] lat, double[] tim) {
        this.longitude = lon;
        this.latitude = lat;
        this.time = tim;
        this.shape = new int[2];
        this.shape[0] = this.latitude.length;
        this.shape[1] = this.longitude.length;
        Dimension latdim = this.outNcFile.addDimension("lat", this.shape[0]);
        Dimension londim = this.outNcFile.addDimension("lon", this.shape[1]);
        this.outNcFile.addVariable("lat", DataType.DOUBLE, new Dimension[]{latdim});
        this.addVariableAttributes("lat", "latitude", "degrees_north", PropFileWriterBase.computePointSpacing(this.latitude));
        this.outNcFile.addVariable("lon", DataType.DOUBLE, new Dimension[]{londim});
        this.addVariableAttributes("lon", "longitude", "degrees_east", PropFileWriterBase.computePointSpacing(this.longitude));
        this.latlondims = new Dimension[]{latdim, londim};
    }

    protected static String computePointSpacing(double[] coords) {
        double d = coords[1] - coords[0];
        for (int i = 1; i < coords.length; ++i) {
            if (coords[i] - coords[i - 1] == d) continue;
            return "uneven";
        }
        return "even";
    }

    protected void addVariableAttributes(String varname, String long_name, String units, String point_spacing) {
        if (long_name != null) {
            this.outNcFile.addVariableAttribute(varname, "long_name", long_name);
        }
        if (units != null) {
            this.outNcFile.addVariableAttribute(varname, "units", units);
        }
        if (point_spacing != null) {
            this.outNcFile.addVariableAttribute(varname, "point_spacing", point_spacing);
        }
    }

    protected void addMissingValueAttributes(String varname, int missing_value) {
        this.outNcFile.addVariableAttribute(varname, "missing_value", missing_value);
        this.outNcFile.addVariableAttribute(varname, "_FillValue", missing_value);
    }

    protected void addMissingValueAttributes(String varname, float missing_value) {
        this.outNcFile.addVariableAttribute(varname, "missing_value", Float.valueOf(missing_value));
        this.outNcFile.addVariableAttribute(varname, "_FillValue", Float.valueOf(missing_value));
    }

    protected String getVarUnits() {
        return this.modelVariable == PropagationDatabase.ModelVariable.HA ? "cm" : "cm/s";
    }

    protected String getModelVarName() {
        switch (this.modelVariable) {
            case UA: {
                return "ua";
            }
            case VA: {
                return "va";
            }
        }
        return "ha";
    }

    protected String getVarLongName() {
        switch (this.modelVariable) {
            case UA: {
                return "Eastward Velocity";
            }
            case VA: {
                return "Northward Velocity";
            }
        }
        return "Wave Amplitude";
    }

    private static final Array primitivizeNumberArray(Object vobj) {
        int i;
        Object[] a;
        Class<?> cclass = vobj.getClass().getComponentType();
        Object[] varr = (Object[])vobj;
        if (varr.length <= 0) {
            return null;
        }
        int[] shape = new int[]{varr.length};
        Array arr = null;
        if (varr[0] instanceof Float) {
            a = new float[varr.length];
            for (i = 0; i < a.length; ++i) {
                a[i] = ((Float)varr[i]).floatValue();
            }
            arr = Array.factory(DataType.FLOAT, shape, (Object)a);
        }
        if (varr[0] instanceof Integer) {
            a = new int[varr.length];
            for (i = 0; i < a.length; ++i) {
                a[i] = ((Integer)varr[i]).intValue();
            }
            arr = Array.factory(DataType.INT, shape, (Object)a);
        }
        if (varr[0] instanceof Double) {
            a = new double[varr.length];
            for (i = 0; i < a.length; ++i) {
                a[i] = (float)((Double)varr[i]).doubleValue();
            }
            arr = Array.factory(DataType.DOUBLE, shape, (Object)a);
        }
        if (varr[0] instanceof Byte) {
            a = new byte[varr.length];
            for (i = 0; i < a.length; ++i) {
                a[i] = ((Byte)varr[i]).byteValue();
            }
            arr = Array.factory(DataType.BYTE, shape, (Object)a);
        }
        if (varr[0] instanceof Long) {
            a = new long[varr.length];
            for (i = 0; i < a.length; ++i) {
                a[i] = ((Long)varr[i]).longValue();
            }
            arr = Array.factory(DataType.LONG, shape, (Object)a);
        }
        return arr;
    }
}

