/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.Range2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;

public class PropGrid
extends Rectangle2D.Float
implements Serializable {
    private int rgb = -1;
    private double[] longitudes = null;
    private double[] latitudes = null;
    private int fHashCode = 0;
    private transient AffineTransform at;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private int xstride = 1;
    private int ystride = 1;

    public PropGrid() {
    }

    public PropGrid(double[] lon, double[] lat) {
        this.longitudes = (double[])lon.clone();
        this.latitudes = (double[])lat.clone();
        if (this.longitudes[0] < 0.0) {
            int i = 0;
            while (i < this.longitudes.length) {
                int n = i++;
                this.longitudes[n] = this.longitudes[n] + 360.0;
            }
        }
        this.xmin = 0;
        this.xmax = this.longitudes.length - 1;
        this.ymin = 0;
        this.ymax = this.latitudes.length - 1;
        this.transformPoints();
    }

    public PropGrid(double minLon, double maxLon, double minLat, double maxLat, int numLon, int numLat) {
        this.longitudes = new double[numLon];
        this.latitudes = new double[numLat];
        if (minLon < 0.0) {
            minLon += 360.0;
            maxLon += 360.0;
        }
        double lonstep = (maxLon - minLon) / (double)numLon;
        for (int i = 0; i < numLon; ++i) {
            this.longitudes[i] = (double)i * lonstep + minLon;
        }
        double latstep = (maxLat - minLat) / (double)numLat;
        for (int i = 0; i < numLat; ++i) {
            this.latitudes[i] = (double)i * latstep + minLat;
        }
        this.xmin = 0;
        this.xmax = this.longitudes.length - 1;
        this.ymin = 0;
        this.ymax = this.latitudes.length - 1;
        this.transformPoints();
    }

    public double[] getLongitudes() {
        return this.longitudes;
    }

    public double[] getLatitudes() {
        return this.latitudes;
    }

    public double getMinLon() {
        return this.longitudes != null ? this.longitudes[this.xmin] : Double.MIN_VALUE;
    }

    public double getMaxLon() {
        return this.longitudes != null ? this.longitudes[this.xmax] : Double.MAX_VALUE;
    }

    public double getMinLat() {
        return this.latitudes != null ? this.latitudes[this.ymin] : Double.MIN_VALUE;
    }

    public double getMaxLat() {
        return this.latitudes != null ? this.latitudes[this.ymax] : Double.MAX_VALUE;
    }

    public void setMinLon(double v) {
        this.xmin = this.findClosest(v, this.longitudes);
        this.transformPoints();
    }

    public void setMaxLon(double v) {
        this.xmax = this.findClosest(v, this.longitudes);
        this.transformPoints();
    }

    public void setMinLat(double v) {
        this.ymin = this.findClosest(v, this.latitudes);
        this.transformPoints();
    }

    public void setMaxLat(double v) {
        this.ymax = this.findClosest(v, this.latitudes);
        this.transformPoints();
    }

    public int getXstride() {
        return this.xstride;
    }

    public void setXstride(int xstride) {
        if (xstride > 0) {
            this.xstride = xstride;
        }
    }

    public int getYstride() {
        return this.ystride;
    }

    public void setYstride(int ystride) {
        if (ystride > 0) {
            this.ystride = ystride;
        }
    }

    public int getXSize() {
        return (this.xmax - this.xmin) / this.xstride;
    }

    public int getYSize() {
        return (this.ymax - this.ymin) / this.ystride;
    }

    public Range2D getRange() {
        double lon = this.getMinLon();
        double lat = this.getMinLat();
        return new Range2D(lon, lat, this.getMaxLon() - lon, this.getMaxLat() - lat);
    }

    private int findClosest(double v, double[] arr) {
        int idx = 0;
        double d = Double.MAX_VALUE;
        if (arr == null) {
            return 0;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!(Math.abs(v - arr[i]) < d)) continue;
            d = Math.abs(v - arr[i]);
            idx = i;
        }
        return idx;
    }

    public void setTransform(AffineTransform at) {
        this.at = at;
        this.transformPoints();
    }

    private void transformPoints() {
        if (this.at != null) {
            float[] pt = new float[2];
            this.at.transform(new double[]{this.getMinLon(), this.getMaxLat()}, 0, pt, 0, 1);
            this.x = pt[0];
            this.y = pt[1];
            this.at.transform(new double[]{this.getMaxLon(), this.getMinLat()}, 0, pt, 0, 1);
            this.width = pt[0] - this.x;
            this.height = pt[1] - this.y;
        }
    }

    public void setRGB(int c) {
        this.rgb = c;
    }

    public int getRGB() {
        return this.rgb;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof PropGrid)) {
            return false;
        }
        PropGrid thatPropGrid = (PropGrid)that;
        return Arrays.equals(this.getLatitudes(), thatPropGrid.getLatitudes()) && Arrays.equals(this.getLongitudes(), thatPropGrid.getLongitudes());
    }

    @Override
    public int hashCode() {
        if (this.fHashCode == 0) {
            int result = 23;
            result += this.getLatitudes().length;
            result += this.getLongitudes().length;
            result = (int)((long)result + Double.doubleToLongBits(this.getMinLat()));
            result = (int)((long)result + Double.doubleToLongBits(this.getMaxLat()));
            result = (int)((long)result + Double.doubleToLongBits(this.getMinLon()));
            this.fHashCode = result = (int)((long)result + Double.doubleToLongBits(this.getMaxLon()));
        }
        return this.fHashCode;
    }

    @Override
    public String toString() {
        return "numLat = " + this.getLatitudes().length + " numLon = " + this.getLongitudes().length + " minLat= " + this.getMinLat() + " maxLat = " + this.getMaxLat() + " minLon = " + this.getMinLon() + " getMaxLon() = " + this.getMaxLon();
    }
}

