/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.dart.TimeseriesDatum;
import gov.noaa.tsunami.websift.propdb.CompressedPropFileReader;
import gov.noaa.tsunami.websift.propdb.CompressedPropFileWriter;
import gov.noaa.tsunami.websift.propdb.PropFileReaderBase;
import gov.noaa.tsunami.websift.propdb.PropFileWriterBase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.Range2D;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UncompressedPropFileWriter;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;

public class PropagationLinearCombination {
    private File cacheDir;
    private File outputDir;
    private String applicationName = null;
    private boolean requireExactExtent = true;
    private static final Map<String, List<File>> lincoCache = new HashMap<String, List<File>>();
    private static Logger propdbLogger = PropagationDatabase.propdbLogger;
    private static final Map<PropagationDatabase.ModelVariable, String> modelVariableFilename = new HashMap<PropagationDatabase.ModelVariable, String>(){
        {
            this.put(PropagationDatabase.ModelVariable.HA, "ha");
            this.put(PropagationDatabase.ModelVariable.UA, "ua");
            this.put(PropagationDatabase.ModelVariable.VA, "va");
        }
    };
    private static final Set<String> doNotCopyAttrs = new HashSet<String>(Arrays.asList("quantization", "most_output_conventions", "number_of_fault_planes", "history", "rectangle_corner_longitudes", "rectangle_corner_latitudes", "rectangle_corner_depths", "rectangle_lower_edge_center_longitude", "rectangle_lower_edge_center_latitude", "rectangle_lower_edge_center_depth", "rectangle_upper_edge_center_longitude", "rectangle_upper_edge_center_latitude", "rectangle_upper_edge_center_depth", "rectangle_center_longitude", "rectangle_center_latitude", "rectangle_center_depth"));
    private static final Set<String> doNotIncludeDuplicates = new HashSet<String>(Arrays.asList("conventions", "title", "institution", "comments", "references", "most_propagation_version", "grid_name", "grid_axes_version", "grid_filename"));

    public PropagationLinearCombination() {
        this.setOutputDir(null);
    }

    public void setLogger(Logger l) {
        propdbLogger = l;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        if (cacheDir == null) {
            lincoCache.clear();
        } else if (!cacheDir.equals(this.cacheDir)) {
            this.cacheDir = cacheDir;
            this.initLinearCombinationCache();
        }
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(File outputDir) {
        this.outputDir = outputDir != null ? outputDir : new File(System.getProperty("java.io.tmpdir"));
    }

    public void setCallingApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List<TimeseriesDatum> getModelTimeseries(UnitSource source, double lat, double lon) throws PropagationDatabaseException {
        SourceCombo sc = new SourceCombo();
        sc.addSource(source);
        return this.getModelTimeseries(sc, lat, lon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimeseriesDatum> getModelTimeseries(SourceCombo sources, double lat, double lon) throws PropagationDatabaseException {
        ArrayList<TimeseriesDatum> data = new ArrayList<TimeseriesDatum>(1801);
        Range2D range = new Range2D(lon, lat, 0.0, 0.0);
        propdbLogger.entering("PropagationLinearCombination", "getModelTimeseries", sources.toString());
        for (UnitSource us : sources.getSources()) {
            String usf = us.getCompressedFileName();
            double alpha = us.getAlpha();
            if (usf == null) {
                throw new PropagationDatabaseException("A compressed source file is required for source " + us.getName());
            }
            try (CompressedPropFileReader propf = new CompressedPropFileReader(new File(usf), PropagationDatabase.ModelVariable.HA, range);){
                float[] heights;
                try {
                    heights = propf.getTimeseries(0, 0);
                }
                catch (IOException ex) {
                    throw new PropagationDatabaseException("Failed to load source " + us.getName(), ex);
                }
                if (data.isEmpty()) {
                    double[] times = propf.getTimeCoordinates();
                    for (int i = 0; i < times.length; ++i) {
                        data.add(new TimeseriesDatum(times[i] / 3600.0, (double)heights[i] * alpha));
                    }
                    continue;
                }
                for (int i = 0; i < Math.min(data.size(), heights.length); ++i) {
                    TimeseriesDatum tsd = (TimeseriesDatum)data.get(i);
                    tsd.setHeight(tsd.getHeight() + (double)heights[i] * alpha);
                }
            }
        }
        return data;
    }

    public File getCompressedLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable var, Range2D range) throws PropagationDatabaseException {
        return this.getCompressedLinearCombination(sources, var, range, true);
    }

    public File getCompressedLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable var, Range2D range, boolean requireExactExtent) throws PropagationDatabaseException {
        return this.makeCompressedLinearCombination(sources, var, range, true, requireExactExtent);
    }

    private File makeCompressedLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable var, Range2D range, boolean outputTimeseries, boolean requireExactExtent) throws PropagationDatabaseException {
        propdbLogger.entering("PropagationLinearCombination", "makeCompressedLinearCombination");
        if (sources.getNumberOfSources() <= 0) {
            throw new PropagationDatabaseException("The provided SourceCombo does not contain any valid sources");
        }
        File cacheResult = this.getCachedLinearCombination(sources, var, range, outputTimeseries, requireExactExtent);
        if (cacheResult != null) {
            propdbLogger.info(String.format("Valid cached linear combination for %s found at %s", sources.getSourceNames(), cacheResult.toString()));
            return cacheResult;
        }
        boolean allCompressed = true;
        for (UnitSource us : sources.getSources()) {
            if (us.hasCompressed()) continue;
            allCompressed = false;
            propdbLogger.warning("Source " + us.getName() + " has no compressed form");
        }
        if (allCompressed) {
            try {
                File f = this.getCompressedLinCoFromCompressed(sources, var, range, outputTimeseries);
                if (this.getCacheDir() != null) {
                    this.addCachedLinearCombination(f);
                }
                return f;
            }
            catch (InvalidRangeException ex) {
                Logger.getLogger(PropagationLinearCombination.class.getName()).log(Level.SEVERE, null, ex);
                throw new PropagationDatabaseException(ex);
            }
            catch (IOException ex) {
                throw new PropagationDatabaseException(ex);
            }
        }
        throw new UnsupportedOperationException("Compressed linear combination from uncompressed unit sources is not currently supported");
    }

    public File getUnCompressedLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable, Range2D range) throws PropagationDatabaseException {
        File compressedFile = this.getCompressedLinearCombination(sources, modelVariable, range);
        File outFile = this.getNewResultFilename(sources, modelVariable, null);
        propdbLogger.fine("generating uncompressed file from compressed file " + compressedFile.getPath() + " timestamp: " + DateFormat.getDateInstance(2).format(new Date(compressedFile.lastModified())));
        CompressedPropFileReader reader = new CompressedPropFileReader(compressedFile, modelVariable, range);
        UncompressedPropFileWriter writer = new UncompressedPropFileWriter(outFile, modelVariable);
        try {
            writer.setDimensions(reader);
            PropagationLinearCombination.transferGlobalAttributes(Collections.singletonList(reader), writer);
            writer.create();
            for (int jj = 0; jj < reader.getLatitudeSize(); ++jj) {
                for (int ii = 0; ii < reader.getLongitudeSize(); ++ii) {
                    writer.writeTimeseries(ii, jj, reader.getTimeseries(ii, jj));
                }
                if (!Thread.interrupted()) continue;
                throw new PropagationDatabaseException("Linear combination thread interrupted");
            }
        }
        catch (IOException ex) {
            throw new PropagationDatabaseException(ex);
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException iOException) {}
        }
        propdbLogger.info("created uncompressed file " + outFile.getPath());
        return outFile;
    }

    public File getSummaryLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable, Range2D range) throws PropagationDatabaseException {
        return this.getSummaryLinearCombination(sources, modelVariable, range, true);
    }

    public File getSummaryLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable, Range2D range, boolean requireExactExtent) throws PropagationDatabaseException {
        return this.makeCompressedLinearCombination(sources, modelVariable, range, false, requireExactExtent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getCachedLinearCombination(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable, Range2D range, boolean isTimeseriesRequired, boolean requireExactExtent) {
        if (this.getCacheDir() == null) {
            return null;
        }
        String cacheSig = this.getCacheSignature(sources, modelVariable);
        List<File> filematches = lincoCache.get(cacheSig);
        if (filematches == null || filematches.isEmpty()) {
            return null;
        }
        Range2D trimRange = range;
        try {
            PropFileReaderBase sampleGrd = new PropFileReaderBase(new File(sources.getSources().get(0).getCompressedFileName()), modelVariable, range);
            trimRange = sampleGrd.getLatitudeLongitudeRange();
            sampleGrd.close();
        }
        catch (PropagationDatabaseException ignore) {
            propdbLogger.log(Level.WARNING, "Error loading propagation file for reading grid extent");
            return null;
        }
        File matchingSourceFile = null;
        for (File pf : filematches) {
            PropFileReaderBase pfr = null;
            try {
                pfr = new PropFileReaderBase(pf);
                if (pfr.getModelVariable() != modelVariable || isTimeseriesRequired && !pfr.containsTimeseries()) continue;
                Range2D candidateRange = pfr.getLatitudeLongitudeRange();
                if (candidateRange.equals(trimRange)) {
                    File file = pf;
                    return file;
                }
                if (!candidateRange.completelyContains(trimRange)) continue;
                if (requireExactExtent) {
                    matchingSourceFile = pf;
                    continue;
                }
                File file = pf;
                return file;
            }
            catch (PropagationDatabaseException ex) {
                propdbLogger.log(Level.WARNING, "Error reading cached linear combination " + pf.getName(), ex);
            }
            finally {
                if (pfr == null) continue;
                pfr.close();
            }
        }
        if (matchingSourceFile == null) {
            return null;
        }
        File subsetFile = this.getNewResultFilename(sources, modelVariable, null);
        CompressedPropFileWriter subsetWriter = null;
        PropFileReaderBase cacheReader = null;
        try {
            subsetWriter = new CompressedPropFileWriter(subsetFile, modelVariable);
            cacheReader = new CompressedPropFileReader(matchingSourceFile, modelVariable, range);
            subsetWriter.setOutputTimeseriesVariable(isTimeseriesRequired);
            subsetWriter.setDimensions(cacheReader);
            for (Attribute attr : cacheReader.getGlobalAttributes()) {
                subsetWriter.addGlobalAttribute(attr);
            }
            subsetWriter.addHistoryEntry("Subset of cached linear combination " + matchingSourceFile.getName());
            subsetWriter.create();
            if (isTimeseriesRequired) {
                for (int jj = 0; jj < cacheReader.getLatitudeSize(); ++jj) {
                    for (int ii = 0; ii < cacheReader.getLongitudeSize(); ++ii) {
                        byte[] cmpTs = ((CompressedPropFileReader)cacheReader).getCompressedTimeseries(ii, jj);
                        subsetWriter.writeCompressedTimeseries(ii, jj, ((CompressedPropFileReader)cacheReader).getTimeseriesOffsetAt(ii, jj), cmpTs);
                    }
                }
            }
            subsetWriter.setMaxValueArray(((CompressedPropFileReader)cacheReader).getMaxValueArray());
            subsetWriter.setTravelTimeArray(((CompressedPropFileReader)cacheReader).getTravelTimeArray());
        }
        catch (Exception ex) {
            propdbLogger.log(Level.WARNING, "Error extracting subset of cached linear combination from " + matchingSourceFile, ex);
            File file = null;
            return file;
        }
        finally {
            if (subsetWriter != null) {
                try {
                    subsetWriter.close();
                }
                catch (IOException ex) {
                    propdbLogger.log(Level.WARNING, null, ex);
                }
            }
            if (cacheReader != null) {
                cacheReader.close();
            }
        }
        return subsetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getCompressedLinCoFromCompressed(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable, Range2D range, boolean outputTimeseriesVariable) throws IOException, InvalidRangeException, PropagationDatabaseException {
        ArrayList<CompressedPropFileReader> inFiles;
        File outFile;
        block17: {
            propdbLogger.info("Creating compressed linear combination from compressed sources for " + sources.getSourceNames());
            outFile = null;
            CompressedPropFileWriter outPropFile = null;
            inFiles = new ArrayList<CompressedPropFileReader>();
            int sourceCount = sources.getNumberOfSources();
            String[] sourceFilenames = new String[sourceCount];
            float[] alphas = new float[sourceCount];
            int isize = 0;
            int jsize = 0;
            int timesize = 0;
            try {
                for (int i = 0; i < sources.getNumberOfSources(); ++i) {
                    UnitSource us = sources.getSources().get(i);
                    alphas[i] = (float)us.getAlpha();
                    sourceFilenames[i] = us.getCompressedFileName();
                    if (sourceFilenames[i] == null) {
                        throw new PropagationDatabaseException("A compressed source file is required for source " + us.getName());
                    }
                    CompressedPropFileReader reader = new CompressedPropFileReader(new File(sourceFilenames[i]), modelVariable, range);
                    inFiles.add(reader);
                    if (isize == 0) {
                        isize = reader.getLongitudeSize();
                        jsize = reader.getLatitudeSize();
                    } else if (isize != reader.getLongitudeSize() || jsize != reader.getLatitudeSize()) {
                        throw new PropagationDatabaseException("Input source files do not have matching number of nodes over requested range");
                    }
                    timesize = Math.max(timesize, reader.getTimeSize());
                }
                assert (inFiles.size() > 0);
                outFile = this.getNewResultFilename(sources, modelVariable, this.getCacheDir());
                propdbLogger.fine("creating new result file: " + outFile.getPath());
                outPropFile = new CompressedPropFileWriter(outFile, modelVariable);
                outPropFile.setOutputTimeseriesVariable(outputTimeseriesVariable);
                outPropFile.setDimensions((PropFileReaderBase)inFiles.get(0));
                PropagationLinearCombination.transferGlobalAttributes(inFiles, outPropFile);
                outPropFile.addHistoryEntry("Linear combination created" + (this.applicationName != null ? " by " + this.applicationName : ""));
                outPropFile.addGlobalAttribute("Source_Combination", sources.getSourceNames());
                outPropFile.addGlobalAttribute("Source_Filenames", sourceFilenames);
                outPropFile.addGlobalAttribute("Number_Of_Fault_Planes", sources.getNumberOfSources());
                outPropFile.create();
                int sourcecount = sources.getNumberOfSources();
                float alphasum = 0.0f;
                for (int isource = 0; isource < sourcecount; ++isource) {
                    CompressedPropFileReader inf = inFiles.get(isource);
                    outPropFile.addDeformation(inf.getDeformation(), alphas[isource]);
                    alphasum += Math.abs(alphas[isource]);
                }
                float Tquant = 2.0f * outPropFile.getQuantization() * alphasum;
                outPropFile.setTquant(Tquant);
                for (int jj = 0; jj < jsize; ++jj) {
                    for (int ii = 0; ii < isize; ++ii) {
                        float[] lincoResult = new float[timesize];
                        boolean tsFound = false;
                        for (int isource = 0; isource < sourcecount; ++isource) {
                            CompressedPropFileReader inf = inFiles.get(isource);
                            float[] srcResult = inf.getZeroRemovedTimeseries(ii, jj);
                            if (srcResult == null) continue;
                            int startidx = inf.getTimeseriesOffsetAt(ii, jj);
                            for (int tt2 = 0; tt2 < srcResult.length; ++tt2) {
                                int n = startidx + tt2;
                                lincoResult[n] = lincoResult[n] + alphas[isource] * srcResult[tt2];
                            }
                            tsFound = true;
                        }
                        if (tsFound) {
                            outPropFile.writeTimeseries(ii, jj, lincoResult);
                        }
                        if (!Thread.interrupted()) continue;
                        throw new PropagationDatabaseException("Linear combination thread interrupted");
                    }
                }
                propdbLogger.log(Level.INFO, "Done creating linear combination file: {0}", outFile.getPath());
                if (outPropFile == null) break block17;
            }
            catch (Throwable throwable) {
                if (outPropFile != null) {
                    outPropFile.close();
                }
                for (CompressedPropFileReader cpfr : inFiles) {
                    cpfr.close();
                }
                throw throwable;
            }
            outPropFile.close();
        }
        for (CompressedPropFileReader cpfr : inFiles) {
            cpfr.close();
        }
        return outFile;
    }

    public static void trimToTimeRange(List<TimeseriesDatum> data, double startHour, double endHour) {
        Iterator<TimeseriesDatum> iter = data.iterator();
        while (iter.hasNext()) {
            double time = iter.next().getHrsFromEvent();
            if (!(time < startHour) && !(time > endHour)) continue;
            iter.remove();
        }
    }

    private static void addAttributeValueToList(Collection<Object> vList, Attribute a) {
        if (a.isArray()) {
            if (a.getDataType() == DataType.BOOLEAN || a.getDataType() == DataType.STRING) {
                propdbLogger.warning("Non-numeric array attribute " + a.getName() + " dropped; not supported by current version of NetCDF-Java library");
            } else {
                for (int i = 0; i < a.getLength(); ++i) {
                    vList.add(a.getNumericValue(i));
                }
            }
        } else if (a.isString()) {
            vList.add(a.getStringValue());
        } else {
            Number anum = a.getNumericValue();
            if (anum instanceof Float) {
                anum = new Double(anum.doubleValue());
            }
            vList.add(anum);
        }
    }

    private static void transferGlobalAttributes(List<CompressedPropFileReader> inReaders, PropFileWriterBase outWriter) {
        LinkedHashMap<String, LinkedHashSet<Object>> copyAttrs = new LinkedHashMap<String, LinkedHashSet<Object>>();
        for (CompressedPropFileReader reader : inReaders) {
            List<Attribute> attrs = reader.getGlobalAttributes();
            for (Attribute a : attrs) {
                String attrName = a.getName();
                if (doNotCopyAttrs.contains(attrName.toLowerCase())) continue;
                AbstractCollection vList = (LinkedHashSet)copyAttrs.get(attrName);
                if (vList == null) {
                    vList = doNotIncludeDuplicates.contains(attrName.toLowerCase()) ? new LinkedHashSet() : new ArrayList();
                    PropagationLinearCombination.addAttributeValueToList(vList, a);
                    copyAttrs.put(attrName, (LinkedHashSet<Object>)vList);
                    continue;
                }
                PropagationLinearCombination.addAttributeValueToList(vList, a);
            }
        }
        for (String attrName : copyAttrs.keySet()) {
            Collection vList = (Collection)copyAttrs.get(attrName);
            if (vList == null || vList.isEmpty()) continue;
            if (vList.size() == 1) {
                outWriter.addGlobalAttribute(attrName, vList.iterator().next());
                continue;
            }
            outWriter.addGlobalAttribute(attrName, vList.toArray());
        }
    }

    private static String getFilenameBase(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable) {
        try {
            UnitSource us = sources.getSources().firstElement();
            return String.format("%s_%1.1f_%s__", us.getZone(), sources.getMomentMagnitude(), modelVariableFilename.get((Object)modelVariable));
        }
        catch (NoSuchElementException ex) {
            return "SOURCE";
        }
    }

    private File getNewResultFilename(SourceCombo sources, PropagationDatabase.ModelVariable modelVariable, File outDir) {
        File resultf;
        String filenameBase = PropagationLinearCombination.getFilenameBase(sources, modelVariable);
        File dir = outDir != null ? outDir : this.getOutputDir();
        int i = 1;
        do {
            resultf = new File(dir, String.format("%s%d.nc", filenameBase, i));
            ++i;
        } while (resultf.exists());
        return resultf;
    }

    private String getCacheSignature(File ncf) throws PropagationDatabaseException {
        try (PropFileReaderBase pf = null;){
            pf = new PropFileReaderBase(ncf);
            List<Attribute> attrs = pf.getGlobalAttributes();
            for (Attribute a : attrs) {
                if (!"Source_Combination".equals(a.getName())) continue;
                String string = pf.getModelVariable().toString() + ": " + a.getStringValue().trim();
                return string;
            }
            throw new PropagationDatabaseException("Source_Combination attribute not found");
        }
    }

    private String getCacheSignature(SourceCombo sources, PropagationDatabase.ModelVariable mv) {
        return mv.toString() + ": " + sources.getSourceNames().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedLinearCombination(File f) {
        try {
            String sig = this.getCacheSignature(f);
            Map<String, List<File>> map = lincoCache;
            synchronized (map) {
                if (lincoCache.containsKey(sig)) {
                    lincoCache.get(sig).add(f);
                } else {
                    ArrayList<File> flist = new ArrayList<File>();
                    flist.add(f);
                    lincoCache.put(sig, flist);
                }
            }
        }
        catch (PropagationDatabaseException e) {
            propdbLogger.warning(String.format("Error adding %s to linco cache: %s", f.getName(), e));
        }
    }

    private void initLinearCombinationCache() {
        String[] filematches;
        if (this.getCacheDir() == null || !this.getCacheDir().isDirectory()) {
            return;
        }
        for (String s : filematches = this.getCacheDir().list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".nc");
            }
        })) {
            this.addCachedLinearCombination(new File(this.getCacheDir(), s));
        }
    }
}

