/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SourceCombo
implements Serializable {
    private Vector<UnitSource> sourceVector = new Vector();
    private static DecimalFormat dfxx = new DecimalFormat("0.00");
    private double totalMo = 0.0;

    public SourceCombo() {
    }

    public SourceCombo(List<UnitSource> sources) {
        this();
        for (UnitSource src : sources) {
            this.addSource(src);
        }
    }

    public SourceCombo(String sourceComboString, PropagationDatabase propdb) throws PropagationDatabaseException {
        this();
        if (sourceComboString == null) {
            return;
        }
        String[] sa = sourceComboString.split("(?<!\\*)\\+|(?<!\\*)(?=-)");
        for (int i = 0; i < sa.length; ++i) {
            if (sa[i].trim().equals("")) continue;
            String[] slipAndSource = sa[i].split("\\*");
            if (slipAndSource.length == 2) {
                String usStr;
                String slipStr;
                if (slipAndSource[0].matches("\\s*^[-+]?[0-9.]+\\s*")) {
                    slipStr = slipAndSource[0].trim();
                    usStr = slipAndSource[1].trim();
                } else if (slipAndSource[1].matches("\\s*^[-+]?[0-9.]+\\s*")) {
                    slipStr = slipAndSource[1].trim();
                    usStr = slipAndSource[0].trim();
                } else {
                    throw new PropagationDatabaseException("Can't parse source combination part " + sa[i]);
                }
                UnitSource us = propdb.getUnitSource(UnitSource.getStandardName(usStr));
                if (us != null) {
                    us.setAlpha(Double.parseDouble(slipStr));
                    this.addSource(us);
                    continue;
                }
                throw new PropagationDatabaseException("unit source " + usStr + " not in propagation database");
            }
            throw new PropagationDatabaseException("Can't parse source combination " + sa[i]);
        }
    }

    public SourceCombo(SourceCombo sc, PropagationDatabase propdb) throws PropagationDatabaseException {
        this();
        for (UnitSource us : sc.getSources()) {
            UnitSource localSrc = propdb.getUnitSource(us.getName());
            if (localSrc == null) {
                throw new PropagationDatabaseException("unit source " + us.getName() + " not in local propagation database");
            }
            localSrc.setAlpha(us.getAlpha());
            this.addSource(localSrc);
        }
    }

    public int getNumberOfSources() {
        return this.sourceVector.size();
    }

    public String getSourceNames() {
        if (this.sourceVector.size() == 0) {
            return "";
        }
        Collections.sort(this.sourceVector);
        String plus = "";
        StringBuilder names = new StringBuilder();
        for (UnitSource us : this.sourceVector) {
            if (us.getAlpha() < 0.0) {
                plus = "";
            }
            names.append(String.format("%s%.3f*%s", plus, us.getAlpha(), us.getName()));
            plus = "+";
        }
        return names.toString();
    }

    public String getSimpleName() {
        if (this.sourceVector.isEmpty()) {
            return "";
        }
        return SourceCombo.getSimpleName(this.getSourceNames());
    }

    public static String getSimpleName(String sourceNamesAndSlips) {
        StringBuilder sb = new StringBuilder();
        String[] sa = sourceNamesAndSlips.split("\\+");
        ArrayList<String> sourceNames = new ArrayList<String>();
        for (int i = 0; i < sa.length; ++i) {
            String us;
            double slip;
            String[] slipAndSource = sa[i].split("\\*");
            if (slipAndSource.length != 2) continue;
            try {
                slip = Double.parseDouble(slipAndSource[0].trim());
                us = UnitSource.getStandardName(slipAndSource[1].trim());
            }
            catch (NumberFormatException nfe) {
                slip = Double.parseDouble(slipAndSource[1].trim());
                us = UnitSource.getStandardName(slipAndSource[0].trim());
            }
            sourceNames.add(us);
        }
        if (sourceNames.isEmpty()) {
            return "";
        }
        sb.append(((String)sourceNames.get(0)).substring(0, 2));
        int startColNum = 100000;
        int endColNum = 0;
        char startRowLetter = 'g';
        char endRowLetter = 'a';
        for (String aName : sourceNames) {
            String zone = aName.substring(0, 2);
            String nLetter = aName.substring(aName.length() - 1);
            int nNumber = 0;
            try {
                nNumber = Integer.parseInt(aName.replaceAll(zone, "").replaceAll(nLetter, ""));
            }
            catch (NumberFormatException e) {
                nNumber = 0;
            }
            startColNum = startColNum < nNumber ? startColNum : nNumber;
            endColNum = endColNum > nNumber ? endColNum : nNumber;
            startRowLetter = startRowLetter < nLetter.charAt(0) ? startRowLetter : nLetter.charAt(0);
            endRowLetter = endRowLetter > nLetter.charAt(0) ? endRowLetter : nLetter.charAt(0);
        }
        sb.append(startColNum);
        sb.append(startRowLetter);
        if (startColNum != endColNum || startRowLetter != endRowLetter) {
            sb.append("-");
            sb.append(endColNum);
            sb.append(endRowLetter);
        }
        return sb.toString();
    }

    public void addSource(UnitSource s) {
        this.sourceVector.add(s);
        this.sourcesChanged();
    }

    public void removeSource(UnitSource s) {
        this.sourceVector.remove(s);
        this.sourcesChanged();
    }

    public Vector<UnitSource> getSources() {
        return this.sourceVector;
    }

    public UnitSource getSource(String name) {
        name = UnitSource.getStandardName(name);
        for (UnitSource us : this.sourceVector) {
            if (!us.getName().equals(name)) continue;
            return us;
        }
        return null;
    }

    public UnitSource getClosestSource() {
        if (this.sourceVector.size() > 0) {
            return this.sourceVector.get(0);
        }
        return null;
    }

    public boolean containsSource(String name) {
        boolean result = false;
        for (UnitSource us : this.sourceVector) {
            if (!us.getName().equals(name)) continue;
            return true;
        }
        return result;
    }

    public void clearSources() {
        this.sourceVector.clear();
    }

    public double getMomentMagnitude() {
        if (this.totalMo == 0.0) {
            return 0.0;
        }
        return 0.6666666666666666 * (Math.log(this.totalMo) / Math.log(10.0)) - 10.7;
    }

    public void setMomentMagnitude(double Mw) {
        if (!this.sourceVector.isEmpty()) {
            double fracMo = Math.pow(10.0, 1.5 * (Mw + 10.7)) / (double)this.sourceVector.size();
            for (UnitSource us : this.sourceVector) {
                us.setSeismicMoment(fracMo);
            }
            this.sourcesChanged();
        }
    }

    public void setAlpha(double alpha) {
        for (UnitSource us : this.sourceVector) {
            us.setAlpha(alpha);
        }
        this.sourcesChanged();
    }

    public Point2D.Double getCentroid() {
        Point2D.Double pt = new Point2D.Double();
        for (UnitSource us : this.sourceVector) {
            pt.x += us.getLongitude();
            pt.y += us.getLatitude();
        }
        if (this.sourceVector.size() > 0) {
            pt.x /= (double)this.sourceVector.size();
            pt.y /= (double)this.sourceVector.size();
        }
        return pt;
    }

    public void sourcesChanged() {
        this.totalMo = 0.0;
        for (UnitSource us : this.sourceVector) {
            this.totalMo += us.getSeismicMoment();
        }
        for (UnitSource us : this.sourceVector) {
            us.setFraction(us.getSeismicMoment() / this.totalMo);
        }
    }

    public String toString() {
        return this.getSourceNames();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceCombo)) {
            return false;
        }
        SourceCombo osc = (SourceCombo)o;
        return this.getSourceNames().equals(osc.getSourceNames());
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.sourceVector != null ? this.sourceVector.hashCode() : 0);
        return hash;
    }
}

