/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.events.SeismicEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class SourceScenario
implements Serializable,
Comparable<SourceScenario> {
    private final SeismicEvent event;
    private final String id;
    private final String name;
    private final String sourceNamesAndSlips;
    private final Type type;
    private final String notes;
    private final String user;
    private final long timestamp;
    private final SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    private boolean published = false;
    private List<Date[]> publishHistory = new ArrayList<Date[]>();
    private boolean authoritative = false;
    private String authority = null;
    private Date authDate = null;

    public SourceScenario(String id, String name, SeismicEvent event, String sc, Type type, String user, String notes, long timestamp) {
        this.sourceNamesAndSlips = SourceScenario.parseSNAS(sc);
        this.id = id;
        this.name = name;
        this.event = event;
        this.type = type;
        this.user = user;
        this.notes = notes;
        this.timestamp = timestamp;
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public SourceScenario(String id, SeismicEvent event, String sc, Type type) {
        this(id, "", event, sc, type, "", "", 0L);
    }

    public static String parseSNAS(String sourceComboString) {
        StringBuilder sb = new StringBuilder();
        String plus = "";
        if (sourceComboString == null) {
            return "";
        }
        String[] sa = sourceComboString.split("(?<!\\*)\\+|(?<!\\*)(?=-)");
        for (int i = 0; i < sa.length; ++i) {
            String usStr;
            String slipStr;
            String[] slipAndSource;
            if (sa[i].trim().equals("") || (slipAndSource = sa[i].split("\\*")).length != 2) continue;
            if (slipAndSource[0].matches("\\s*^[-+]?[0-9.]+\\s*")) {
                slipStr = slipAndSource[0].trim();
                usStr = slipAndSource[1].trim();
            } else if (slipAndSource[1].matches("\\s*^[-+]?[0-9.]+\\s*")) {
                slipStr = slipAndSource[1].trim();
                usStr = slipAndSource[0].trim();
            } else {
                return "";
            }
            sb.append(String.format("%s%2.3f*%s", plus, Double.parseDouble(slipStr), usStr));
            plus = "+";
        }
        return sb.toString();
    }

    public SeismicEvent getSeismicEvent() {
        return this.event;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString() {
        return this.df.format(new Date(this.timestamp));
    }

    public String getSourceNamesAndSlips() {
        return this.sourceNamesAndSlips;
    }

    public Type getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public int compareTo(SourceScenario aSS) {
        int i = 0;
        int typeCmp = this.type.compareTo(aSS.getType());
        if (aSS.getTimestamp() > this.timestamp) {
            i = 1;
        } else if (aSS.getTimestamp() < this.timestamp) {
            i = -1;
        }
        return typeCmp != 0 ? typeCmp : i;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SourceScenario)) {
            return false;
        }
        return this.compareTo((SourceScenario)that) == 0;
    }

    public int hashCode() {
        int result = 851 + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 59 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name + " [" + (Object)((Object)this.type) + "]: " + this.sourceNamesAndSlips;
    }

    public void setPublished(Date publishDate) {
        if (publishDate != null && publishDate.before(new Date())) {
            this.published = true;
            this.addPublishRecord(publishDate, null);
        } else {
            this.published = false;
        }
    }

    public boolean isPublished() {
        return this.published;
    }

    public void addPublishRecord(Date published, Date revoked) {
        this.publishHistory.add(new Date[]{published, revoked});
    }

    public void setPublishHistory(List<Date[]> history) {
        this.publishHistory.clear();
        this.publishHistory.addAll(history);
    }

    public void setAuthoritative(boolean isAuthoritative) {
        this.authoritative = isAuthoritative;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthoritativeDate(Date setDate) {
        this.authDate = setDate;
    }

    public Date getAuthoritativeDate() {
        return this.authDate;
    }

    public static enum Type {
        DART,
        MANUAL,
        CONTRIB,
        SEISMIC,
        UNSPECIFIED,
        UNKNOWN;

    }
}

