/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.PropFileWriterBase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import java.io.File;
import java.io.IOException;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;

public class UncompressedPropFileWriter
extends PropFileWriterBase {
    private ArrayFloat.D3 outputArr;

    public UncompressedPropFileWriter(File outFile, PropagationDatabase.ModelVariable modelVariable) {
        super(outFile, modelVariable);
    }

    @Override
    public void setDimensions(double[] lon, double[] lat, double[] tim) {
        String mvarname = this.getModelVarName();
        Dimension timedim = this.outNcFile.addUnlimitedDimension("time");
        super.setDimensions(lon, lat, tim);
        this.outNcFile.addVariable("time", DataType.DOUBLE, new Dimension[]{timedim});
        this.addVariableAttributes("time", null, "seconds", null);
        Dimension[] tlldims = new Dimension[]{timedim, this.latlondims[0], this.latlondims[1]};
        this.outNcFile.addVariable(mvarname, DataType.FLOAT, tlldims);
        this.addVariableAttributes(mvarname, this.getVarLongName(), this.getVarUnits(), null);
        this.addMissingValueAttributes(mvarname, -1.0E34f);
        this.outputArr = new ArrayFloat.D3(tim.length, lat.length, lon.length);
    }

    @Override
    public void writeTimeseries(int ii, int jj, float[] timeseries) throws IOException {
        block4: {
            block3: {
                int t;
                if (timeseries == null) break block3;
                int tlen = Math.min(timeseries.length, this.time.length);
                for (t = 0; t < tlen; ++t) {
                    this.outputArr.set(t, jj, ii, timeseries[t]);
                }
                if (tlen >= this.time.length) break block4;
                for (t = tlen; t < this.time.length; ++t) {
                    this.outputArr.set(t, jj, ii, 0.0f);
                }
                break block4;
            }
            for (int t = 0; t < this.time.length; ++t) {
                this.outputArr.set(t, jj, ii, 0.0f);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.outNcFile.write(this.getModelVarName(), this.outputArr);
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex.getMessage());
        }
        super.close();
    }
}

