/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.propdb;

import gov.noaa.tsunami.websift.propdb.Point3D;
import gov.noaa.tsunami.websift.propdb.PropGrid;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.ArrayFloat;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public final class UnitSource
implements Shape,
Serializable,
Cloneable,
Comparable<UnitSource> {
    private String name;
    private String zone = "testzone";
    private String zoneCode = "ev";
    private String nameLetter = "a";
    private int nameNumber = -999;
    private static final Pattern pat = Pattern.compile("\\d+");
    private String fileName;
    private String croppedFileName = null;
    private String compressedFileName = null;
    private double longitude = 0.0;
    private double latitude = 0.0;
    private double distanceFromSource = 0.0;
    private double strike = 0.0;
    private double dip = 0.0;
    private double rake = 0.0;
    private double depth = 0.0;
    private double slip = 0.0;
    private static double u = 4.0E11;
    private static final double D2R = Math.PI / 180;
    private static final double KM2D = 111.195;
    private double alpha = 1.0;
    private String gridName = "19700101";
    private int gridVer = 0;
    private String gridFileName = "";
    private double depthCutoff = 20.0;
    private double timeStep = 0.0;
    private int numSteps = 0;
    private int stepSkip = 0;
    private int stepStart = 0;
    private int npics = 1;
    private int global = 0;
    private String outputPrefix = "auto";
    private int rgb = -1973791;
    private double fraction = 0.0;
    private boolean active = false;
    private boolean highlight = false;
    private boolean limitDip = false;
    private double length = 0.0;
    private double width = 0.0;
    private Point3D[] rect;
    private Rectangle bounds;
    public float[] points = new float[8];
    private boolean pointsTransformed = false;
    private boolean isSeismic = true;
    private static final Pattern[] namePatterns = new Pattern[]{Pattern.compile("([a-z]{2})(?:sz)?([0-9]+)([a-z])"), Pattern.compile("([a-z]{2})(?:sz)?([a-z])([0-9]+)"), Pattern.compile("([a-z]{2})_([0-9]+)([a-z])")};
    private static final int[][] namePatternIndexes = new int[][]{{1, 2, 3}, {1, 3, 2}, {1, 2, 3}};
    static final char sortOffset = '\u000e';

    public UnitSource(String fn) throws IOException {
        this.fileName = fn;
        File f = new File(fn);
        this.name = f.getName().replaceAll("ha.nc", "");
        this.name = this.name.replaceAll(".nc", "");
        this.slip = 1.0;
        NetcdfFile ncFile = NetcdfFile.open(fn);
        List<Variable> varList = ncFile.getVariables();
        Variable haVar = null;
        Variable latVar = null;
        Variable lonVar = null;
        for (Variable v : varList) {
            if (v.getName().toLowerCase().startsWith("ha") && v.getDimensions().size() == 3) {
                haVar = v;
            }
            if (v.getName().toLowerCase().startsWith("lat") && v.getDimensions().size() == 1) {
                latVar = v;
            }
            if (!v.getName().toLowerCase().startsWith("lon") || v.getDimensions().size() != 1) continue;
            lonVar = v;
        }
        if (haVar != null && latVar != null && lonVar != null) {
            int[] shape = haVar.getShape();
            int[] origin = new int[haVar.getRank()];
            shape[0] = 1;
            origin[0] = 0;
            int imax = 0;
            int jmax = 0;
            float hamax = -10000.0f;
            float holder = 0.0f;
            try {
                ArrayFloat.D2 ha = (ArrayFloat.D2)haVar.read(origin, shape).reduce();
                for (int i = 0; i < shape[2]; ++i) {
                    for (int j = 0; j < shape[1]; ++j) {
                        holder = ha.get(j, i);
                        if (!(holder > -1.0E34f) || !(Math.abs(ha.get(j, i)) > hamax)) continue;
                        hamax = Math.abs(ha.get(j, i));
                        imax = i;
                        jmax = j;
                    }
                }
            }
            catch (InvalidRangeException ex) {
                throw new IOException(ex.getMessage());
            }
            double[] xloc = (double[])lonVar.read().copyTo1DJavaArray();
            double[] yloc = (double[])latVar.read().copyTo1DJavaArray();
            this.longitude = xloc[imax] + 0.35932446999640677;
            this.latitude = yloc[jmax] + 0.35932446999640677;
            this.length = 8000000.0;
            this.width = 8000000.0;
            this.rect = this.createBoxOutline();
            this.isSeismic = false;
        }
    }

    public UnitSource(String sn, String fn, double lon, double lat, double st, double di, double de, double le, double wi, double ra) {
        this(sn, fn, lon, lat, 1.0, st, di, de, le, wi, ra);
    }

    public UnitSource(String sn, String fn, double lon, double lat, double sl, double st, double di, double de, double le, double wi, double ra) {
        this.name = sn;
        this.parseName();
        this.fileName = fn;
        this.longitude = lon;
        this.latitude = lat;
        this.strike = st;
        this.dip = di;
        this.depth = de;
        this.length = le * 100000.0;
        this.width = wi * 100000.0;
        this.slip = sl;
        this.rake = ra;
        this.rect = this.createBoxOutline();
    }

    public UnitSource(File netCDFFile) throws IOException {
        Attribute quantAtt;
        String netCDFFileName = netCDFFile.toString();
        NetcdfFile ncFile = NetcdfFile.open(netCDFFileName);
        Attribute att = ncFile.findGlobalAttribute("Source_Zone_Code");
        if (att == null) {
            ncFile.close();
            throw new IOException("old-version Propagation file: " + netCDFFile.toString());
        }
        this.zoneCode = att.getStringValue();
        att = ncFile.findGlobalAttribute("Source_Zone_Name");
        if (att != null) {
            this.zone = att.getStringValue();
        }
        String row = (att = ncFile.findGlobalAttribute("Source_Row")).isString() ? att.getStringValue() : att.getNumericValue().toString();
        String col = ncFile.findGlobalAttribute("Source_Column").getStringValue();
        this.name = this.zoneCode + col + row;
        this.parseName();
        att = ncFile.findGlobalAttribute("Rectangle_Lower_Edge_Center_Latitude");
        if (att == null) {
            ncFile.close();
            throw new IOException("custom deformation file");
        }
        this.latitude = att.getNumericValue(0).floatValue();
        this.longitude = ncFile.findGlobalAttribute("Rectangle_Lower_Edge_Center_Longitude").getNumericValue(0).floatValue();
        this.slip = this.slip = (double)ncFile.findGlobalAttribute("Slip").getNumericValue(0).floatValue();
        this.strike = ncFile.findGlobalAttribute("Strike").getNumericValue(0).floatValue();
        this.dip = ncFile.findGlobalAttribute("Dip").getNumericValue(0).floatValue();
        this.depth = ncFile.findGlobalAttribute("Depth").getNumericValue(0).floatValue();
        this.setLength(ncFile.findGlobalAttribute("Source_Length").getNumericValue(0).floatValue());
        this.setWidth(ncFile.findGlobalAttribute("Source_Width").getNumericValue(0).floatValue());
        this.setRake(ncFile.findGlobalAttribute("Rake").getNumericValue(0).floatValue());
        att = ncFile.findGlobalAttribute("Grid_Name");
        if (att != null) {
            this.gridName = att.getStringValue();
        }
        if ((att = ncFile.findGlobalAttribute("Grid_Axes_Version")) != null) {
            try {
                this.gridVer = Integer.parseInt(att.getStringValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((att = ncFile.findGlobalAttribute("Grid_Filename")) != null) {
            this.gridFileName = att.getStringValue();
        }
        if ((att = ncFile.findGlobalAttribute("Minimum_Offshore_Depth")) != null) {
            this.depthCutoff = att.getNumericValue().doubleValue();
        }
        if ((att = ncFile.findGlobalAttribute("Time_Step")) != null) {
            this.timeStep = att.getNumericValue().doubleValue();
        }
        if ((att = ncFile.findGlobalAttribute("Total_Steps")) != null) {
            this.numSteps = att.getNumericValue().intValue();
        }
        if ((att = ncFile.findGlobalAttribute("Steps_Between_Saves")) != null) {
            this.stepSkip = att.getNumericValue().intValue();
        }
        if ((att = ncFile.findGlobalAttribute("Start_Saving_At_Step")) != null) {
            this.stepStart = att.getNumericValue().intValue();
        }
        if ((att = ncFile.findGlobalAttribute("Output_Grid_Interval")) != null) {
            this.npics = att.getNumericValue().intValue();
        }
        if ((quantAtt = ncFile.findGlobalAttribute("Quantization")) != null) {
            this.setCompressedFileName(netCDFFileName);
        } else {
            this.setFileName(netCDFFileName);
        }
        ncFile.close();
        this.rect = this.createBoxOutline();
    }

    public void parseName() {
        try {
            if (this.name.startsWith("nc_")) {
                this.name = UnitSource.getStandardName(this.name);
                this.zone = "nc";
                this.nameLetter = this.name.substring(this.name.length() - 1);
                this.nameNumber = Integer.parseInt(this.name.replaceAll(this.zone, "").replaceAll(this.nameLetter, ""));
            } else {
                this.name = UnitSource.getStandardName(this.name);
                this.zone = this.name.substring(0, 2);
                this.nameLetter = this.name.substring(this.name.length() - 1);
                this.nameNumber = Integer.parseInt(this.name.replaceAll(this.zone, "").replaceAll(this.nameLetter, ""));
            }
        }
        catch (NumberFormatException e) {
            this.nameNumber = -999;
        }
    }

    public static String getStandardName(String name) {
        name = name.trim().toLowerCase();
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < namePatterns.length; ++i) {
            Matcher m = namePatterns[i].matcher(name);
            if (!m.matches()) continue;
            for (int gidx : namePatternIndexes[i]) {
                sb.append(m.group(gidx));
            }
            return sb.toString();
        }
        return name;
    }

    public void setName(String sn) {
        this.name = sn;
    }

    public String getName() {
        return this.name;
    }

    public void setZone(String zoneName) {
        this.zone = zoneName;
    }

    public String getZone() {
        return this.name.startsWith("nc") ? "nc" : this.zone;
    }

    public String getZoneCode() {
        return this.zoneCode;
    }

    public void setZoneCode(String zoneCode) {
        this.zoneCode = zoneCode;
    }

    public void setNameNumber(int n) {
        this.nameNumber = n;
    }

    public int getNameNumber() {
        return this.nameNumber;
    }

    public void setNameLetter(String column) {
        this.nameLetter = column;
    }

    public String getNameLetter() {
        return this.nameLetter;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public boolean isActive() {
        return this.active;
    }

    public Point3D[] getRect() {
        if (this.rect == null) {
            this.rect = this.createBoxOutline();
        }
        return this.rect;
    }

    public void setHighlight(boolean h) {
        this.highlight = h;
    }

    public boolean getHighlight() {
        return this.highlight;
    }

    public void setRGB(int c) {
        this.rgb = c;
    }

    public int getRGB() {
        return this.rgb;
    }

    public String getFileName() {
        return this.croppedFileName == null ? this.fileName : this.croppedFileName;
    }

    public String getOriginalFileName() {
        return this.fileName;
    }

    public void setFileName(String fn) {
        this.fileName = fn;
    }

    public boolean isCropped() {
        return this.croppedFileName != null;
    }

    public void setCroppedFileName(String fn) {
        this.croppedFileName = fn;
    }

    public void setCompressedFileName(String fn) {
        this.compressedFileName = fn;
    }

    public String getCompressedFileName() {
        return this.compressedFileName;
    }

    public boolean hasCompressed() {
        return this.compressedFileName != null;
    }

    public boolean hasCompressedAndUn() {
        return this.fileName != null && this.compressedFileName != null;
    }

    public boolean hasUncompressed() {
        return this.fileName != null;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double lon) {
        this.longitude = lon;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double lat) {
        this.latitude = lat;
    }

    public void setAlpha(double a) {
        this.alpha = a;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getSlip() {
        return this.slip;
    }

    public void setSlip(double sl) {
        this.slip = sl;
    }

    public double getMagnitude() {
        return 0.6666666666666666 * (Math.log(this.getSeismicMoment()) / Math.log(10.0)) - 10.7;
    }

    public void setMagnitude(double Mw) {
        double Mo = Math.pow(10.0, 1.5 * (Mw + 10.7));
        this.setSeismicMoment(Mo);
    }

    public void setSeismic(boolean b) {
        this.isSeismic = b;
    }

    public boolean isSeismic() {
        return this.isSeismic;
    }

    public void setSeismicMoment(double Mo) {
        if (this.isSeismic) {
            this.alpha = Mo / (u * this.length * this.width) * 0.01 / this.slip;
        }
    }

    public double getSeismicMoment() {
        if (this.isSeismic) {
            return Math.abs(this.alpha) * (Math.abs(this.slip) / 0.01) * (u * this.length * this.width);
        }
        return 0.0;
    }

    public void setFraction(double f) {
        if (this.isSeismic) {
            this.fraction = f;
        }
    }

    public double getFraction() {
        return this.fraction * 100.0;
    }

    public double getLength() {
        return this.length / 100000.0;
    }

    public void setLength(double length) {
        this.length = length * 100000.0;
    }

    public double getWidth() {
        return this.width / 100000.0;
    }

    public void setWidth(double width) {
        this.width = width * 100000.0;
    }

    public double getStrike() {
        return this.strike;
    }

    public void setStrike(double s) {
        this.strike = s;
    }

    public void setDip(double d) {
        this.dip = d;
    }

    public double getDip() {
        return this.dip;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getRake() {
        return this.rake;
    }

    public void setRake(double r) {
        this.rake = r;
    }

    public double getDistanceFromSource() {
        return this.distanceFromSource;
    }

    public void setDistanceFromSource(double di) {
        this.distanceFromSource = di;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public int getGridVer() {
        return this.gridVer;
    }

    public void setGridVer(int gridVer) {
        this.gridVer = gridVer;
    }

    public String getGridFileName() {
        return this.gridFileName;
    }

    public void setGridFileName(String gridFileName) {
        this.gridFileName = gridFileName;
    }

    public double getDepthCutoff() {
        return this.depthCutoff;
    }

    public void setDepthCutoff(double depthCutoff) {
        this.depthCutoff = depthCutoff;
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = numSteps;
    }

    public int getStepSkip() {
        return this.stepSkip;
    }

    public void setStepSkip(int stepSkip) {
        this.stepSkip = stepSkip;
    }

    public int getStepStart() {
        return this.stepStart;
    }

    public void setStepStart(int stepStart) {
        this.stepStart = stepStart;
    }

    public int getOutputGridInterval() {
        return this.npics;
    }

    public void setOutputGridInterval(int npics) {
        this.npics = npics;
    }

    public Point3D[] createBoxOutline() {
        Point3D[] newRect = new Point3D[4];
        double tempDip = this.dip;
        tempDip = this.limitDip && this.dip > 30.0 ? 30.0 : this.dip;
        double projWidth = this.getWidth() * Math.cos(tempDip * (Math.PI / 180));
        double dipDepth = this.getDepth() + this.getWidth() * Math.sin(this.dip * (Math.PI / 180));
        double halfLength = this.getLength() / 2.0;
        double angle = (270.0 - this.strike) * (Math.PI / 180);
        double[] Pt = this.rotatePoint(halfLength, 0.0, angle);
        Pt = this.kmToDegrees(Pt);
        newRect[0] = new Point3D(Pt[0], Pt[1], dipDepth);
        Pt = this.rotatePoint(halfLength, -projWidth, angle);
        Pt = this.kmToDegrees(Pt);
        newRect[3] = new Point3D(Pt[0], Pt[1], this.getDepth());
        Pt = this.rotatePoint(-halfLength, -projWidth, angle);
        Pt = this.kmToDegrees(Pt);
        newRect[2] = new Point3D(Pt[0], Pt[1], this.getDepth());
        Pt = this.rotatePoint(-halfLength, 0.0, angle);
        Pt = this.kmToDegrees(Pt);
        newRect[1] = new Point3D(Pt[0], Pt[1], dipDepth);
        for (int i = 0; i < 4; ++i) {
            this.points[i * 2] = (float)newRect[i].x;
            this.points[i * 2 + 1] = (float)newRect[i].y;
        }
        return newRect;
    }

    private double[] rotatePoint(double x, double y, double angle) {
        double[] Pt = new double[]{x * Math.cos(angle) - y * Math.sin(angle), x * Math.sin(angle) + y * Math.cos(angle)};
        return Pt;
    }

    private double[] kmToDegrees(double[] pt) {
        double[] pt2 = new double[]{this.longitude + pt[0] / (Math.cos(this.latitude * (Math.PI / 180)) * 111.195), this.latitude + pt[1] / 111.195};
        return pt2;
    }

    private static int rowOrder(String row) {
        char ch = row.charAt(0);
        int order = 0;
        order = ch <= 'm' ? 109 - ch + 1 : 122 - ch + 14;
        return order;
    }

    @Override
    public int compareTo(UnitSource us) {
        int zoneCompare = this.getZone().compareTo(us.getZone());
        if (zoneCompare == 0) {
            int numCompare = this.getNameNumber() - us.getNameNumber();
            if (numCompare == 0) {
                int rowCompare = UnitSource.rowOrder(this.getNameLetter()) - UnitSource.rowOrder(us.getNameLetter());
                return rowCompare;
            }
            return numCompare;
        }
        return zoneCompare;
    }

    public PropGrid getPropGrid() throws IOException {
        NetcdfFile nc = NetcdfFile.open(this.compressedFileName != null ? this.compressedFileName : this.fileName);
        Variable ncvar = UnitSource.findNetcdfVariable(nc, "lon");
        if (ncvar == null) {
            throw new IOException("Can't find variable 'lat' in netcdf file: " + this.fileName);
        }
        double[] lon = (double[])ncvar.read().copyTo1DJavaArray();
        ncvar = UnitSource.findNetcdfVariable(nc, "lat");
        if (ncvar == null) {
            throw new IOException("Can't find variable 'lat' in netcdf file: " + this.fileName);
        }
        double[] lat = (double[])ncvar.read().copyTo1DJavaArray();
        return new PropGrid(lon, lat);
    }

    private static Variable findNetcdfVariable(NetcdfFile nc, String varName) {
        Variable v = nc.findVariable(varName);
        if (v == null) {
            v = nc.findVariable(varName.toUpperCase());
        }
        if (v == null) {
            v = nc.findVariable(varName.toLowerCase());
        }
        return v;
    }

    public String getMostInput() {
        StringBuilder sb = new StringBuilder();
        sb.append("#\tGrid Nam\n");
        sb.append(String.format("%s\n", this.getGridName()));
        sb.append("#\tGrid Axes Version\n");
        sb.append(String.format("%s\n", this.getGridVer()));
        sb.append("#\tGrid Filename\n");
        sb.append(String.format("%s\n", this.getGridFileName()));
        sb.append("#\tComputational parameters\n");
        sb.append(String.format("%2.1f\t# Input minimum depth for offshore (m)\n", this.depthCutoff));
        sb.append(String.format("%2.1f\t# Input time step (sec)\n", this.timeStep));
        sb.append(String.format("%d\t# Input amount of steps\n", this.numSteps));
        sb.append(String.format("%d\t# Input number of steps between snapshots\n", this.stepSkip));
        sb.append(String.format("%d\t# ...Starting from timestep\n", this.stepStart));
        sb.append(String.format("%d\t# Save output every n-th grid point\n", this.npics));
        sb.append(String.format("%d\t# Input global b.c.s (1=global, 0=non-reentrant)\n", this.global));
        sb.append("#\tOutput filename (<prefix>_ha.nc, or \"auto\")\n");
        if (this.fileName == null) {
            sb.append("auto\n");
        } else {
            sb.append(String.format("%s\n", this.getFileName()));
        }
        sb.append("#\tSource naming info\n");
        sb.append("#\tSource Zone Name (no spaces)\n");
        sb.append(String.format("%s\n", this.getZone()));
        sb.append("#\tSource Zone Code (two characters)\n");
        sb.append(String.format("%s\n", this.getZoneCode()));
        sb.append("#\tSource Column (one character)\n");
        sb.append(String.format("%s\n", this.getNameLetter()));
        sb.append("#\tSource Row (integer/three character)\n");
        sb.append(String.format("%d\n", this.getNameNumber()));
        sb.append("#\tSource Version (integer/two characters)\n");
        sb.append("1\n");
        sb.append("#\tFault plane info\n");
        sb.append("1\t# Number of fault-planes('-' looks for deformation files to use)\n");
        sb.append("41\t# x-integration\n");
        sb.append("21\t# y-integration\n");
        sb.append("8.11\t# Vp - P-wave velocity\n");
        sb.append("4.49\t# Vs - S-wave velocity\n");
        sb.append(String.format("%2.6f\t# Longitude (deg)\n", this.getLongitude()));
        sb.append(String.format("%2.6f\t# Latitude (deg)\n", this.getLatitude()));
        sb.append(String.format("%2.2f\t# Length (km)\n", this.getLength()));
        sb.append(String.format("%2.2f\t# Width (km)\n", this.getWidth()));
        sb.append(String.format("%2.2f\t# DIP (deg)\n", this.getDip()));
        sb.append(String.format("%2.2f\t# RAKE (deg)\n", this.getRake()));
        sb.append(String.format("%2.2f\t# STRIKE (deg)\n", this.getStrike()));
        sb.append(String.format("%2.2f\t# SLIP (m)\n", this.getSlip()));
        sb.append(String.format("%2.2f\t# DEPTH (km)\n", this.getDepth()));
        return sb.toString();
    }

    public String getMostInput(String gridName, int gridVer, String gridFileName) {
        this.setGridName(gridName);
        this.setGridVer(gridVer);
        this.setGridFileName(gridFileName);
        return this.getMostInput();
    }

    public UnitSource copy() {
        UnitSource aSource = new UnitSource(this.getName(), this.getFileName(), this.getLongitude(), this.getLatitude(), this.getStrike(), this.getDip(), this.getDepth(), this.getLength(), this.getWidth(), this.getRake());
        aSource.setSlip(this.getSlip());
        aSource.alpha = this.getAlpha();
        aSource.setActive(this.isActive());
        aSource.setFraction(this.getFraction());
        if (this.croppedFileName != null) {
            aSource.setCroppedFileName(this.croppedFileName);
        }
        aSource.setCompressedFileName(this.compressedFileName);
        aSource.setDistanceFromSource(this.getDistanceFromSource());
        return aSource;
    }

    public String getInfo() {
        return this.getName() + ", lon: " + this.getLongitude() + " lat: " + this.getLatitude() + " depth: " + this.getDepth() + " lenth: " + this.getLength() + " width: " + this.getWidth() + " slip:" + this.getSlip() + " strike:" + this.getStrike() + " dip: " + this.getDip() + " rake:" + this.getRake();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnitSource)) {
            return false;
        }
        UnitSource ous = (UnitSource)o;
        return this.slip == ous.getSlip() && this.name.equals(ous.getName()) && this.latitude == ous.getLatitude() && this.longitude == ous.getLongitude() && this.alpha == ous.getAlpha() && this.getFileName().equals(ous.getFileName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.fileName != null ? this.fileName.hashCode() : 0);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.slip) ^ Double.doubleToLongBits(this.slip) >>> 32);
        return hash;
    }

    public void transformPoints(AffineTransform at) {
        if (this.pointsTransformed) {
            return;
        }
        at.transform(this.points, 0, this.points, 0, 4);
        float xMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMin = Float.MAX_VALUE;
        float yMax = Float.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            xMin = Math.min(xMin, this.points[i * 2]);
            xMax = Math.max(xMax, this.points[i * 2]);
            yMin = Math.min(yMin, this.points[i * 2 + 1]);
            yMax = Math.max(yMax, this.points[i * 2 + 1]);
        }
        this.bounds = new Rectangle((int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin));
        this.pointsTransformed = true;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public boolean crossPositive(float x_a, float y_a, float x_b, float y_b, double x_d, double y_d) {
        return (x_d - (double)x_a) * (double)(y_b - y_a) - (y_d - (double)y_a) * (double)(x_b - x_a) > 0.0;
    }

    public boolean contains2(double x, double y) {
        if (this.crossPositive(this.points[0], this.points[1], this.points[2], this.points[3], x, y)) {
            return false;
        }
        if (this.crossPositive(this.points[2], this.points[3], this.points[4], this.points[5], x, y)) {
            return false;
        }
        if (this.crossPositive(this.points[4], this.points[5], this.points[6], this.points[7], x, y)) {
            return false;
        }
        return !this.crossPositive(this.points[6], this.points[7], this.points[0], this.points[1], x, y);
    }

    @Override
    public boolean contains(double ptx, double pty) {
        int npts = 4;
        boolean inside = false;
        int i = 0;
        int j = npts - 1;
        while (i < npts) {
            if ((double)this.points[i * 2 + 1] > pty != (double)this.points[j * 2 + 1] > pty && ptx < (double)(this.points[j * 2] - this.points[i * 2]) * (pty - (double)this.points[i * 2 + 1]) / (double)(this.points[j * 2 + 1] - this.points[i * 2 + 1]) + (double)this.points[i * 2]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new UnitSourcePathIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class UnitSourcePathIterator
    implements PathIterator {
        UnitSource aSource;
        AffineTransform transform;
        int index;

        public UnitSourcePathIterator(UnitSource s, AffineTransform at) {
            this.aSource = s;
            this.transform = at;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > 4;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= 4) {
                return 4;
            }
            coords[0] = this.aSource.points[this.index * 2];
            coords[1] = this.aSource.points[this.index * 2 + 1];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= 4) {
                return 4;
            }
            coords[0] = this.aSource.points[this.index * 2];
            coords[1] = this.aSource.points[this.index * 2 + 1];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

