/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSetIface;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class GriddedSet
extends SampledSet
implements GriddedSetIface {
    int[] Lengths;
    float EPS = 1.0E-15f;
    boolean Pos;

    public GriddedSet(MathType type, float[][] samples, int[] lengths) throws VisADException {
        this(type, samples, lengths, null, null, null, true);
    }

    public GriddedSet(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengths, coord_sys, units, errors, true);
    }

    public GriddedSet(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, lengths.length, coord_sys, units, errors);
        this.init_lengths(lengths);
        if (samples == null) {
            this.setMySamples(null);
        } else {
            this.init_samples(samples, copy);
        }
    }

    private void init_lengths(int[] lengths) throws VisADException {
        this.Lengths = new int[this.ManifoldDimension];
        this.Length = 1;
        for (int j = 0; j < this.ManifoldDimension; ++j) {
            if (lengths[j] < 1) {
                throw new SetException("GriddedSet: each grid length must be at least 1 (length#" + j + " is " + lengths[j]);
            }
            this.Lengths[j] = lengths[j];
            this.Length *= lengths[j];
        }
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths) throws VisADException {
        return GriddedSet.create(type, samples, lengths, null, null, null);
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        return GriddedSet.create(type, samples, lengths, coord_sys, units, errors, true, true);
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        return GriddedSet.create(type, samples, lengths, coord_sys, units, errors, copy, true);
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        int manifold_dimension = lengths.length;
        int domain_dimension = samples.length;
        if (manifold_dimension > domain_dimension) {
            throw new SetException("GriddedSet.create: manifold_dimension " + manifold_dimension + " is greater than" + " domain_dimension " + domain_dimension);
        }
        switch (domain_dimension) {
            case 1: {
                return new Gridded1DSet(type, samples, lengths[0], coord_sys, units, errors, copy);
            }
            case 2: {
                if (manifold_dimension == 1) {
                    return new Gridded2DSet(type, samples, lengths[0], coord_sys, units, errors, copy);
                }
                return new Gridded2DSet(type, samples, lengths[0], lengths[1], coord_sys, units, errors, copy, test);
            }
            case 3: {
                if (manifold_dimension == 1) {
                    return new Gridded3DSet(type, samples, lengths[0], coord_sys, units, errors, copy);
                }
                if (manifold_dimension == 2) {
                    return new Gridded3DSet(type, samples, lengths[0], lengths[1], coord_sys, units, errors, copy);
                }
                return new Gridded3DSet(type, samples, lengths[0], lengths[1], lengths[2], coord_sys, units, errors, copy, test);
            }
        }
        return new GriddedSet(type, samples, lengths, coord_sys, units, errors, copy);
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        return GriddedSet.create(type, samples, this.Lengths, null, null, null, false, false);
    }

    public int getLength(int i) {
        return this.Lengths[i];
    }

    public int[] getLengths() {
        int[] lens = new int[this.Lengths.length];
        for (int i = 0; i < this.Lengths.length; ++i) {
            lens[i] = this.Lengths[i];
        }
        return lens;
    }

    public int[] getWedge() {
        int i;
        int[] wedge = new int[this.Length];
        int len = this.Lengths[0];
        for (i = 0; i < len; ++i) {
            wedge[i] = i;
        }
        for (int dim = 1; dim < this.ManifoldDimension; ++dim) {
            boolean flip = true;
            int base = len;
            int k = len;
            for (int j = 1; j < this.Lengths[dim]; ++j) {
                if (flip) {
                    for (i = len - 1; i >= 0; --i) {
                        wedge[k] = wedge[i] + base;
                        ++k;
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        wedge[k] = wedge[i] + base;
                        ++k;
                    }
                }
                base += len;
                flip = !flip;
            }
            len *= this.Lengths[dim];
        }
        return wedge;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int[] indexI = new int[this.ManifoldDimension];
        int length = index.length;
        float[][] grid = new float[this.ManifoldDimension][length];
        for (int i = 0; i < length; ++i) {
            int j;
            if (0 <= index[i] && index[i] < this.Length) {
                int k = index[i];
                for (j = 0; j < this.ManifoldDimension - 1; ++j) {
                    indexI[j] = k % this.Lengths[j];
                    k /= this.Lengths[j];
                }
                indexI[this.ManifoldDimension - 1] = k;
            } else {
                for (j = 0; j < this.ManifoldDimension; ++j) {
                    indexI[j] = -1;
                }
            }
            for (j = 0; j < this.ManifoldDimension; ++j) {
                grid[j][i] = indexI[j];
            }
        }
        return this.gridToValue(grid);
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("GriddedSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        float[][] grid = this.valueToGrid(value);
        for (int i = 0; i < length; ++i) {
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                index[i] = -1;
                continue;
            }
            int k = (int)((double)grid[this.ManifoldDimension - 1][i] + 0.5);
            for (int j = this.ManifoldDimension - 2; j >= 0; --j) {
                if (Double.isNaN(grid[j][i])) {
                    k = -1;
                    break;
                }
                k = (int)((double)grid[j][i] + 0.5) + this.Lengths[j] * k;
            }
            index[i] = k;
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (this.Length > 1) {
            for (int j = 0; j < this.DomainDimension; ++j) {
                if (this.Lengths[j] >= 2) continue;
                throw new SetException("GriddedSet.gridToValue: requires all grid dimensions to be > 1");
            }
        }
        throw new UnimplementedException("GriddedSet.gridToValue");
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (this.Length > 1) {
            for (int j = 0; j < this.DomainDimension; ++j) {
                if (this.Lengths[j] >= 2) continue;
                throw new SetException("GriddedSet.valueToGrid: requires all grid dimensions to be > 1");
            }
        }
        throw new UnimplementedException("GriddedSet.valueToGrid");
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int j;
        if (value.length != this.DomainDimension) {
            throw new SetException("GriddedSet.valueToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("GriddedSet.valueToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("GriddedSet.valueToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        float[][] grid = this.valueToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        float[] c = new float[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        for (j = 1; j < this.ManifoldDimension; ++j) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
        }
        for (int i = 0; i < length; ++i) {
            float[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)((double)grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (float)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && (double)c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && (double)c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                if ((base = l[this.ManifoldDimension - 1]) >= this.Lengths[this.ManifoldDimension - 1]) {
                    base = -1;
                }
            }
            for (j = this.ManifoldDimension - 2; j >= 0 && base >= 0; --j) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                    continue;
                }
                l[j] = (int)((double)grid[j][i] + 0.5);
                if (l[j] == this.Lengths[j]) {
                    int n = j;
                    l[n] = l[n] - 1;
                }
                c[j] = grid[j][i] - (float)l[j];
                if (!(l[j] == 0 && (double)c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && (double)c[j] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[j] + this.Lengths[j] * base;
                if (l[j] >= 0 && l[j] < this.Lengths[j]) continue;
                base = -1;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new float[length_is];
                is[0] = base;
                cs[0] = 1.0f;
                int lis = 1;
                for (j = 0; j < this.ManifoldDimension; ++j) {
                    float b;
                    float a;
                    int isoff;
                    if (l[j] == 0 && (double)c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && (double)c[j] >= 0.0) continue;
                    if ((double)c[j] >= 0.0) {
                        isoff = off[j];
                        a = 1.0f - c[j];
                        b = c[j];
                    } else {
                        isoff = -off[j];
                        a = 1.0f + c[j];
                        b = -c[j];
                    }
                    int k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
            }
            indices[i] = is;
            weights[i] = cs;
        }
    }

    public void getNeighbors(int[][] neighbors) throws VisADException {
        switch (this.ManifoldDimension) {
            case 1: {
                neighbors[0] = new int[1];
                neighbors[this.Length - 1] = new int[1];
                neighbors[0][0] = 1;
                neighbors[this.Length - 1][0] = this.Length - 2;
                for (int ii = 1; ii < this.Length - 1; ++ii) {
                    neighbors[ii] = new int[2];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                }
                break;
            }
            case 2: {
                int ix;
                int iy;
                int LengthX = this.Lengths[0];
                int LengthY = this.Lengths[1];
                int ii = 0;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii + 1;
                ii = this.Length - 1;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii - 1;
                ii = this.Length - LengthX;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii + 1;
                ii = LengthX - 1;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii - 1;
                for (iy = 1; iy < LengthY - 1; ++iy) {
                    ii = iy * LengthX;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + 1;
                    ii = iy * LengthX + LengthX - 1;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                }
                for (ix = 1; ix < LengthX - 1; ++ix) {
                    ii = ix;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii + LengthX;
                    ii = (LengthY - 1) * LengthX + ix;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii - LengthX;
                }
                for (iy = 1; iy < LengthY - 1; ++iy) {
                    for (ix = 1; ix < LengthX - 1; ++ix) {
                        ii = iy * LengthX + ix;
                        int ii_R = ii + 1;
                        int ii_L = ii - 1;
                        int ii_U = ii + LengthX;
                        int ii_D = ii - LengthX;
                        neighbors[ii] = new int[4];
                        neighbors[ii][0] = ii_R;
                        neighbors[ii][1] = ii_L;
                        neighbors[ii][2] = ii_U;
                        neighbors[ii][3] = ii_D;
                    }
                }
                break;
            }
            case 3: {
                int iz;
                int ix;
                int b;
                int a;
                int iy;
                int LengthX = this.Lengths[0];
                int LengthY = this.Lengths[1];
                int LengthZ = this.Lengths[2];
                int LengthXY = LengthX * LengthY;
                int LengthXYZ = LengthX * LengthY * LengthZ;
                int ii = 0;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii + 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthX * LengthY * (LengthZ - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + 1;
                neighbors[ii][1] = ii + LengthX;
                neighbors[ii][2] = ii - LengthXY;
                ii = LengthX * LengthY - 1;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii - 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthX * LengthY * LengthZ - 1;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - 1;
                neighbors[ii][1] = ii - LengthX;
                neighbors[ii][2] = ii - LengthXY;
                ii = LengthX * (LengthY - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii + 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthXY * (LengthZ - 1) + LengthX * (LengthY - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + 1;
                neighbors[ii][1] = ii - LengthX;
                neighbors[ii][2] = ii - LengthXY;
                ii = LengthX - 1;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii - 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthXY * (LengthZ - 1) + (LengthX - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - 1;
                neighbors[ii][1] = ii + LengthX;
                neighbors[ii][2] = ii - LengthXY;
                for (iy = 1; iy < LengthY - 1; ++iy) {
                    a = iy * LengthX;
                    b = a + LengthX - 1;
                    ii = a;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + 1;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = a + LengthX - 1;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = a + (LengthZ - 1) * LengthXY;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = b + (LengthZ - 1) * LengthXY;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    neighbors[ii][3] = ii - LengthXY;
                }
                for (ix = 1; ix < LengthX - 1; ++ix) {
                    ii = ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii + LengthX;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = (LengthY - 1) * LengthX + ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii - LengthX;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = (LengthZ - 1) * LengthXY + ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii + LengthX;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = (LengthZ - 1) * LengthXY + (LengthY - 1) * LengthX + ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii - LengthX;
                    neighbors[ii][3] = ii - LengthXY;
                }
                for (iz = 1; iz < LengthZ - 1; ++iz) {
                    a = iz * LengthXY;
                    b = a + (LengthX - 1);
                    ii = a;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + 1;
                    neighbors[ii][1] = ii + LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = a + (LengthX - 1);
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = a + LengthX * (LengthY - 1);
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + 1;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = a + (LengthXY - 1);
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii - LengthXY;
                }
                for (iy = 1; iy < LengthY - 1; ++iy) {
                    for (ix = 1; ix < LengthX - 1; ++ix) {
                        ii = iy * LengthX + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii + LengthX;
                        neighbors[ii][3] = ii - LengthX;
                        neighbors[ii][4] = ii + LengthXY;
                        ii = (LengthZ - 1) * LengthXY + iy * LengthX + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii + LengthX;
                        neighbors[ii][3] = ii - LengthX;
                        neighbors[ii][4] = ii - LengthXY;
                    }
                }
                for (iz = 1; iz < LengthZ - 1; ++iz) {
                    for (ix = 1; ix < LengthX - 1; ++ix) {
                        ii = iz * LengthXY + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii + LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                        ii = iz * LengthXY + LengthX * (LengthY - 1) + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii - LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                    }
                }
                for (iz = 1; iz < LengthZ - 1; ++iz) {
                    for (iy = 1; iy < LengthY - 1; ++iy) {
                        ii = iz * LengthXY + iy * LengthX;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii + LengthX;
                        neighbors[ii][2] = ii - LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                        ii = iz * LengthXY + iy * LengthX + (LengthX - 1);
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii - 1;
                        neighbors[ii][1] = ii + LengthX;
                        neighbors[ii][2] = ii - LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                    }
                }
                for (iz = 1; iz < LengthZ - 1; ++iz) {
                    for (iy = 1; iy < LengthY - 1; ++iy) {
                        for (ix = 1; ix < LengthX - 1; ++ix) {
                            ii = iz * LengthXY + iy * LengthX + ix;
                            int ii_R = ii + 1;
                            int ii_L = ii - 1;
                            int ii_F = ii + LengthX;
                            int ii_B = ii - LengthX;
                            int ii_U = ii + LengthXY;
                            int ii_D = ii - LengthXY;
                            neighbors[ii] = new int[6];
                            neighbors[ii][0] = ii_R;
                            neighbors[ii][1] = ii_L;
                            neighbors[ii][2] = ii_F;
                            neighbors[ii][3] = ii_B;
                            neighbors[ii][4] = ii_U;
                            neighbors[ii][5] = ii_D;
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnimplementedException("getNeighbors(): ManifoldDimension >" + this.ManifoldDimension + " not currently implemented");
            }
        }
    }

    public int[][] getNeighbors(int manifoldIndex) {
        int[][] neighbors = new int[this.Length][2];
        int[] m_coords = new int[this.ManifoldDimension];
        int[][] indeces = new int[2][this.ManifoldDimension];
        for (int ii = 0; ii < this.Length; ++ii) {
            int kk;
            int jj;
            int ii_tmp = ii;
            for (jj = 0; jj < this.ManifoldDimension - 1; ++jj) {
                m_coords[jj] = ii_tmp % this.Lengths[jj];
                ii_tmp /= this.Lengths[jj];
            }
            m_coords[this.ManifoldDimension - 1] = ii_tmp;
            for (kk = 0; kk < 2; ++kk) {
                for (jj = 0; jj < this.ManifoldDimension; ++jj) {
                    indeces[kk][jj] = m_coords[jj];
                }
            }
            int idx_u = m_coords[manifoldIndex] + 1;
            int idx_d = m_coords[manifoldIndex] - 1;
            indeces[1][manifoldIndex] = idx_u;
            indeces[0][manifoldIndex] = idx_d;
            if (idx_u >= this.Lengths[manifoldIndex]) {
                indeces[1][manifoldIndex] = -1;
            } else if (idx_d < 0) {
                indeces[0][manifoldIndex] = -1;
            }
            for (kk = 0; kk < 2; ++kk) {
                if (indeces[kk][manifoldIndex] != -1) {
                    ii_tmp = 0;
                    for (int mm = this.ManifoldDimension - 1; mm >= 0; --mm) {
                        int k = indeces[kk][mm];
                        for (int tt2 = 0; tt2 < mm; ++tt2) {
                            k *= this.Lengths[tt2];
                        }
                        ii_tmp += k;
                    }
                    neighbors[ii][kk] = ii_tmp;
                    continue;
                }
                neighbors[ii][kk] = -1;
            }
        }
        return neighbors;
    }

    public boolean equals(Object set) {
        if (!(set instanceof GriddedSet) || set == null || set instanceof LinearSet || set instanceof Gridded1DDoubleSet) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            int j;
            if (this.DomainDimension != ((GriddedSet)set).getDimension() || this.ManifoldDimension != ((GriddedSet)set).getManifoldDimension() || this.Length != ((GriddedSet)set).getLength()) {
                return false;
            }
            for (j = 0; j < this.ManifoldDimension; ++j) {
                if (this.Lengths[j] == ((GriddedSet)set).getLength(j)) continue;
                return false;
            }
            float[][] samples = ((GriddedSet)set).getSamples(false);
            float[][] mySamples = this.getMySamples();
            if (mySamples != null) {
                for (j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        if (!(mySamples[j][i] == mySamples[j][i] ? mySamples[j][i] != samples[j][i] : samples[j][i] == samples[j][i])) continue;
                        this.addNotEqualsCache((Set)set);
                        return false;
                    }
                }
            } else {
                float[][] this_samples = this.getSamples(false);
                for (j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        if (!(this_samples[j][i] == this_samples[j][i] ? this_samples[j][i] != samples[j][i] : samples[j][i] == samples[j][i])) continue;
                        this.addNotEqualsCache((Set)set);
                        return false;
                    }
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            this.hashCode ^= this.DomainDimension ^ this.ManifoldDimension ^ this.Length;
            for (int j = 0; j < this.ManifoldDimension; ++j) {
                this.hashCode ^= this.Lengths[j];
            }
            float[][] mySamples = this.getMySamples();
            if (mySamples != null) {
                for (int j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        this.hashCode ^= Float.floatToIntBits(mySamples[j][i]);
                    }
                }
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new GriddedSet(type, this.getMySamples(), this.Lengths, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String pre) throws VisADException {
        String s;
        if (this.DomainDimension == this.ManifoldDimension) {
            s = pre + this.getClass().getName() + ": Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
            for (int j = 0; j < this.DomainDimension; ++j) {
                s = s + pre + "  Dimension " + j + ":" + " Length = " + this.Lengths[j] + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
            }
        } else {
            int j;
            s = pre + this.getClass().getName() + ": DomainDimension = " + this.DomainDimension + " ManifoldDimension = " + this.ManifoldDimension + " Length = " + this.Length + "\n";
            for (j = 0; j < this.ManifoldDimension; ++j) {
                s = s + pre + "  ManifoldDimension " + j + ":" + " Length = " + this.Lengths[j] + "\n";
            }
            for (j = 0; j < this.DomainDimension; ++j) {
                s = s + pre + "  DomainDimension " + j + ":" + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
            }
        }
        return s;
    }
}

