/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.awt.image.IndexColorModel;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.IntegerNDSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Text;
import visad.TextType;
import visad.TypeException;
import visad.VisADException;
import visad.data.hdf5.HDF5AdapterException;
import visad.data.hdf5.HDF5DataAdaptable;
import visad.data.hdf5.hdf5objects.HDF5Dataset;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;

public class HDF5DatasetAdapted
extends HDF5Dataset
implements HDF5DataAdaptable {
    MathType field_type;
    RealTupleType domain;
    RealTupleType range;
    DataImpl dataField;

    public HDF5DatasetAdapted() {
    }

    public HDF5DatasetAdapted(int loc_id, String set_name, int type_id, int space_id, int create_plist_id) {
        super(loc_id, set_name, type_id, space_id, create_plist_id);
    }

    public HDF5DatasetAdapted(int loc_id, String set_name) {
        super(loc_id, set_name);
    }

    public void init() throws HDF5Exception {
        super.init();
        if (this.rank <= 0) {
            return;
        }
        if (this.data == null) {
            try {
                this.data = this.readData();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        boolean isImage = false;
        try {
            int pal_id = H5.H5Aopen_name(this.id, "PALETTE");
            int pal_type = H5.H5Aget_type(pal_id);
            int pal_class = H5.H5Tget_class(pal_type);
            if (pal_class == 7) {
                isImage = true;
            }
            H5.H5Tclose(pal_type);
            H5.H5Aclose(pal_id);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.data.getClass().getName().endsWith("Ljava.lang.String;")) {
            this.mapToText();
        } else if (isImage) {
            try {
                this.mapToImage();
            }
            catch (Exception e) {
                throw new HDF5Exception(e.toString());
            }
        } else {
            this.mapToFlatField();
        }
    }

    private void mapToImage() throws HDF5Exception, VisADException {
        int w = (int)this.dims[0];
        int h = (int)this.dims[1];
        int aid = H5.H5Aopen_name(this.id, "PALETTE");
        byte[] ref_buf = new byte[8];
        int atype = H5.H5Aget_type(aid);
        H5.H5Aread(aid, atype, ref_buf);
        H5.H5Tclose(atype);
        int pal_id = H5.H5Rdereference(this.id, 0, ref_buf);
        HDF5Datatype pal_datatype = new HDF5Datatype();
        pal_datatype.setID(H5.H5Dget_type(pal_id));
        HDF5Dataspace pal_dataspace = new HDF5Dataspace();
        pal_dataspace.setID(H5.H5Dget_space(pal_id));
        byte[] palette = new byte[768];
        H5.H5Dread(pal_id, H5.H5Dget_type(pal_id), -2, -2, -2, palette);
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = palette[3 * i];
            g[i] = palette[3 * i + 1];
            b[i] = palette[3 * i + 2];
        }
        IndexColorModel icm = new IndexColorModel(8, 256, r, g, b, 0);
        int num_pixels = w * h;
        int pixel_val = -1;
        float[][] pixel_rgb = new float[3][num_pixels];
        for (int i = 0; i < num_pixels; ++i) {
            pixel_val = Integer.parseInt(Array.get(this.data, i).toString());
            pixel_rgb[0][i] = icm.getRed(pixel_val);
            pixel_rgb[1][i] = icm.getGreen(pixel_val);
            pixel_rgb[2][i] = icm.getBlue(pixel_val);
        }
        RealType line = RealType.getRealType("ImageLine");
        RealType element = RealType.getRealType("ImageElement");
        RealType c_red = RealType.getRealType("Red");
        RealType c_green = RealType.getRealType("Green");
        RealType c_blue = RealType.getRealType("Blue");
        RealType[] c_all = new RealType[]{c_red, c_green, c_blue};
        RealTupleType radiance = new RealTupleType(c_all);
        RealType[] domain_components = new RealType[]{element, line};
        RealTupleType image_domain = new RealTupleType(domain_components);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (float)((double)w - 1.0), w, (float)((double)h - 1.0), 0.0, h);
        FunctionType image_type = new FunctionType(image_domain, radiance);
        FlatField image_field = new FlatField(image_type, domain_set);
        try {
            image_field.setSamples(pixel_rgb, false);
        }
        catch (RemoteException e) {
            throw new HDF5Exception("setSamples for image failed.");
        }
        this.field_type = image_type;
        this.domain = image_domain;
        this.range = radiance;
        this.dataField = image_field;
        H5.H5Aclose(aid);
    }

    private void mapToText() throws HDF5Exception {
        String text = "";
        if (this.data.getClass().isArray()) {
            int no_lines = Array.getLength(this.data);
            for (int i = 0; i < no_lines; ++i) {
                text = text + "\n" + Array.get(this.data, i).toString();
            }
        } else {
            text = this.data.toString();
        }
        TextType tt2 = null;
        String tname = new String(this.shortName).replace('-', '_');
        try {
            tt2 = new TextType(tname);
        }
        catch (TypeException e) {
            tt2 = (TextType)TextType.getScalarTypeByName(tname);
        }
        catch (VisADException e) {
            throw new HDF5Exception(e.toString());
        }
        try {
            this.dataField = new Text(tt2, text);
            this.field_type = this.dataField.getType();
        }
        catch (VisADException e) {
            throw new HDF5Exception(e.toString());
        }
    }

    private void mapToFlatField() throws HDF5Exception {
        try {
            RealType[] dimension_types = new RealType[this.rank];
            String dname = "";
            for (int i = 0; i < this.rank; ++i) {
                dname = "dim" + String.valueOf(i);
                dimension_types[i] = RealType.getRealType(dname);
            }
            this.domain = new RealTupleType(dimension_types);
        }
        catch (VisADException e) {
            throw new HDF5Exception("Constructing the domain of HDF5DatasetAdapted failed. " + e);
        }
        try {
            RealType[] range_types = null;
            String rname = "";
            if (this.data instanceof Vector) {
                int num_members = this.member_names.size();
                range_types = new RealType[num_members];
                for (int i = 0; i < num_members; ++i) {
                    rname = (String)this.member_names.elementAt(i);
                    range_types[i] = RealType.getRealType(rname);
                }
            } else {
                range_types = new RealType[1];
                rname = new String(this.shortName).replace('-', '_');
                range_types[0] = RealType.getRealType(rname);
            }
            this.range = new RealTupleType(range_types);
        }
        catch (VisADException e) {
            throw new HDF5Exception("Constructing the range of HDF5DatasetAdapted failed. " + e);
        }
        try {
            this.field_type = new FunctionType(this.domain, this.range);
        }
        catch (VisADException e) {
            throw new HDF5Exception("Constructing the field_type of HDF5DatasetAdapted failed. " + e);
        }
        try {
            this.dataField = this.defineDataField();
        }
        catch (Exception e) {
            throw new HDF5Exception("Constructing the data field of HDF5DatasetAdapted failed. " + e);
        }
    }

    private FieldImpl defineDataField() throws HDF5Exception, VisADException, RemoteException {
        int[] d;
        FlatField ff = null;
        boolean isSupportedType = false;
        IntegerNDSet domain_set = null;
        int data_type = this.datatype.get_class();
        boolean bl = isSupportedType = data_type == 0 || data_type == 1 || data_type == 6 && this.member_names.size() > 0;
        if (isSupportedType) {
            d = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                d[i] = (int)this.dims[i];
            }
        } else {
            throw new HDF5AdapterException("constructing data field.");
        }
        domain_set = new IntegerNDSet((MathType)this.domain, d);
        ff = new FlatField((FunctionType)this.field_type, domain_set);
        if (this.data != null) {
            int number_of_range_components = 0;
            int number_of_range_samples = 0;
            if (data_type == 6) {
                Vector cdata = (Vector)this.data;
                number_of_range_components = this.member_names.size();
                number_of_range_samples = Array.getLength(cdata.elementAt(0));
            } else {
                number_of_range_components = 1;
                number_of_range_samples = Array.getLength(this.data);
            }
            float[][] theRange = new float[number_of_range_components][number_of_range_samples];
            Object theData = null;
            for (int i = 0; i < number_of_range_samples; ++i) {
                if (data_type == 6) {
                    Vector cdata = (Vector)this.data;
                    for (int k = 0; k < number_of_range_components; ++k) {
                        theData = cdata.elementAt(k);
                        theRange[k][i] = Float.parseFloat(Array.get(theData, i).toString());
                    }
                    continue;
                }
                theRange[0][i] = Float.parseFloat(Array.get(this.data, i).toString());
            }
            ff.setSamples(theRange, false);
        }
        return ff;
    }

    public MathType getMathType() throws VisADException {
        return this.field_type;
    }

    public DataImpl getAdaptedData() throws VisADException, RemoteException {
        return this.dataField;
    }

    public DataImpl getAdaptedData(int[] indexes) throws VisADException, RemoteException {
        return this.dataField;
    }
}

