/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.CacheStrategy;
import visad.data.FormNode;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.GctpMap;
import visad.data.hdfeos.Hdfeos;
import visad.data.hdfeos.HdfeosData;
import visad.data.hdfeos.HdfeosDomain;
import visad.data.hdfeos.HdfeosDomainMap;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.HdfeosField;
import visad.data.hdfeos.HdfeosFile;
import visad.data.hdfeos.HdfeosFlatField;
import visad.data.hdfeos.HdfeosTuple;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.Shape;
import visad.data.hdfeos.ShapeSet;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

public class HdfeosForm
extends Hdfeos {
    static CacheStrategy c_strategy = new CacheStrategy();

    public HdfeosForm() {
        super("Default");
    }

    HdfeosForm(String formName) {
        super(formName);
    }

    public DataImpl open(String file_path) throws VisADException, RemoteException {
        DataImpl data = null;
        HdfeosFile file = new HdfeosFile(file_path);
        data = this.getFileData(file);
        return data;
    }

    public DataImpl open(URL url) throws VisADException {
        throw new UnimplementedException("HdfeosForm.open( URL url )");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("HdfeosForm.add");
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, RemoteException, VisADException {
        throw new UnimplementedException("HdfeosForm.save");
    }

    public FormNode getForms(Data data) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MathType getMathType(HdfeosFile file) throws VisADException, RemoteException {
        MathType M_type = null;
        HdfeosData data = null;
        int n_structs = file.getNumberOfStructs();
        if (n_structs == 0) {
            throw new HdfeosException("no HDF-EOS data structures in file: " + file.getFileName());
        }
        MathType[] types = new MathType[n_structs];
        for (int ii = 0; ii < n_structs; ++ii) {
            EosStruct obj = file.getStruct(ii);
            if (obj instanceof EosGrid) {
                data = this.getGridData((EosGrid)obj);
            } else if (obj instanceof EosSwath) {
                data = this.getSwathData((EosSwath)obj);
            }
            try {
                M_type = data.getType();
                continue;
            }
            catch (VisADException e) {
                System.out.println(e.getMessage());
                continue;
            }
            finally {
                types[ii] = M_type;
            }
        }
        TupleType t_type = new TupleType(types);
        return t_type;
    }

    DataImpl getFileData(HdfeosFile file) throws VisADException, RemoteException {
        Object data = null;
        HdfeosData f_data = null;
        int n_structs = file.getNumberOfStructs();
        if (n_structs == 0) {
            throw new HdfeosException("no EOS data structures in file: " + file.getFileName());
        }
        HdfeosData[] datas = new HdfeosData[n_structs];
        for (int ii = 0; ii < n_structs; ++ii) {
            EosStruct obj = file.getStruct(ii);
            if (obj instanceof EosGrid) {
                f_data = this.getGridData((EosGrid)obj);
            } else if (obj instanceof EosSwath) {
                f_data = this.getSwathData((EosSwath)obj);
            }
            datas[ii] = f_data;
        }
        return this.assembleStructs(datas);
    }

    private DataImpl assembleStructs(HdfeosData[] h_datas) throws VisADException, RemoteException {
        DataImpl fileData = null;
        int n_structs = h_datas.length;
        if (n_structs == 1) {
            return this.getVisADDataObject(h_datas[0]);
        }
        boolean types_equal = true;
        MathType[] types = new MathType[n_structs];
        Data[] datas = new DataImpl[n_structs];
        datas[0] = this.getVisADDataObject(h_datas[0]);
        types[0] = datas[0].getType();
        MathType first_type = types[0];
        for (int ii = 1; ii < n_structs; ++ii) {
            datas[ii] = this.getVisADDataObject(h_datas[ii]);
            types[ii] = datas[ii].getType();
            if (types[ii].equals(first_type)) continue;
            types_equal = false;
        }
        if (types_equal) {
            RealType struct_id = RealType.getRealType("struct_id");
            Integer1DSet domain = new Integer1DSet((MathType)struct_id, n_structs);
            FieldImpl field = new FieldImpl(new FunctionType(struct_id, first_type), domain);
            for (int ii = 0; ii < n_structs; ++ii) {
                field.setSample(ii, datas[ii]);
            }
            fileData = field;
        } else {
            TupleType t_type = new TupleType(types);
            fileData = new Tuple(t_type, datas, false);
        }
        return fileData;
    }

    DataImpl getVisADDataObject(HdfeosData h_data) throws VisADException, RemoteException {
        return h_data.getData();
    }

    HdfeosData getGridData(EosGrid grid) throws HdfeosException, VisADException, RemoteException {
        int ii;
        Vector<HdfeosData> datas = new Vector<HdfeosData>();
        ShapeSet DV_shapeSet = grid.getShapeSet();
        GctpMap gridMap = grid.getMap();
        VariableSet vars_1D = DV_shapeSet.get1DVariables();
        Enumeration e_out = DV_shapeSet.getEnum();
        while (e_out.hasMoreElements()) {
            HdfeosFlatField f_field;
            Shape s_obj = (Shape)e_out.nextElement();
            DimensionSet D_set = s_obj.getShape();
            int d_size = D_set.getSize();
            VariableSet range_var = s_obj.getVariables();
            DimensionSet G_dims = new DimensionSet();
            DimensionSet D_dims = new DimensionSet();
            for (ii = 0; ii < d_size; ++ii) {
                NamedDimension dim = D_set.getElement(ii);
                if (dim.getName().equals("XDim") || dim.getName().equals("YDim")) {
                    G_dims.add(dim);
                    continue;
                }
                D_dims.add(dim);
            }
            if (G_dims.getSize() != 2) {
                HdfeosDomain domain = new HdfeosDomain((EosStruct)grid, D_set);
                f_field = new HdfeosFlatField(domain, range_var);
                datas.addElement(f_field);
                continue;
            }
            HdfeosDomainMap geo_domain = new HdfeosDomainMap((EosStruct)grid, G_dims, gridMap);
            f_field = new HdfeosFlatField((HdfeosDomain)geo_domain, range_var);
            if (D_dims.getSize() == 0) {
                datas.addElement(f_field);
                continue;
            }
            HdfeosField field = this.makeField(grid, D_dims, f_field);
            datas.addElement(field);
        }
        int n_datas = datas.size();
        if (n_datas == 0) {
            return null;
        }
        if (n_datas == 1) {
            return (HdfeosData)datas.elementAt(0);
        }
        HdfeosData[] array = new HdfeosData[n_datas];
        for (ii = 0; ii < n_datas; ++ii) {
            array[ii] = (HdfeosData)datas.elementAt(ii);
        }
        return new HdfeosTuple(array);
    }

    HdfeosData getSwathData(EosSwath swath) throws VisADException, RemoteException, HdfeosException {
        Shape s_obj;
        DimensionSet F_dims = null;
        DimensionSet Geo_set = null;
        Variable Latitude2 = null;
        Variable Longitude2 = null;
        Variable Time2 = null;
        HdfeosDomain domain = null;
        HdfeosDomain geo_domain = null;
        HdfeosFlatField f_field = null;
        HdfeosField field = null;
        ShapeSet DV_shapeSet = swath.getDV_shapeSet();
        ShapeSet GV_shapeSet = swath.getGV_shapeSet();
        Vector<HdfeosData> datas = new Vector<HdfeosData>();
        Enumeration e = GV_shapeSet.getEnum();
        while (e.hasMoreElements()) {
            s_obj = (Shape)e.nextElement();
            VariableSet v_set = s_obj.getVariables();
            Variable var = v_set.getByName("Latitude");
            if (var != null) {
                Latitude2 = var;
            }
            if ((var = v_set.getByName("Longitude")) != null) {
                Longitude2 = var;
            }
            var = v_set.getByName("Time");
            if (Time2 == null) continue;
            Time2 = var;
        }
        if (Latitude2 == null || Longitude2 == null) {
            geo_domain = null;
        } else {
            Variable[] g_vars = new Variable[]{Longitude2, Latitude2};
            Geo_set = Longitude2.getDimSet();
            if (Latitude2.getDimSet().sameSetSameOrder(Geo_set)) {
                int g_rank = Latitude2.getDimSet().getSize();
                if (g_rank == 1) {
                    geo_domain = null;
                    domain = new HdfeosDomain((EosStruct)swath, Geo_set);
                    f_field = new HdfeosFlatField(domain, g_vars);
                    datas.addElement(f_field);
                } else if (g_rank == 2) {
                    geo_domain = new HdfeosDomain((EosStruct)swath, g_vars, Geo_set.getElements());
                } else if (g_rank > 2) {
                    geo_domain = null;
                    domain = new HdfeosDomain((EosStruct)swath, Geo_set);
                    f_field = new HdfeosFlatField(domain, g_vars);
                    datas.addElement(f_field);
                }
            } else {
                geo_domain = null;
                domain = new HdfeosDomain((EosStruct)swath, Latitude2.getDimSet());
                f_field = new HdfeosFlatField(domain, Latitude2);
                datas.addElement(f_field);
                domain = new HdfeosDomain((EosStruct)swath, Longitude2.getDimSet());
                f_field = new HdfeosFlatField(domain, Longitude2);
                datas.addElement(f_field);
            }
        }
        if (Time2 != null) {
            domain = new HdfeosDomain((EosStruct)swath, Time2.getDimSet());
            f_field = new HdfeosFlatField(domain, Time2);
            datas.addElement(f_field);
        }
        Enumeration e_out = DV_shapeSet.getEnum();
        while (e_out.hasMoreElements()) {
            s_obj = (Shape)e_out.nextElement();
            DimensionSet D_set = s_obj.getShape();
            int d_size = D_set.getSize();
            VariableSet range_var = s_obj.getVariables();
            if (geo_domain == null) {
                domain = new HdfeosDomain((EosStruct)swath, D_set);
                f_field = new HdfeosFlatField(domain, range_var);
                datas.addElement(f_field);
                continue;
            }
            DimensionSet G_dims = new DimensionSet();
            DimensionSet D_dims = new DimensionSet();
            for (int ii = 0; ii < d_size; ++ii) {
                NamedDimension dim = D_set.getElement(ii);
                if (dim.isGeoMapDefined() || GV_shapeSet.isMemberOf(dim)) {
                    G_dims.add(dim);
                    continue;
                }
                D_dims.add(dim);
            }
            int g_size = G_dims.getSize();
            if (g_size == 0 || g_size == 1) {
                domain = new HdfeosDomain((EosStruct)swath, D_set);
                f_field = new HdfeosFlatField(domain, range_var);
                datas.addElement(f_field);
                continue;
            }
            if (g_size == 2) {
                F_dims = D_dims;
                HdfeosDomain img_domain = new HdfeosDomain((EosStruct)swath, G_dims, geo_domain);
                f_field = new HdfeosFlatField(img_domain, range_var);
                if (F_dims.getSize() == 0) {
                    datas.add(f_field);
                    continue;
                }
                int len = F_dims.getSize();
                boolean any = false;
                for (int ii = 0; ii < len; ++ii) {
                    if (D_set.getIndexOf(F_dims.getElement(ii)) <= D_set.getIndexOf(G_dims.getElement(1))) continue;
                    any = true;
                }
                if (any) {
                    domain = new HdfeosDomain((EosStruct)swath, D_set);
                    f_field = new HdfeosFlatField(domain, range_var);
                    datas.addElement(f_field);
                    continue;
                }
                field = this.makeField(swath, F_dims, f_field);
                datas.add(field);
                continue;
            }
            if (g_size < 3) continue;
            domain = new HdfeosDomain((EosStruct)swath, D_set);
            f_field = new HdfeosFlatField(domain, range_var);
            datas.addElement(f_field);
        }
        int n_datas = datas.size();
        if (n_datas == 0) {
            return null;
        }
        if (n_datas == 1) {
            return (HdfeosData)datas.elementAt(0);
        }
        HdfeosData[] array = new HdfeosData[n_datas];
        for (int ii = 0; ii < n_datas; ++ii) {
            array[ii] = (HdfeosData)datas.elementAt(ii);
        }
        return new HdfeosTuple(array);
    }

    HdfeosField makeField(EosStruct struct, DimensionSet F_dims, HdfeosData t_data) throws VisADException, RemoteException, HdfeosException {
        HdfeosData range = t_data;
        HdfeosDomain domain = null;
        HdfeosField field = null;
        for (int ii = F_dims.getSize() - 1; ii >= 0; --ii) {
            domain = new HdfeosDomain(struct, F_dims.getElement(ii));
            field = new HdfeosField(domain, range);
            range = field;
        }
        return field;
    }
}

