/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.TextType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryString;

public class BinaryTextType
implements BinaryObject {
    public static final int computeBytes(TextType tt2) {
        return 5 + BinaryString.computeBytes(tt2.getName()) + 1;
    }

    public static final TextType read(BinaryReader reader, int index) throws IOException, VisADException {
        String name = BinaryString.read(reader);
        DataInput file = reader.getInput();
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no TextType end-marker)");
        }
        TextType tt2 = TextType.getTextType(name);
        BinaryObjectCache cache = reader.getTypeCache();
        cache.add(index, tt2);
        return tt2;
    }

    public static final int write(BinaryWriter writer, TextType tt2, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(tt2);
        if (index < 0) {
            index = cache.add(tt2);
            if (index < 0) {
                throw new IOException("Couldn't cache TextType " + tt2);
            }
            if (!(tt2.getClass().equals(TextType.class) || tt2 instanceof TextType && tt2 instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, tt2, token);
                return index;
            }
            String name = tt2.getName();
            int objLen = BinaryTextType.computeBytes(tt2);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(5);
            BinaryString.write(writer, name, token);
            file.writeByte(80);
        }
        return index;
    }
}

