/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.Data;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryDataArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryTupleType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryTuple
implements BinaryObject {
    public static final int computeBytes(Data[] components) {
        int compsLen = components == null ? 0 : 1 + BinaryDataArray.computeBytes(components);
        return 10 + compsLen + 1;
    }

    public static final Tuple read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        TupleType tt2 = (TupleType)cache.get(typeIndex);
        Data[] components = null;
        boolean reading = true;
        block6: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 8: {
                    components = BinaryDataArray.read(reader);
                    continue block6;
                }
                case 80: {
                    reading = false;
                    continue block6;
                }
            }
            throw new IOException("Unknown Tuple directive " + directive);
        }
        return new Tuple(tt2, components);
    }

    private static final void writeDependentData(BinaryWriter writer, TupleType type, Data[] components, Tuple t, Object token) throws IOException {
        if (!(t.getClass().equals(Tuple.class) || t instanceof Tuple && t instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        BinaryTupleType.write(writer, type, SAVE_DATA);
        if (components != null) {
            BinaryDataArray.write(writer, components, dependToken);
        }
    }

    public static final void write(BinaryWriter writer, TupleType type, Data[] components, Tuple t, Object token) throws IOException {
        BinaryTuple.writeDependentData(writer, type, components, t, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(t.getClass().equals(Tuple.class) || t instanceof Tuple && t instanceof Saveable)) {
            BinaryUnknown.write(writer, t, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("TupleType " + type + " not cached");
        }
        int objLen = BinaryTuple.computeBytes(components);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(10);
        file.writeInt(typeIndex);
        if (components != null) {
            file.writeByte(8);
            BinaryDataArray.write(writer, components, token);
        }
        file.writeByte(80);
    }
}

