/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.MathType;
import visad.RealTupleType;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryTupleType
implements BinaryObject {
    public static final int computeBytes(TupleType tt2) {
        return 5 + tt2.getDimension() * 4 + 1;
    }

    public static final TupleType read(BinaryReader reader, int index, int objLen) throws IOException, VisADException {
        MathType[] list = BinaryMathType.readList(reader, (objLen - 1) / 4);
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no TupleType end-marker)");
        }
        TupleType tt2 = new TupleType(list);
        cache.add(index, tt2);
        return tt2;
    }

    public static final int write(BinaryWriter writer, TupleType tt2, Object token) throws IOException {
        if (tt2 instanceof RealTupleType) {
            return BinaryRealTupleType.write(writer, (RealTupleType)tt2, token);
        }
        int dim = tt2.getDimension();
        int[] types = new int[dim];
        for (int i = 0; i < dim; ++i) {
            MathType comp;
            try {
                comp = tt2.getComponent(i);
            }
            catch (VisADException ve) {
                throw new IOException("Couldn't get TupleType component #" + i + ": " + ve.getMessage());
            }
            types[i] = BinaryMathType.write(writer, comp, token);
        }
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(tt2);
        if (index < 0) {
            index = cache.add(tt2);
            if (index < 0) {
                throw new IOException("Couldn't cache TupleType " + tt2);
            }
            if (!(tt2.getClass().equals(TupleType.class) || tt2 instanceof TupleType && tt2 instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, tt2, token);
                return index;
            }
            int objLen = BinaryTupleType.computeBytes(tt2);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(6);
            for (int i = 0; i < dim; ++i) {
                file.writeInt(types[i]);
            }
            file.writeByte(80);
        }
        return index;
    }
}

