/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.VisADCanvasJ3D;

public class ProjectionControlJ3D
extends ProjectionControl {
    private transient Transform3D Matrix;
    transient Vector switches = new Vector();
    int which_child = 2;
    public static final int X_PLUS = 0;
    public static final int X_MINUS = 1;
    public static final int Y_PLUS = 2;
    public static final int Y_MINUS = 3;
    public static final int Z_PLUS = 4;
    public static final int Z_MINUS = 5;

    public ProjectionControlJ3D(DisplayImpl d) throws VisADException {
        super(d);
        this.Matrix = this.init();
        this.matrix = new double[16];
        this.Matrix.get(this.matrix);
        this.saveProjection();
    }

    public void setMatrix(double[] m) throws VisADException, RemoteException {
        super.setMatrix(m);
        this.Matrix = new Transform3D(this.matrix);
        VisADCanvasJ3D canvas = ((DisplayRendererJ3D)this.getDisplayRenderer()).getCanvas();
        if (canvas != null && canvas.getOffscreen()) {
            try {
                Method renderMethod = Canvas3D.class.getMethod("renderOffScreenBuffer", new Class[0]);
                renderMethod.invoke((Object)canvas, new Object[0]);
                Method waitMethod = Canvas3D.class.getMethod("waitForOffScreenRendering", new Class[0]);
                waitMethod.invoke((Object)canvas, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        ((DisplayRendererJ3D)this.getDisplayRenderer()).setTransform3D(this.Matrix);
        if (!this.switches.isEmpty()) {
            this.selectSwitches();
        }
        this.changeControl(false);
    }

    public void setAspect(double[] aspect) throws VisADException, RemoteException {
        if (aspect == null || aspect.length != 3) {
            throw new DisplayException("aspect array must be length = 3");
        }
        Transform3D transform = new Transform3D();
        transform.setScale(new Vector3d(aspect[0], aspect[1], aspect[2]));
        double[] mult = new double[16];
        transform.get(mult);
        Transform3D mat = this.init();
        double[] m = new double[16];
        mat.get(m);
        this.setMatrix(this.getDisplay().multiply_matrix(mult, m));
        this.saveProjection();
    }

    private Transform3D init() {
        Transform3D mat = new Transform3D();
        double scale = 0.5;
        if (this.getDisplayRenderer().getMode2D()) {
            scale = 0.65;
        }
        Transform3D t1 = new Transform3D(MouseBehaviorJ3D.static_make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0));
        mat.mul(t1);
        return mat;
    }

    public void addPair(Switch sw, DataRenderer re) {
        this.switches.addElement(new SwitchProjection(sw, re));
        sw.setWhichChild(this.which_child);
    }

    private void selectSwitches() {
        int old_which_child = this.which_child;
        Transform3D tt2 = new Transform3D(this.Matrix);
        tt2.invert();
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d eye = new Point3d(0.0, 0.0, 1.0);
        tt2.transform(origin);
        tt2.transform(eye);
        double dx = eye.x - origin.x;
        double dy = eye.y - origin.y;
        double dz = eye.z - origin.z;
        double ax = Math.abs(dx);
        double ay = Math.abs(dy);
        double az = Math.abs(dz);
        if (az >= ay && az >= ax) {
            this.which_child = dz > 0.0 ? 2 : 5;
        } else if (ay >= ax) {
            this.which_child = dy > 0.0 ? 1 : 4;
        } else {
            int n = this.which_child = dx > 0.0 ? 0 : 3;
        }
        if (old_which_child == this.which_child) {
            return;
        }
        Enumeration pairs = ((Vector)this.switches.clone()).elements();
        while (pairs.hasMoreElements()) {
            SwitchProjection ss = (SwitchProjection)pairs.nextElement();
            ss.swit.setWhichChild(this.which_child);
        }
    }

    public void clearSwitches(DataRenderer re) {
        Enumeration pairs = ((Vector)this.switches.clone()).elements();
        while (pairs.hasMoreElements()) {
            SwitchProjection ss = (SwitchProjection)pairs.nextElement();
            if (!ss.renderer.equals(re)) continue;
            this.switches.removeElement(ss);
        }
    }

    public void setOrthoView(int view) throws VisADException, RemoteException {
        double[] viewMatrix;
        if (this.getDisplayRenderer().getMode2D()) {
            return;
        }
        switch (view) {
            case 4: {
                viewMatrix = this.getDisplay().make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                viewMatrix = this.getDisplay().make_matrix(0.0, 180.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                viewMatrix = this.getDisplay().make_matrix(-90.0, 180.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                viewMatrix = this.getDisplay().make_matrix(90.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 0: {
                viewMatrix = this.getDisplay().make_matrix(0.0, 90.0, 90.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 1: {
                viewMatrix = this.getDisplay().make_matrix(0.0, -90.0, -90.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            default: {
                viewMatrix = this.getDisplay().make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
            }
        }
        this.setMatrix(this.getDisplay().multiply_matrix(viewMatrix, this.getSavedProjectionMatrix()));
    }

    private class SwitchProjection {
        Switch swit;
        DataRenderer renderer;

        SwitchProjection(Switch sw, DataRenderer re) {
            this.swit = sw;
            this.renderer = re;
        }
    }
}

