#! c:/mks/mksnt/sh.exe
#
# setup for exporting the gov.noaa.pmel tree
#
export CVSROOT=":pserver:dwd@heron:/home/heron2/cvsroot"
doctar=/dwd/java/gov/noaa/pmel/doc.tar.gz
doclog=/dwd/java/gov/noaa/pmel/doc.log
#
# save old directories
#
cd e:/tmp
mv $doclog ${doclog}.old
#
# export most recent code
#
echo "Checkout most recent source"
#
cvs export -D now gov > $doclog 2>&1
#
JDK13=e:/java/jdk1.3

CLASS_SOURCES="e:/shared/src;e:/shared/src/java;e:/dwd/java/ucar19990210/src;$JDK13/src"

PMEL_PACKAGES="gov.noaa.pmel.swing \
               gov.noaa.pmel.util \
               gov.noaa.pmel.text \
               gov.noaa.pmel.eps"

SGT_PACKAGES="gov.noaa.pmel.sgt \
              gov.noaa.pmel.sgt.awt \
              gov.noaa.pmel.sgt.util \
              gov.noaa.pmel.sgt.dm \
              gov.noaa.pmel.sgt.demo \
              gov.noaa.pmel.sgt.swing \
	      gov.noaa.pmel.sgt.swing.prop"

NETCDF_PACKAGES="ucar.netcdf \
                 ucar.multiarray \
                 ucar.util"

JAVA_PACKAGES="java.awt \
               java.lang \
               java.util \
               java.text \
               java.beans \
               java.applet \
               java.net \
               javax.swing"

if  [ "$1" = "public" ] ; then
    DOC_OPTIONS="-author -version -public"
elif  [ "$1" = "quick" ] ; then
    DOC_OPTIONS="-author -version"
    JAVA_PACKAGES=""
elif [ "$1" = "private" ] ; then
    DOC_OPTIONS="-author -version -private"
elif [ $# = 0 ]; then
    DOC_OPTIONS="-author -version -public"
fi
#
mkdir e:/tmp/doc
#
echo "Generate javadoc"
#
$JDK13/bin/javadoc -J-mx128m -J-ms128m \
  -sourcepath $CLASS_SOURCES $DOC_OPTIONS \
  -d e:/tmp/doc \
  -use \
  -splitindex \
  -stylesheetfile e:/shared/scripts/doc_stylesheet.css \
  -windowtitle "Java Documentation" \
  -doctitle "Java Tools" \
  -bottom "<em>Generated at `date`.</em>" \
  -group "Sgt Graphics Packages" "gov.noaa.pmel.sgt*" \
  -group "PMEL/EPIC Packages" "gov.noaa.pmel.swing:gov.noaa.pmel.util:gov.noaa.pmel.eps:gov.noaa.pmel.text" \
  -group "Netcdf Packages" "ucar.netcdf:ucar.multiarray:ucar.util" \
  -group "Swing Packages" "javax.swing*" \
  -group "Java Packages" "java.*" \
  $SGT_PACKAGES \
  $PMEL_PACKAGES \
  $NETCDF_PACKAGES \
  $JAVA_PACKAGES >> $doclog 2>&1
#
# tar documentation
#
echo "Create compressed tar file"
#
cd e:/tmp; tar -zcf $doctar doc
#
# clean up
#
rm -rf e:/tmp/gov
rm -rf e:/tmp/doc
rm -f ${doclog}.old
#
read yn?"Install doc.tar.gz on www.epic.noaa.gov [y or n]? "
if [ "$yn" != "y" ] ; then
 exit 0
fi
#
echo "Copying doc.tar.gz"
#
ftpjob=ftpjob.$$
cat <<EOF > $ftpjob
user dwd Xtal-ice
binary
put $doctar
bye
EOF
#
echo "Running ftp..."
#
ftp -n -v -s:${ftpjob} www.epic.noaa.gov
#
\rm $ftpjob
#
rrm="c:/winnt/system32/rsh www.epic.noaa.gov /bin/rm "
rtar="c:/winnt/system32/rsh www.epic.noaa.gov /usr/local/bin/tar "
rmv="c:/winnt/system32/rsh www.epic.noaa.gov /bin/mv "
#
docdir=/home/plover/web/htdocs/java/doc
#
$rmv $docdir ${docdir}.old
$rtar -xzf doc.tar.gz
$rmv doc $docdir
$rrm -r ${docdir}.old
#
echo " "
echo "Done installing javadoc."
